/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.TransactionMessageProducer;
import org.joyqueue.client.internal.producer.checker.ProduceMessageChecker;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendPrepareResult;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.exception.ProducerException;
import org.joyqueue.client.internal.producer.helper.ProducerHelper;
import org.joyqueue.client.internal.producer.support.MessageProducerInner;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionMessageProducer
implements TransactionMessageProducer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultTransactionMessageProducer.class);
    private String transactionId;
    private long timeout;
    private TimeUnit timeoutUnit;
    private long sequence;
    private ProducerConfig config;
    private NameServerConfig nameServerConfig;
    private ClusterManager clusterManager;
    private MessageSender messageSender;
    private MessageProducerInner messageProducerInner;
    private PartitionMetadata transactionPartition;
    private SendPrepareResult prepare;
    private JoyQueueCode commit;
    private JoyQueueCode rollback;

    public DefaultTransactionMessageProducer(String transactionId, long timeout, TimeUnit timeoutUnit, long sequence, ProducerConfig config, NameServerConfig nameServerConfig, ClusterManager clusterManager, MessageSender messageSender, MessageProducerInner messageProducerInner) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config not null");
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        Preconditions.checkArgument((nameServerConfig != null ? 1 : 0) != 0, (Object)"nameServer not null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager not null");
        Preconditions.checkArgument((messageSender != null ? 1 : 0) != 0, (Object)"messageSender not null");
        Preconditions.checkArgument((messageProducerInner != null ? 1 : 0) != 0, (Object)"messageProducerInner not null");
        this.transactionId = transactionId;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.sequence = sequence;
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.clusterManager = clusterManager;
        this.messageSender = messageSender;
        this.messageProducerInner = messageProducerInner;
    }

    @Override
    public synchronized void commit() {
        this.checkPrepare();
        this.checkState();
        JoyQueueCode commit = this.messageSender.commit(this.transactionPartition.getLeader(), this.transactionPartition.getTopic(), this.config.getApp(), this.prepare.getTxId(), this.config.getTimeout());
        if (!commit.equals((Object)JoyQueueCode.SUCCESS)) {
            throw new ProducerException(commit.getMessage(new Object[0]), commit.getCode());
        }
        this.commit = commit;
    }

    @Override
    public synchronized void rollback() {
        this.checkPrepare();
        this.checkState();
        JoyQueueCode rollback = this.messageSender.rollback(this.transactionPartition.getLeader(), this.transactionPartition.getTopic(), this.config.getApp(), this.prepare.getTxId(), this.config.getTimeout());
        if (!rollback.equals((Object)JoyQueueCode.SUCCESS)) {
            throw new ProducerException(rollback.getMessage(new Object[0]), rollback.getCode());
        }
        this.rollback = rollback;
    }

    @Override
    public SendResult send(ProduceMessage message) {
        return this.send(message, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public SendResult send(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        List<SendResult> sendResults = this.batchSend(Lists.newArrayList((Object[])new ProduceMessage[]{message}), timeout, timeoutUnit);
        if (CollectionUtils.isEmpty(sendResults)) {
            return null;
        }
        return sendResults.get(0);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages) {
        return this.batchSend(messages, this.config.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        return this.doBatchSend(messages, timeout, timeoutUnit);
    }

    public synchronized List<SendResult> doBatchSend(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        this.checkState();
        ProduceMessageChecker.checkMessages(messages, this.config);
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        TopicMetadata topicMetadata = this.messageProducerInner.getAndCheckTopicMetadata(messages.get(0).getTopic());
        if (this.prepare == null) {
            List<BrokerNode> brokers = this.messageProducerInner.getRegionBrokers(topicMetadata);
            brokers = this.messageProducerInner.filterNotAvailableBrokers(brokers);
            List<PartitionMetadata> partitions = this.messageProducerInner.getBrokerPartitions(topicMetadata, brokers);
            this.transactionPartition = this.messageProducerInner.dispatchPartitions(messages, topicMetadata, partitions, null);
            this.prepare = this.doPrepare(this.transactionPartition);
        } else {
            Preconditions.checkArgument((boolean)messages.get(0).getTopic().equals(this.transactionPartition.getTopic()), (Object)"transaction message must be single partition");
            ProducerHelper.setPartitions(messages, this.transactionPartition.getId());
        }
        return this.messageProducerInner.doBatchSend(messages, topicMetadata, this.transactionPartition, null, this.prepare.getTxId(), timeout, timeoutUnit, false, false, null);
    }

    protected SendPrepareResult doPrepare(PartitionMetadata partition) {
        SendPrepareResult sendPrepareResult = this.messageSender.prepare(partition.getLeader(), partition.getTopic(), this.config.getApp(), this.transactionId, this.sequence, this.timeoutUnit.toMillis(this.timeout), this.config.getTimeout());
        if (!sendPrepareResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
            throw new ProducerException(sendPrepareResult.getCode().getMessage(new Object[0]), sendPrepareResult.getCode().getCode());
        }
        return sendPrepareResult;
    }

    protected void checkPrepare() {
        if (this.prepare == null) {
            throw new ProducerException("transaction is not beginning", JoyQueueCode.FW_TRANSACTION_EXISTS.getCode());
        }
    }

    protected void checkState() {
        if (this.commit != null || this.rollback != null) {
            throw new ProducerException("transaction is not beginning", JoyQueueCode.FW_TRANSACTION_EXISTS.getCode());
        }
    }
}

