/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.metadata.exception.MetadataException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.helper.NameServerHelper;
import org.joyqueue.client.internal.producer.MessageSender;
import org.joyqueue.client.internal.producer.PartitionSelector;
import org.joyqueue.client.internal.producer.callback.AsyncBatchProduceCallback;
import org.joyqueue.client.internal.producer.callback.AsyncBatchProduceCallbackAdapter;
import org.joyqueue.client.internal.producer.callback.AsyncBatchSendCallback;
import org.joyqueue.client.internal.producer.callback.AsyncProduceCallback;
import org.joyqueue.client.internal.producer.checker.ProduceMessageChecker;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendBatchResultData;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.exception.NeedRetryException;
import org.joyqueue.client.internal.producer.exception.ProducerException;
import org.joyqueue.client.internal.producer.helper.ProducerHelper;
import org.joyqueue.client.internal.producer.interceptor.ProduceContext;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptorManager;
import org.joyqueue.client.internal.producer.interceptor.ProducerInvocation;
import org.joyqueue.client.internal.producer.interceptor.ProducerInvoker;
import org.joyqueue.client.internal.producer.support.PartitionSelectorManager;
import org.joyqueue.client.internal.producer.transport.ProducerClient;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.domain.ProducerPolicy;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProducerInner
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(MessageProducerInner.class);
    private ProducerConfig config;
    private NameServerConfig nameServerConfig;
    private MessageSender messageSender;
    private ClusterManager clusterManager;
    private ProducerClientManager producerClientManager;
    private PartitionSelectorManager partitionSelectorManager;
    private ProducerInterceptorManager producerInterceptorManager;

    public MessageProducerInner(ProducerConfig config, NameServerConfig nameServerConfig, MessageSender messageSender, ClusterManager clusterManager, ProducerClientManager producerClientManager) {
        this(config, nameServerConfig, messageSender, clusterManager, producerClientManager, new ProducerInterceptorManager());
    }

    public MessageProducerInner(ProducerConfig config, NameServerConfig nameServerConfig, MessageSender messageSender, ClusterManager clusterManager, ProducerClientManager producerClientManager, ProducerInterceptorManager producerInterceptorManager) {
        this.config = config;
        this.nameServerConfig = nameServerConfig;
        this.messageSender = messageSender;
        this.clusterManager = clusterManager;
        this.producerClientManager = producerClientManager;
        this.producerInterceptorManager = producerInterceptorManager;
    }

    protected void validate() throws Exception {
        this.partitionSelectorManager = new PartitionSelectorManager();
    }

    public synchronized void addInterceptor(ProducerInterceptor interceptor) {
        this.producerInterceptorManager.addInterceptor(interceptor);
    }

    public synchronized void removeInterceptor(ProducerInterceptor interceptor) {
        this.producerInterceptorManager.removeInterceptor(interceptor);
    }

    public SendResult send(ProduceMessage message, String txId, long timeout, TimeUnit timeoutUnit, boolean isOneway, boolean failover, AsyncProduceCallback callback) {
        AsyncBatchProduceCallbackAdapter asyncBatchProduceCallback = callback == null ? null : new AsyncBatchProduceCallbackAdapter(callback);
        List<SendResult> sendResults = this.batchSend(Lists.newArrayList((Object[])new ProduceMessage[]{message}), txId, timeout, timeoutUnit, isOneway, failover, asyncBatchProduceCallback);
        if (CollectionUtils.isEmpty(sendResults)) {
            return null;
        }
        return sendResults.get(0);
    }

    public List<SendResult> batchSend(List<ProduceMessage> messages, String txId, long timeout, TimeUnit timeoutUnit, boolean isOneway, boolean failover, AsyncBatchProduceCallback callback) {
        Preconditions.checkArgument((timeoutUnit != null ? 1 : 0) != 0, (Object)"timeoutUnit not null");
        ProduceMessageChecker.checkMessages(messages, this.config);
        return this.doBatchSend(messages, txId, timeout, timeoutUnit, isOneway, failover, callback);
    }

    public List<SendResult> doBatchSend(List<ProduceMessage> messages, String txId, long timeout, TimeUnit timeoutUnit, boolean isOneway, boolean failover, AsyncBatchProduceCallback callback) {
        TopicMetadata topicMetadata = this.getAndCheckTopicMetadata(messages.get(0).getTopic());
        List<BrokerNode> brokers = this.getRegionBrokers(topicMetadata);
        brokers = this.filterNotAvailableBrokers(brokers);
        List<PartitionMetadata> partitions = this.getBrokerPartitions(topicMetadata, brokers);
        return this.doBatchSend(messages, topicMetadata, null, partitions, txId, timeout, timeoutUnit, isOneway, failover, callback);
    }

    public List<SendResult> doBatchSend(final List<ProduceMessage> messages, final TopicMetadata topicMetadata, final PartitionMetadata partition, final List<PartitionMetadata> partitions, final String txId, final long timeout, final TimeUnit timeoutUnit, final boolean isOneway, final boolean failover, final AsyncBatchProduceCallback callback) {
        try {
            return new ProducerInvocation(this.config, this.nameServerConfig, topicMetadata, messages, this.producerInterceptorManager, new ProducerInvoker(){

                @Override
                public List<SendResult> invoke(ProduceContext context) {
                    return MessageProducerInner.this.doBatchSendInternal(messages, topicMetadata, partition, partitions, txId, timeout, timeoutUnit, isOneway, failover, callback);
                }

                @Override
                public List<SendResult> reject(ProduceContext context) {
                    throw new ProducerException("reject send", JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
                }
            }).invoke();
        }
        catch (Exception e) {
            if (e instanceof ProducerException) {
                throw (ProducerException)e;
            }
            throw new ProducerException(e);
        }
    }

    protected List<SendResult> doBatchSendInternal(List<ProduceMessage> messages, TopicMetadata topicMetadata, PartitionMetadata partition, List<PartitionMetadata> partitions, String txId, long timeout, TimeUnit timeoutUnit, boolean isOneway, boolean failover, AsyncBatchProduceCallback callback) {
        LinkedList blackPartitionList = null;
        ProducerPolicy producerPolicy = topicMetadata.getProducerPolicy();
        String topic = topicMetadata.getTopic();
        String app = this.config.getApp();
        long produceTimeout = this.config.getProduceTimeout() == -1L ? (long)producerPolicy.getTimeOut().intValue() : this.config.getProduceTimeout();
        timeout = timeoutUnit.toMillis(timeout);
        failover = failover && this.isFailover(messages);
        RetryPolicy retryPolicy = this.config.getRetryPolicy();
        int retryTimes = 0;
        int retryLimit = failover ? retryPolicy.getMaxRetrys() : 0;
        ClientException lastException = null;
        List<SendResult> result = null;
        if (partition == null) {
            partition = this.dispatchPartitions(messages, topicMetadata, partitions, blackPartitionList);
        }
        for (int i = 0; i <= retryLimit; ++i) {
            if (retryTimes != 0 && failover) {
                if (blackPartitionList == null) {
                    blackPartitionList = Lists.newLinkedList();
                }
                blackPartitionList.add(partition);
                ProducerHelper.clearPartitions(messages);
                partition = this.dispatchPartitions(messages, topicMetadata, partitions, blackPartitionList);
            }
            try {
                result = this.doSendBatchMessage(partition.getLeader(), topic, app, messages, txId, this.config.getQosLevel(), produceTimeout, timeout, isOneway, callback);
                break;
            }
            catch (MetadataException e) {
                lastException = e;
                ++retryTimes;
                topicMetadata = this.getAndCheckTopicMetadata(topicMetadata.getTopic());
                logger.debug("send message exception, topic: {}, app:{}, messages: {}", new Object[]{topic, app, messages, e});
                continue;
            }
            catch (NeedRetryException e) {
                lastException = new ProducerException(e.getMessage(), e.getCode(), e.getCause());
                ++retryTimes;
                logger.debug("send message exception, topic: {}, app:{}, messages: {}", new Object[]{topic, app, messages, e});
                continue;
            }
            catch (ClientException e) {
                lastException = e;
                ++retryTimes;
                logger.debug("send message exception, topic: {}, app:{}, messages: {}", new Object[]{topic, app, messages, e});
                continue;
            }
            catch (Exception e) {
                logger.error("send message exception, topic: {}, app:{}, messages: {}", new Object[]{topic, app, messages, e});
                if (e instanceof ProducerException) {
                    throw (ProducerException)e;
                }
                throw new ProducerException(e);
            }
        }
        if (retryTimes > retryPolicy.getMaxRetrys()) {
            if (lastException instanceof ProducerException) {
                throw (ProducerException)lastException;
            }
            throw new ProducerException(lastException);
        }
        if (retryTimes != 0) {
            logger.warn("send message success, retry {} times, topic: {}, app: {}, partitions: {}, error: {}", new Object[]{retryTimes, topic, app, blackPartitionList, lastException.getMessage()});
        }
        return result;
    }

    protected List<SendResult> doSendBatchMessage(BrokerNode brokerNode, String topic, String app, List<ProduceMessage> messages, String txId, QosLevel qosLevel, long produceTimeout, long timeout, boolean isOneway, final AsyncBatchProduceCallback callback) {
        if (logger.isDebugEnabled()) {
            logger.debug("batch send message, broker: {}, topic: {}, app: {}, messages: {}, txId: {}, qosLevel: {}", new Object[]{brokerNode, topic, app, messages, txId, qosLevel});
        }
        if (isOneway) {
            this.messageSender.batchSendOneway(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout);
            return null;
        }
        if (callback == null) {
            SendBatchResultData sendBatchResultData = this.messageSender.batchSend(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout);
            return this.handleSendBatchResultData(topic, app, sendBatchResultData);
        }
        this.messageSender.batchSendAsync(brokerNode, topic, app, txId, messages, qosLevel, produceTimeout, timeout, new AsyncBatchSendCallback(){

            @Override
            public void onSuccess(List<ProduceMessage> messages, SendBatchResultData result) {
                if (result.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                    callback.onSuccess(messages, result.getResult());
                } else {
                    callback.onException(messages, new ProducerException(result.getCode().getMessage(new Object[0]), result.getCode().getCode()));
                }
            }

            @Override
            public void onException(List<ProduceMessage> messages, Throwable cause) {
                callback.onException(messages, cause);
            }
        });
        return null;
    }

    protected List<SendResult> handleSendBatchResultData(String topic, String app, SendBatchResultData sendBatchResultData) {
        if (sendBatchResultData == null) {
            throw new ProducerException(JoyQueueCode.CN_UNKNOWN_ERROR.getMessage(new Object[0]), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
        }
        JoyQueueCode code = sendBatchResultData.getCode();
        if (code.equals((Object)JoyQueueCode.SUCCESS)) {
            return sendBatchResultData.getResult();
        }
        switch (code) {
            case CN_NO_PERMISSION: 
            case CN_SERVICE_NOT_AVAILABLE: 
            case FW_PRODUCE_MESSAGE_BROKER_NOT_LEADER: {
                logger.debug("send message error, no permission, topic: {}", (Object)topic);
                this.clusterManager.updateTopicMetadata(topic, app);
                throw new MetadataException(code.getMessage(new Object[0]), code.getCode());
            }
            case FW_PUT_MESSAGE_TOPIC_NOT_WRITE: {
                logger.debug("send message error, topic not write, topic: {}", (Object)topic);
                break;
            }
            case FW_TOPIC_NOT_EXIST: {
                logger.debug("send message error, topic not exist, topic: {}", (Object)topic);
                throw new ProducerException(code.getMessage(new Object[0]), code.getCode());
            }
            case FW_BROKER_NOT_WRITABLE: {
                logger.debug("send message error, broker not writable, topic: {}", (Object)topic);
                this.clusterManager.updateTopicMetadata(topic, app);
                break;
            }
            default: {
                logger.error("send message error, topic: {}, code: {}, error: {}", new Object[]{topic, code, code.getMessage(new Object[0])});
                throw new NeedRetryException(code.getMessage(new Object[0]), code.getCode());
            }
        }
        throw new NeedRetryException(code.getMessage(new Object[0]), code.getCode());
    }

    public TopicMetadata getAndCheckTopicMetadata(String topic) {
        TopicMetadata topicMetadata = this.clusterManager.fetchTopicMetadata(this.getTopicFullName(topic), this.config.getApp());
        if (topicMetadata == null) {
            throw new ProducerException(String.format("topic %s is not exist", topic), JoyQueueCode.FW_TOPIC_NOT_EXIST.getCode());
        }
        if (topicMetadata.getProducerPolicy() == null) {
            throw new ProducerException(String.format("topic %s producer %s is not exist", topic, this.nameServerConfig.getApp()), JoyQueueCode.FW_PRODUCER_NOT_EXISTS.getCode());
        }
        return topicMetadata;
    }

    public String getTopicFullName(String topic) {
        return NameServerHelper.getTopicFullName(topic, this.nameServerConfig);
    }

    public List<BrokerNode> getRegionBrokers(TopicMetadata topicMetadata) {
        if (topicMetadata.getProducerPolicy().getNearby().booleanValue()) {
            return topicMetadata.getNearbyBrokers();
        }
        return topicMetadata.getBrokers();
    }

    public List<BrokerNode> filterNotAvailableBrokers(List<BrokerNode> brokerNodes) {
        if (CollectionUtils.isEmpty(brokerNodes)) {
            return brokerNodes;
        }
        ArrayList newBrokerNodes = null;
        for (BrokerNode brokerNode : brokerNodes) {
            ProducerClient client = this.producerClientManager.tryGetClient(brokerNode);
            if (client == null || client.getState().equals((Object)ClientState.CONNECTED)) continue;
            if (newBrokerNodes == null) {
                newBrokerNodes = Lists.newArrayList(brokerNodes);
            }
            newBrokerNodes.remove(brokerNode);
        }
        if (newBrokerNodes == null) {
            return brokerNodes;
        }
        return newBrokerNodes;
    }

    public List<PartitionMetadata> getBrokerPartitions(TopicMetadata topicMetadata, List<BrokerNode> brokerNodes) {
        if (topicMetadata.getBrokers().equals(brokerNodes)) {
            return topicMetadata.getPartitions();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)topicMetadata.getPartitions().size());
        for (BrokerNode brokerNode : brokerNodes) {
            List<PartitionMetadata> brokerPartitions = topicMetadata.getBrokerPartitions(brokerNode.getId());
            if (brokerPartitions == null) continue;
            result.addAll(brokerPartitions);
        }
        return result;
    }

    public PartitionMetadata dispatchPartitions(List<ProduceMessage> messages, TopicMetadata topicMetadata, List<PartitionMetadata> partitions) {
        return this.dispatchPartitions(messages, topicMetadata, partitions, null);
    }

    public PartitionMetadata dispatchPartitions(List<ProduceMessage> messages, TopicMetadata topicMetadata, List<PartitionMetadata> partitions, List<PartitionMetadata> blackPartitionList) {
        if (CollectionUtils.isEmpty(partitions)) {
            throw new ProducerException(String.format("no partitions available, topic: %s, messages: %s", topicMetadata.getTopic(), messages), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (blackPartitionList != null) {
            partitions = ProducerHelper.filterBlackList(partitions, blackPartitionList);
        }
        if (CollectionUtils.isEmpty(partitions)) {
            throw new ProducerException(String.format("no partitions available, topic: %s, messages: %s", topicMetadata.getTopic(), messages), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        PartitionSelector partitionSelector = this.partitionSelectorManager.getPartitionSelector(topicMetadata.getTopic(), this.config.getSelectorType());
        PartitionMetadata partition = ProducerHelper.dispatchPartitions(messages, topicMetadata, partitions, partitionSelector);
        if (partition == null) {
            throw new ProducerException(String.format("partition not available, topic: %s, messages: %s", topicMetadata.getTopic(), messages), JoyQueueCode.FW_TOPIC_NO_PARTITIONGROUP.getCode());
        }
        if (partition.getLeader() == null || !partition.getLeader().isWritable()) {
            if (blackPartitionList == null) {
                blackPartitionList = Lists.newArrayList();
            }
            blackPartitionList.add(partition);
            return this.dispatchPartitions(messages, topicMetadata, partitions, blackPartitionList);
        }
        ProducerHelper.setPartitions(messages, partition.getId());
        return partition;
    }

    public boolean isFailover(List<ProduceMessage> messages) {
        return messages.get(0).getPartition() == Short.MIN_VALUE;
    }
}

