/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.TransactionMessageProducer;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.toolkit.service.Service;

public class MessageProducerWrapper
extends Service
implements MessageProducer {
    private ClusterManager clusterManager;
    private ProducerClientManager producerClientManager;
    private MessageProducer delegate;

    public MessageProducerWrapper(ClusterManager clusterManager, ProducerClientManager producerClientManager, MessageProducer delegate) {
        this.clusterManager = clusterManager;
        this.producerClientManager = producerClientManager;
        this.delegate = delegate;
    }

    protected void doStart() throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.start();
        }
        if (this.producerClientManager != null) {
            this.producerClientManager.start();
        }
        this.delegate.start();
    }

    protected void doStop() {
        this.delegate.stop();
        if (this.producerClientManager != null) {
            this.producerClientManager.stop();
        }
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
    }

    @Override
    public SendResult send(ProduceMessage message) {
        return this.delegate.send(message);
    }

    @Override
    public SendResult send(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.send(message, timeout, timeoutUnit);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages) {
        return this.delegate.batchSend(messages);
    }

    @Override
    public List<SendResult> batchSend(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.batchSend(messages, timeout, timeoutUnit);
    }

    @Override
    public void sendOneway(ProduceMessage message) {
        this.delegate.sendOneway(message);
    }

    @Override
    public void sendOneway(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        this.delegate.sendOneway(message, timeout, timeoutUnit);
    }

    @Override
    public void batchSendOneway(List<ProduceMessage> messages) {
        this.delegate.batchSendOneway(messages);
    }

    @Override
    public void batchSendOneway(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        this.delegate.batchSendOneway(messages, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<SendResult> sendAsync(ProduceMessage message) {
        return this.delegate.sendAsync(message);
    }

    @Override
    public CompletableFuture<SendResult> sendAsync(ProduceMessage message, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.sendAsync(message, timeout, timeoutUnit);
    }

    @Override
    public CompletableFuture<List<SendResult>> batchSendAsync(List<ProduceMessage> messages) {
        return this.delegate.batchSendAsync(messages);
    }

    @Override
    public CompletableFuture<List<SendResult>> batchSendAsync(List<ProduceMessage> messages, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.batchSendAsync(messages, timeout, timeoutUnit);
    }

    @Override
    public TransactionMessageProducer beginTransaction() {
        return this.delegate.beginTransaction();
    }

    @Override
    public TransactionMessageProducer beginTransaction(long timeout, TimeUnit timeoutUnit) {
        return this.delegate.beginTransaction(timeout, timeoutUnit);
    }

    @Override
    public TransactionMessageProducer beginTransaction(String transactionId) {
        return this.delegate.beginTransaction(transactionId);
    }

    @Override
    public TransactionMessageProducer beginTransaction(String transactionId, long timeout, TimeUnit timeoutUnit) {
        return this.delegate.beginTransaction(transactionId, timeout, timeoutUnit);
    }

    @Override
    public TopicMetadata getTopicMetadata(String topic) {
        return this.delegate.getTopicMetadata(topic);
    }

    @Override
    public void addInterceptor(ProducerInterceptor interceptor) {
        this.delegate.addInterceptor(interceptor);
    }

    @Override
    public void removeInterceptor(ProducerInterceptor interceptor) {
        this.delegate.removeInterceptor(interceptor);
    }
}

