/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.client.internal.Plugins;
import org.joyqueue.client.internal.producer.PartitionSelector;

public class PartitionSelectorManager {
    private ConcurrentMap<String, PartitionSelector> partitionSelectorMap = Maps.newConcurrentMap();

    public PartitionSelector getPartitionSelector(String topic, String selectorType) {
        PartitionSelector oldPartitionSelector;
        PartitionSelector partitionSelector = (PartitionSelector)this.partitionSelectorMap.get(topic);
        if (partitionSelector == null && (oldPartitionSelector = this.partitionSelectorMap.putIfAbsent(topic, partitionSelector = this.create(selectorType))) != null) {
            partitionSelector = oldPartitionSelector;
        }
        return partitionSelector;
    }

    private PartitionSelector create(String selectorType) {
        PartitionSelector selector = (PartitionSelector)Plugins.PARTITION_SELECTOR.get((Object)selectorType);
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)String.format("partition selector not found. type: %s", selectorType));
        return selector;
    }
}

