/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.support;

import com.jd.laf.extension.Extension;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.client.internal.metadata.domain.PartitionMetadata;
import org.joyqueue.client.internal.metadata.domain.TopicMetadata;
import org.joyqueue.client.internal.producer.domain.ProduceMessage;
import org.joyqueue.client.internal.producer.support.AbstractPartitionSelector;
import org.joyqueue.network.domain.BrokerNode;

@Extension(singleton=false)
public class WeightedRoundRobinPartitionSelector
extends AbstractPartitionSelector {
    public static final String NAME = "roundrobin";
    private final AtomicInteger next = new AtomicInteger();
    private final AtomicInteger currentWeight = new AtomicInteger();
    private TopicMetadata lastTopicMetadata;

    @Override
    protected PartitionMetadata nextPartition(ProduceMessage message, TopicMetadata topicMetadata, List<PartitionMetadata> partitions) {
        PartitionMetadata partition;
        int index = this.next.get();
        int currentWeight = this.currentWeight.get();
        int size = partitions.size();
        boolean weightChange = this.lastTopicMetadata != topicMetadata;
        int retry = 0;
        if (weightChange) {
            this.lastTopicMetadata = topicMetadata;
        }
        if (index >= size) {
            this.next.set(1);
            index = 0;
        }
        while (true) {
            BrokerNode partitionLeader;
            if ((index = (index + 1) % size) == 0 || weightChange) {
                weightChange = false;
                int maxGcd = this.getMaxGcd(partitions);
                if ((currentWeight -= maxGcd) <= 0) {
                    int maxWeight;
                    currentWeight = maxWeight = this.getMaxWeight(partitions);
                    this.currentWeight.set(maxWeight);
                    this.next.set(index);
                    if (currentWeight == 0) {
                        return partitions.get(0);
                    }
                }
            }
            if ((partitionLeader = (partition = partitions.get(index)).getLeader()) == null) {
                if (retry > 5) {
                    return null;
                }
                ++retry;
                continue;
            }
            int partitionWeight = partitionLeader.getWeight();
            if (partitionWeight >= currentWeight) break;
        }
        this.currentWeight.set(currentWeight);
        this.next.set(index);
        return partition;
    }

    protected int getMaxGcd(List<PartitionMetadata> partitions) {
        int maxGcd = 0;
        for (int i = 0; i < partitions.size() - 1; ++i) {
            BrokerNode leader = partitions.get(i).getLeader();
            BrokerNode leader1 = partitions.get(i + 1).getLeader();
            if (leader == null || leader1 == null) continue;
            maxGcd = this.getGcd(maxGcd, this.getGcd(leader.getWeight(), leader1.getWeight()));
        }
        return maxGcd;
    }

    protected int getMaxWeight(List<PartitionMetadata> partitions) {
        int max = 0;
        for (PartitionMetadata partition : partitions) {
            if (partition.getLeader() == null) continue;
            int weight = partition.getLeader().getWeight();
            max = Math.max(weight, max);
        }
        return max;
    }

    protected int getGcd(int num1, int num2) {
        BigInteger i1 = new BigInteger(String.valueOf(num1));
        BigInteger i2 = new BigInteger(String.valueOf(num2));
        return i1.gcd(i2).intValue();
    }

    public String type() {
        return NAME;
    }
}

