/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.transport;

import java.util.Collection;
import java.util.Map;
import org.joyqueue.client.internal.producer.transport.ProducerClientConnectionListener;
import org.joyqueue.client.internal.producer.transport.ProducerConnectionState;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.network.command.FetchProduceFeedbackRequest;
import org.joyqueue.network.command.FetchProduceFeedbackResponse;
import org.joyqueue.network.command.ProduceMessageCommitRequest;
import org.joyqueue.network.command.ProduceMessageCommitResponse;
import org.joyqueue.network.command.ProduceMessageData;
import org.joyqueue.network.command.ProduceMessagePrepareRequest;
import org.joyqueue.network.command.ProduceMessagePrepareResponse;
import org.joyqueue.network.command.ProduceMessageRequest;
import org.joyqueue.network.command.ProduceMessageResponse;
import org.joyqueue.network.command.ProduceMessageRollbackRequest;
import org.joyqueue.network.command.ProduceMessageRollbackResponse;
import org.joyqueue.network.command.TxStatus;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class ProducerClient {
    private static final String CLIENT_PRODUCER_CACHE_KEY = "_CLIENT_PRODUCER_CACHE_";
    private Client client;
    private ProducerConnectionState connectionState;

    public static ProducerClient build(Client client) {
        ProducerClient producerClient = (ProducerClient)client.getAttribute().get((Object)CLIENT_PRODUCER_CACHE_KEY);
        if (producerClient == null) {
            producerClient = new ProducerClient(client);
            ProducerClient oldProducerClient = (ProducerClient)client.getAttribute().putIfAbsent((Object)CLIENT_PRODUCER_CACHE_KEY, (Object)producerClient);
            if (oldProducerClient != null) {
                producerClient = oldProducerClient;
            } else {
                producerClient.getClient().addListener(new ProducerClientConnectionListener(producerClient.getClient().getTransport(), producerClient));
            }
        }
        return producerClient;
    }

    public ProducerClient(Client client) {
        this.client = client;
        this.connectionState = new ProducerConnectionState(this);
    }

    public ProduceMessageResponse produceMessage(String app, Map<String, ProduceMessageData> messages, long timeout) {
        ProduceMessageRequest produceMessageRequest = new ProduceMessageRequest();
        produceMessageRequest.setApp(app);
        produceMessageRequest.setData(messages);
        return (ProduceMessageResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)produceMessageRequest), timeout).getPayload();
    }

    public void produceMessageOneway(String app, Map<String, ProduceMessageData> messages, long timeout) {
        ProduceMessageRequest produceMessageRequest = new ProduceMessageRequest();
        produceMessageRequest.setApp(app);
        produceMessageRequest.setData(messages);
        this.client.oneway((Command)new JoyQueueCommand((JoyQueuePayload)produceMessageRequest), timeout);
    }

    public void asyncProduceMessage(String app, Map<String, ProduceMessageData> messages, long timeout, CommandCallback callback) {
        ProduceMessageRequest produceMessageRequest = new ProduceMessageRequest();
        produceMessageRequest.setApp(app);
        produceMessageRequest.setData(messages);
        this.client.async((Command)new JoyQueueCommand((JoyQueuePayload)produceMessageRequest), timeout, callback);
    }

    public ProduceMessagePrepareResponse produceMessagePrepare(String topic, String app, long sequence, String transactionId, long transactionTimeout, long timeout) {
        ProduceMessagePrepareRequest produceMessagePrepareRequest = new ProduceMessagePrepareRequest();
        produceMessagePrepareRequest.setTopic(topic);
        produceMessagePrepareRequest.setApp(app);
        produceMessagePrepareRequest.setSequence(sequence);
        produceMessagePrepareRequest.setTransactionId(transactionId);
        produceMessagePrepareRequest.setTimeout((int)transactionTimeout);
        return (ProduceMessagePrepareResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)produceMessagePrepareRequest), timeout).getPayload();
    }

    public ProduceMessageCommitResponse produceMessageCommit(String topic, String app, String txId, long timeout) {
        ProduceMessageCommitRequest produceMessageCommitRequest = new ProduceMessageCommitRequest();
        produceMessageCommitRequest.setTopic(topic);
        produceMessageCommitRequest.setApp(app);
        produceMessageCommitRequest.setTxId(txId);
        return (ProduceMessageCommitResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)produceMessageCommitRequest), timeout).getPayload();
    }

    public ProduceMessageRollbackResponse produceMessageRollback(String topic, String app, String txId, long timeout) {
        ProduceMessageRollbackRequest produceMessageRollbackRequest = new ProduceMessageRollbackRequest();
        produceMessageRollbackRequest.setTopic(topic);
        produceMessageRollbackRequest.setApp(app);
        produceMessageRollbackRequest.setTxId(txId);
        return (ProduceMessageRollbackResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)produceMessageRollbackRequest), timeout).getPayload();
    }

    public FetchProduceFeedbackResponse fetchFeedback(String topic, String app, TxStatus txStatus, int count, long longPollTimeout, long timeout) {
        FetchProduceFeedbackRequest fetchProduceFeedbackRequest = new FetchProduceFeedbackRequest();
        fetchProduceFeedbackRequest.setTopic(topic);
        fetchProduceFeedbackRequest.setApp(app);
        fetchProduceFeedbackRequest.setStatus(txStatus);
        fetchProduceFeedbackRequest.setCount(count);
        fetchProduceFeedbackRequest.setLongPollTimeout((int)longPollTimeout);
        return (FetchProduceFeedbackResponse)this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)fetchProduceFeedbackRequest), timeout).getPayload();
    }

    public void addProducers() {
        this.connectionState.handleAddProducers();
    }

    public void addProducers(Collection<String> topics, String app) {
        this.connectionState.handleAddProducers(topics, app);
    }

    public void removeProducers(Collection<String> topics, String app) {
        this.connectionState.handleRemoveProducers(topics, app);
    }

    public void close() {
        this.connectionState.handleRemoveProducers();
        this.client.stop();
    }

    public TransportAttribute getAttribute() {
        return this.client.getAttribute();
    }

    public Client getClient() {
        return this.client;
    }

    public ClientState getState() {
        return this.client.getState();
    }
}

