/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.transport;

import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.producer.transport.ProducerClient;
import org.joyqueue.client.internal.producer.transport.ProducerClientGroup;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientGroup;
import org.joyqueue.client.internal.transport.ClientManager;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerClientManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ProducerClientManager.class);
    private TransportConfig transportConfig;
    private NameServerConfig nameServerConfig;
    private ClientManager clientManager;

    public ProducerClientManager(TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        this.transportConfig = transportConfig;
        this.nameServerConfig = nameServerConfig;
    }

    public ProducerClientGroup getClientGroup(BrokerNode node) {
        ClientGroup clientGroup = this.clientManager.getClientGroup(node);
        if (clientGroup == null) {
            return null;
        }
        return new ProducerClientGroup(clientGroup);
    }

    public ProducerClient createClient(BrokerNode node) {
        Client client = this.clientManager.createClient(node);
        return new ProducerClient(client);
    }

    public ProducerClient getOrCreateClient(BrokerNode node) {
        Client client = this.clientManager.getOrCreateClient(node);
        return ProducerClient.build(client);
    }

    public ProducerClient getClient(BrokerNode node) {
        Client client = this.clientManager.getClient(node);
        if (client == null) {
            return null;
        }
        return ProducerClient.build(client);
    }

    public ProducerClient tryGetClient(BrokerNode node) {
        Client client = this.clientManager.tryGetClient(node);
        if (client == null) {
            return null;
        }
        return ProducerClient.build(client);
    }

    public void closeClient(BrokerNode node) {
        ProducerClient producerClient = this.tryGetClient(node);
        if (producerClient == null) {
            return;
        }
        producerClient.close();
        this.clientManager.closeClient(node);
    }

    protected void validate() throws Exception {
        this.transportConfig = this.transportConfig.copy();
        this.clientManager = new ClientManager(this.transportConfig, this.nameServerConfig);
    }

    protected void doStart() throws Exception {
        this.clientManager.start();
    }

    protected void doStop() {
        if (this.clientManager != null) {
            this.clientManager.stop();
        }
    }
}

