/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.producer.transport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.client.internal.producer.transport.ProducerClient;
import org.joyqueue.network.command.AddProducerRequest;
import org.joyqueue.network.command.RemoveProducerRequest;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerConnectionState {
    protected static final Logger logger = LoggerFactory.getLogger(ProducerConnectionState.class);
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private ProducerClient producerClient;
    private ConcurrentMap<String, Set<String>> producerMap = Maps.newConcurrentMap();
    private ReentrantReadWriteLock producerLock = new ReentrantReadWriteLock();

    public ProducerConnectionState(ProducerClient producerClient) {
        this.producerClient = producerClient;
    }

    public void handleAddProducers() {
        if (MapUtils.isEmpty(this.producerMap)) {
            return;
        }
        try {
            for (Map.Entry entry : this.producerMap.entrySet()) {
                this.doHandleAddProducers(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (String)entry.getKey());
            }
        }
        catch (Exception e) {
            logger.error("add producer exception, producerMap: {}", this.producerMap, (Object)e);
            this.producerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddProducers(Collection<String> topics, String app) {
        this.producerLock.readLock().lock();
        try {
            Set<String> topicSet = this.getOrCreateAddedTopicSet(app);
            LinkedList addTopics = null;
            for (String topic : topics) {
                if (topicSet.contains(topic)) continue;
                if (addTopics == null) {
                    addTopics = Lists.newLinkedList();
                }
                addTopics.add(topic);
            }
            if (CollectionUtils.isEmpty(addTopics)) {
                return;
            }
            if (this.doHandleAddProducers(addTopics, app)) {
                topicSet.addAll(addTopics);
            }
        }
        finally {
            this.producerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveProducers(Collection<String> topics, String app) {
        this.producerLock.writeLock().lock();
        try {
            Set<String> topicSet = this.getOrCreateAddedTopicSet(app);
            LinkedList removeTopics = null;
            for (String topic : topics) {
                if (!topicSet.contains(topic)) continue;
                if (removeTopics == null) {
                    removeTopics = Lists.newLinkedList();
                }
                removeTopics.add(topic);
            }
            if (CollectionUtils.isEmpty(removeTopics)) {
                return;
            }
            if (this.doHandleRemoveProducers(removeTopics, app)) {
                topicSet.removeAll(removeTopics);
            }
        }
        finally {
            this.producerLock.writeLock().unlock();
        }
    }

    public void handleRemoveProducers() {
        if (MapUtils.isEmpty(this.producerMap)) {
            return;
        }
        for (Map.Entry entry : this.producerMap.entrySet()) {
            this.doHandleRemoveProducers(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (String)entry.getKey());
        }
    }

    protected boolean doHandleAddProducers(List<String> topics, String app) {
        AddProducerRequest addProducerRequest = new AddProducerRequest();
        addProducerRequest.setTopics(topics);
        addProducerRequest.setApp(app);
        addProducerRequest.setSequence(SEQUENCE.incrementAndGet());
        try {
            this.producerClient.getClient().sync((Command)new JoyQueueCommand((JoyQueuePayload)addProducerRequest));
            return true;
        }
        catch (Exception e) {
            logger.warn("add producer exception, topics: {}, app: {}, error: {}", new Object[]{topics, app, e.getMessage()});
            logger.debug("add producer exception, topics: {}, app: {}", new Object[]{topics, app, e});
            return false;
        }
    }

    protected boolean doHandleRemoveProducers(List<String> topics, String app) {
        RemoveProducerRequest removeProducerRequest = new RemoveProducerRequest();
        removeProducerRequest.setTopics(topics);
        removeProducerRequest.setApp(app);
        try {
            this.producerClient.getClient().sync((Command)new JoyQueueCommand((JoyQueuePayload)removeProducerRequest));
            return true;
        }
        catch (Exception e) {
            logger.warn("remove producer exception, topics: {}, app: {}, error: {}", new Object[]{topics, app, e.getMessage()});
            logger.debug("remove producer exception, topics: {}, app: {}", new Object[]{topics, app, e});
            return false;
        }
    }

    protected Set<String> getOrCreateAddedTopicSet(String app) {
        Set<String> oldTopicSet;
        Set<String> topicSet = (Set<String>)this.producerMap.get(app);
        if (topicSet == null && (oldTopicSet = this.producerMap.putIfAbsent(app, topicSet = Sets.newConcurrentHashSet())) != null) {
            topicSet = oldTopicSet;
        }
        return topicSet;
    }
}

