/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.MessageAccessPoint;
import org.joyqueue.client.internal.cluster.ClusterClientManager;
import org.joyqueue.client.internal.cluster.ClusterClientManagerFactory;
import org.joyqueue.client.internal.cluster.ClusterManager;
import org.joyqueue.client.internal.cluster.ClusterManagerFactory;
import org.joyqueue.client.internal.consumer.MessageConsumer;
import org.joyqueue.client.internal.consumer.MessageConsumerFactory;
import org.joyqueue.client.internal.consumer.MessagePoller;
import org.joyqueue.client.internal.consumer.MessagePollerFactory;
import org.joyqueue.client.internal.consumer.config.ConsumerConfig;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManager;
import org.joyqueue.client.internal.consumer.transport.ConsumerClientManagerFactory;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfigChecker;
import org.joyqueue.client.internal.producer.MessageProducer;
import org.joyqueue.client.internal.producer.MessageProducerFactory;
import org.joyqueue.client.internal.producer.TxFeedbackManager;
import org.joyqueue.client.internal.producer.TxFeedbackManagerFactory;
import org.joyqueue.client.internal.producer.callback.TxFeedbackCallback;
import org.joyqueue.client.internal.producer.config.ProducerConfig;
import org.joyqueue.client.internal.producer.feedback.config.TxFeedbackConfig;
import org.joyqueue.client.internal.producer.transport.ProducerClientManager;
import org.joyqueue.client.internal.producer.transport.ProducerClientManagerFactory;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.client.internal.transport.config.TransportConfigChecker;
import org.joyqueue.toolkit.service.Service;

public class DefaultMessageAccessPoint
extends Service
implements MessageAccessPoint {
    private NameServerConfig nameServerConfig;
    private TransportConfig transportConfig;
    private ClusterManager clusterManager;
    private ClusterClientManager clusterClientManager;
    private ProducerClientManager producerClientManager;
    private ConsumerClientManager consumerClientManager;
    private Map<String, TxFeedbackManager> txFeedbackManagerMap = Maps.newHashMap();

    public DefaultMessageAccessPoint(NameServerConfig nameServerConfig, TransportConfig transportConfig) {
        NameServerConfigChecker.check(nameServerConfig);
        TransportConfigChecker.check(transportConfig);
        this.nameServerConfig = nameServerConfig;
        this.transportConfig = transportConfig;
    }

    protected void doStop() {
        if (this.clusterManager != null) {
            this.clusterManager.stop();
        }
        if (this.clusterClientManager != null) {
            this.clusterClientManager.stop();
        }
        if (this.producerClientManager != null) {
            this.producerClientManager.stop();
        }
        if (this.consumerClientManager != null) {
            this.consumerClientManager.stop();
        }
        for (Map.Entry<String, TxFeedbackManager> entry : this.txFeedbackManagerMap.entrySet()) {
            entry.getValue().stop();
        }
    }

    @Override
    public MessagePoller createPoller() {
        return this.createPoller((String)null);
    }

    @Override
    public MessagePoller createPoller(String group) {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setApp(this.nameServerConfig.getApp());
        consumerConfig.setGroup(group);
        return this.createPoller(consumerConfig);
    }

    @Override
    public MessagePoller createPoller(ConsumerConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config can not be null");
        config.setApp(this.nameServerConfig.getApp());
        return MessagePollerFactory.create(config, this.nameServerConfig, this.getClusterManager(), this.getClusterClientManager(), this.getConsumerClientManager());
    }

    @Override
    public synchronized MessageConsumer createConsumer() {
        return this.createConsumer((String)null);
    }

    @Override
    public synchronized MessageConsumer createConsumer(String group) {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setApp(this.nameServerConfig.getApp());
        consumerConfig.setGroup(group);
        return this.createConsumer(consumerConfig);
    }

    @Override
    public synchronized MessageConsumer createConsumer(ConsumerConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config can not be null");
        config.setApp(this.nameServerConfig.getApp());
        return MessageConsumerFactory.create(config, this.nameServerConfig, this.getClusterManager(), this.getClusterClientManager(), this.getConsumerClientManager());
    }

    @Override
    public synchronized MessageProducer createProducer() {
        ProducerConfig producerConfig = new ProducerConfig();
        producerConfig.setApp(this.nameServerConfig.getApp());
        return this.createProducer(producerConfig);
    }

    @Override
    public synchronized MessageProducer createProducer(ProducerConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config can not be null");
        config.setApp(this.nameServerConfig.getApp());
        return MessageProducerFactory.create(config, this.nameServerConfig, this.getClusterManager(), this.getProducerClientManager());
    }

    @Override
    public synchronized void setTransactionCallback(String topic, TxFeedbackCallback callback) {
        TxFeedbackConfig txFeedbackConfig = new TxFeedbackConfig();
        txFeedbackConfig.setApp(this.nameServerConfig.getApp());
        this.setTransactionCallback(topic, txFeedbackConfig, callback);
    }

    @Override
    public void setTransactionCallback(String topic, TxFeedbackConfig config, TxFeedbackCallback callback) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic can not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config can not be null");
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (Object)"callback can not be null");
        TxFeedbackManager txFeedbackManager = this.getTxFeedbackManager(config);
        txFeedbackManager.setTransactionCallback(topic, callback);
        this.txFeedbackManagerMap.put(topic, txFeedbackManager);
    }

    @Override
    public synchronized void removeTransactionCallback(String topic) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topic), (Object)"topic can not be null");
        TxFeedbackManager txFeedbackManager = this.txFeedbackManagerMap.get(topic);
        if (txFeedbackManager == null) {
            throw new IllegalArgumentException(String.format("%s feedback is not exist", topic));
        }
        txFeedbackManager.removeTransactionCallback(topic);
    }

    protected ClusterManager getClusterManager() {
        if (this.clusterManager != null) {
            return this.clusterManager;
        }
        ClusterManager clusterManager = ClusterManagerFactory.create(this.nameServerConfig, this.getClusterClientManager());
        try {
            clusterManager.start();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.clusterManager = clusterManager;
        return clusterManager;
    }

    protected ClusterClientManager getClusterClientManager() {
        if (this.clusterClientManager != null) {
            return this.clusterClientManager;
        }
        ClusterClientManager clusterClientManager = ClusterClientManagerFactory.create(this.nameServerConfig, this.transportConfig);
        try {
            clusterClientManager.start();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.clusterClientManager = clusterClientManager;
        return clusterClientManager;
    }

    protected ProducerClientManager getProducerClientManager() {
        if (this.producerClientManager != null) {
            return this.producerClientManager;
        }
        ProducerClientManager producerClientManager = ProducerClientManagerFactory.create(this.nameServerConfig, this.transportConfig);
        try {
            producerClientManager.start();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.producerClientManager = producerClientManager;
        return producerClientManager;
    }

    protected ConsumerClientManager getConsumerClientManager() {
        if (this.consumerClientManager != null) {
            return this.consumerClientManager;
        }
        ConsumerClientManager consumerClientManager = ConsumerClientManagerFactory.create(this.nameServerConfig, this.transportConfig);
        try {
            consumerClientManager.start();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.consumerClientManager = consumerClientManager;
        return consumerClientManager;
    }

    protected TxFeedbackManager getTxFeedbackManager(TxFeedbackConfig config) {
        TxFeedbackManager txFeedbackManager = TxFeedbackManagerFactory.create(config, this.nameServerConfig, this.getClusterManager(), this.getProducerClientManager());
        try {
            txFeedbackManager.start();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        return txFeedbackManager;
    }
}

