/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.trace;

import org.joyqueue.client.internal.trace.TraceCaller;
import org.joyqueue.client.internal.trace.TraceContext;
import org.joyqueue.client.internal.trace.TraceType;
import org.joyqueue.client.internal.trace.support.TraceWrapper;
import org.joyqueue.toolkit.time.SystemClock;

public class TraceBuilder {
    private String topic;
    private String app;
    private String namespace;
    private TraceType type;
    private long startTime;

    public static TraceBuilder newInstance() {
        return new TraceBuilder();
    }

    public TraceBuilder topic(String topic) {
        this.topic = topic;
        return this;
    }

    public TraceBuilder app(String app) {
        this.app = app;
        return this;
    }

    public TraceBuilder type(TraceType type) {
        this.type = type;
        return this;
    }

    public TraceBuilder startTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public TraceBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public TraceContext context() {
        if (this.startTime == 0L) {
            this.startTime = SystemClock.now();
        }
        return new TraceContext(this.topic, this.app, this.namespace, this.type, this.startTime);
    }

    public TraceCaller begin(String topic, String app, TraceType type) {
        TraceContext context = new TraceContext(topic, app, this.namespace, type, SystemClock.now());
        return TraceWrapper.getInstance().begin(context);
    }

    public TraceCaller begin() {
        TraceContext context = this.context();
        return TraceWrapper.getInstance().begin(context);
    }
}

