/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.trace;

import org.joyqueue.client.internal.trace.TraceType;
import org.joyqueue.toolkit.time.SystemClock;

public class TraceContext {
    private String topic;
    private String app;
    private String namespace;
    private TraceType type;
    private long startTime;

    public TraceContext(String topic, String app, String namespace, TraceType type) {
        this(topic, app, namespace, type, SystemClock.now());
    }

    public TraceContext(String topic, String app, String namespace, TraceType type, long startTime) {
        this.topic = topic;
        this.app = app;
        this.namespace = namespace;
        this.type = type;
        this.startTime = startTime;
    }

    public long getInterval() {
        return SystemClock.now() - this.startTime;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public TraceType getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

