/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.trace.interceptor;

import java.util.List;
import org.joyqueue.client.internal.common.ordered.Ordered;
import org.joyqueue.client.internal.consumer.domain.ConsumeReply;
import org.joyqueue.client.internal.consumer.interceptor.ConsumeContext;
import org.joyqueue.client.internal.consumer.interceptor.ConsumerInterceptor;
import org.joyqueue.client.internal.trace.TraceBuilder;
import org.joyqueue.client.internal.trace.TraceCaller;
import org.joyqueue.client.internal.trace.TraceType;
import org.joyqueue.network.command.RetryType;

public class TraceConsumerInterceptor
implements ConsumerInterceptor,
Ordered {
    private static final String CALLER_KEY = "_TRACE_CALLER_";

    @Override
    public boolean preConsume(ConsumeContext context) {
        TraceCaller caller = TraceBuilder.newInstance().topic(context.getTopic()).app(context.getApp()).namespace(context.getNameserver().getNamespace()).type(TraceType.CONSUMER_CONSUME).begin();
        context.putAttribute(CALLER_KEY, caller);
        return true;
    }

    @Override
    public void postConsume(ConsumeContext context, List<ConsumeReply> consumeReplies) {
        TraceCaller caller = (TraceCaller)context.getAttribute(CALLER_KEY);
        if (caller == null) {
            return;
        }
        for (ConsumeReply consumeReply : consumeReplies) {
            if (consumeReply.getRetryType().equals((Object)RetryType.NONE)) {
                caller.end();
                continue;
            }
            caller.error();
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

