/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.trace.interceptor;

import java.util.List;
import org.joyqueue.client.internal.common.ordered.Ordered;
import org.joyqueue.client.internal.producer.domain.SendResult;
import org.joyqueue.client.internal.producer.interceptor.ProduceContext;
import org.joyqueue.client.internal.producer.interceptor.ProducerInterceptor;
import org.joyqueue.client.internal.trace.TraceBuilder;
import org.joyqueue.client.internal.trace.TraceCaller;
import org.joyqueue.client.internal.trace.TraceType;

public class TraceProducerInterceptor
implements ProducerInterceptor,
Ordered {
    private static final String CALLER_KEY = "_TRACE_CALLER_";

    @Override
    public boolean preSend(ProduceContext context) {
        TraceCaller caller = TraceBuilder.newInstance().topic(context.getTopic()).app(context.getApp()).namespace(context.getNameserver().getNamespace()).type(TraceType.PRODUCER_SEND).begin();
        context.putAttribute(CALLER_KEY, caller);
        return true;
    }

    @Override
    public void postSend(ProduceContext context, List<SendResult> result) {
        TraceCaller caller = (TraceCaller)context.getAttribute(CALLER_KEY);
        if (caller == null) {
            return;
        }
        caller.end();
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

