/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.trace.support;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.client.internal.trace.Trace;
import org.joyqueue.client.internal.trace.TraceCaller;
import org.joyqueue.client.internal.trace.TraceContext;
import org.joyqueue.client.internal.trace.support.CompositeTraceCaller;

public class CompositeTrace
implements Trace {
    private List<Trace> traces;

    public CompositeTrace(List<Trace> traces) {
        this.traces = traces;
    }

    @Override
    public TraceCaller begin(TraceContext context) {
        LinkedList callers = Lists.newLinkedList();
        for (Trace trace : this.traces) {
            TraceCaller caller = trace.begin(context);
            callers.add(caller);
        }
        return new CompositeTraceCaller(callers);
    }

    public List<Trace> getTraces() {
        return this.traces;
    }

    public String type() {
        return "composite";
    }
}

