/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Future;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.transport.ClientConnectionInfo;
import org.joyqueue.client.internal.transport.ClientConnectionListener;
import org.joyqueue.client.internal.transport.ClientConnectionState;
import org.joyqueue.client.internal.transport.ClientState;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.HeartbeatRequest;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(Client.class);
    private BrokerNode node;
    private TransportConfig transportConfig;
    private TransportClient transportClient;
    private NameServerConfig nameServerConfig;
    private Transport transport;
    private ClientConnectionState connectionState;
    private List<EventListener<TransportEvent>> listeners = Lists.newCopyOnWriteArrayList();

    public Client(BrokerNode node, TransportConfig transportConfig, TransportClient transportClient, NameServerConfig nameServerConfig) {
        this.node = node;
        this.transportConfig = transportConfig;
        this.transportClient = transportClient;
        this.nameServerConfig = nameServerConfig;
        this.connectionState = new ClientConnectionState(nameServerConfig, this);
    }

    public void heartbeat(long timeout) {
        this.sync((Command)new JoyQueueCommand((JoyQueuePayload)new HeartbeatRequest()), timeout);
    }

    public Future<Command> async(Command request, long timeout) {
        try {
            this.connectionState.updateUseTime();
            return this.transport.async(request, timeout);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    public Future<Command> async(Command request) {
        return this.async(request, this.transportConfig.getSendTimeout());
    }

    public void async(Command request, long timeout, final CommandCallback callback) {
        try {
            this.connectionState.updateUseTime();
            this.transport.async(request, timeout, new CommandCallback(){

                public void onSuccess(Command request, Command response) {
                    if (response.isSuccess()) {
                        callback.onSuccess(request, response);
                    } else {
                        callback.onException(request, (Throwable)new JoyQueueException(response.getHeader().getError(), response.getHeader().getStatus()));
                    }
                }

                public void onException(Command request, Throwable cause) {
                    callback.onException(request, cause);
                }
            });
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    public void async(Command request, CommandCallback callback) {
        this.async(request, this.transportConfig.getSendTimeout(), callback);
    }

    public void oneway(Command request, long timeout) {
        try {
            this.connectionState.updateUseTime();
            this.transport.oneway(request, timeout);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    public Command sync(Command request, long timeout) {
        Command response = null;
        try {
            this.connectionState.updateUseTime();
            response = this.transport.sync(request, timeout);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        if (!response.isSuccess()) {
            throw new ClientException(response.getHeader().getError(), response.getHeader().getStatus());
        }
        return response;
    }

    public Command sync(Command request) {
        return this.sync(request, this.transportConfig.getSendTimeout());
    }

    public void handleAddConnection() {
        this.connectionState.handleAddConnection();
    }

    public void handleDisconnection() {
        this.connectionState.handleDisconnection();
    }

    protected void doStart() throws Exception {
        this.transport = this.node.getPort() <= 0 ? this.transportClient.createTransport(this.node.getHost(), (long)this.transportConfig.getSendTimeout()) : this.transportClient.createTransport((SocketAddress)new InetSocketAddress(this.node.getHost(), this.node.getPort()), (long)this.transportConfig.getSendTimeout());
        this.handleAddConnection();
        this.addListener(new ClientConnectionListener(this.transport, this));
    }

    protected void doStop() {
        if (this.transport != null) {
            this.transport.stop();
        }
        for (EventListener<TransportEvent> listener : this.listeners) {
            this.transportClient.removeListener(listener);
        }
    }

    public ClientState getState() {
        switch (this.transport.state()) {
            case CONNECTED: {
                return ClientState.CONNECTED;
            }
            case DISCONNECTED: {
                return ClientState.DISCONNECTED;
            }
        }
        throw new IllegalArgumentException(String.format("unknown state, %s", this.transport.state()));
    }

    public ClientConnectionInfo getConnectionInfo() {
        return this.connectionState.getConnectionInfo();
    }

    public TransportAttribute getAttribute() {
        return this.transport.attr();
    }

    public Transport getTransport() {
        return this.transport;
    }

    public long getLastUseTime() {
        return this.connectionState.getLastUseTime();
    }

    public void addListener(EventListener<TransportEvent> listener) {
        this.listeners.add(listener);
        this.transportClient.addListener(listener);
    }

    public void removeListener(EventListener<TransportEvent> listener) {
        this.listeners.remove(listener);
        this.transportClient.removeListener(listener);
    }
}

