/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.client.internal.ClientConsts;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientConnectionInfo;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.AddConnectionRequest;
import org.joyqueue.network.command.AddConnectionResponse;
import org.joyqueue.network.command.RemoveConnectionRequest;
import org.joyqueue.network.session.ClientId;
import org.joyqueue.network.session.Language;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionState {
    protected static final Logger logger = LoggerFactory.getLogger(ClientConnectionState.class);
    private static final String CONNECTION_INFO_KEY = "_CLIENT_CONNECTION_INFO_";
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private static final String CLIENT_IP = IpUtil.getLocalIp();
    private static final String CLIENT_VERSION = ClientConsts.VERSION;
    private NameServerConfig nameServerConfig;
    private Client client;
    private volatile long lastUseTime;

    public ClientConnectionState(NameServerConfig nameServerConfig, Client client) {
        this.nameServerConfig = nameServerConfig;
        this.client = client;
    }

    public void handleAddConnection() {
        AddConnectionRequest addConnectionRequest = new AddConnectionRequest();
        ClientId clientId = new ClientId();
        if (this.nameServerConfig.getApp().contains(".")) {
            addConnectionRequest.setApp(this.nameServerConfig.getApp().split("\\.")[0]);
        } else {
            addConnectionRequest.setApp(this.nameServerConfig.getApp());
        }
        addConnectionRequest.setToken(this.nameServerConfig.getToken());
        addConnectionRequest.setRegion(this.nameServerConfig.getRegion());
        addConnectionRequest.setNamespace(this.nameServerConfig.getNamespace());
        addConnectionRequest.setLanguage(Language.JAVA);
        clientId.setVersion(CLIENT_VERSION);
        clientId.setIp(CLIENT_IP);
        clientId.setTime(SystemClock.now());
        clientId.setSequence(SEQUENCE.incrementAndGet());
        addConnectionRequest.setClientId(clientId);
        try {
            Command response = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)addConnectionRequest));
            AddConnectionResponse addConnectionResponse = (AddConnectionResponse)response.getPayload();
            ClientConnectionInfo clientConnectionInfo = new ClientConnectionInfo();
            clientConnectionInfo.setConnectionId(addConnectionResponse.getConnectionId());
            this.handleNotification(addConnectionResponse);
            this.client.getAttribute().set((Object)CONNECTION_INFO_KEY, (Object)clientConnectionInfo);
        }
        catch (ClientException e) {
            int code = e.getCode();
            String error = e.getMessage();
            if (code == JoyQueueCode.CN_AUTHENTICATION_ERROR.getCode()) {
                logger.error("client addConnection error, no permission, please check your app and token", (Object)error);
                throw e;
            }
            logger.error("client addConnection error, app: {}, token: {}, code: {}, error: {}", new Object[]{addConnectionRequest.getApp(), addConnectionRequest.getToken(), code, error});
            throw e;
        }
    }

    protected void handleNotification(AddConnectionResponse addConnectionResponse) {
        if (StringUtils.isBlank((CharSequence)addConnectionResponse.getNotification())) {
            return;
        }
        this.doHandleNotification(addConnectionResponse);
    }

    protected void doHandleNotification(AddConnectionResponse addConnectionResponse) {
        logger.warn("{}", (Object)addConnectionResponse.getNotification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDisconnection() {
        ClientConnectionInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo == null) {
            return;
        }
        RemoveConnectionRequest removeConnectionRequest = new RemoveConnectionRequest();
        try {
            Command command = this.client.sync((Command)new JoyQueueCommand((JoyQueuePayload)removeConnectionRequest));
        }
        catch (Exception e) {
            logger.debug("client removeConnection error, connection: {}", (Object)removeConnectionRequest, (Object)e);
        }
        finally {
            this.client.getAttribute().remove((Object)CONNECTION_INFO_KEY);
        }
    }

    public ClientConnectionInfo getConnectionInfo() {
        return (ClientConnectionInfo)this.client.getAttribute().get((Object)CONNECTION_INFO_KEY);
    }

    public void updateUseTime() {
        this.lastUseTime = SystemClock.now();
    }

    public long getLastUseTime() {
        return this.lastUseTime;
    }
}

