/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.toolkit.service.Service;

public class ClientGroup
extends Service {
    private BrokerNode node;
    private TransportConfig transportConfig;
    private TransportClient transportClient;
    private NameServerConfig nameServerConfig;
    private List<Client> clients = Lists.newCopyOnWriteArrayList();
    private AtomicInteger connections = new AtomicInteger();
    private AtomicInteger next = new AtomicInteger();

    public ClientGroup(BrokerNode node, TransportConfig transportConfig, TransportClient transportClient, NameServerConfig nameServerConfig) {
        this.node = node;
        this.transportConfig = transportConfig;
        this.transportClient = transportClient;
        this.nameServerConfig = nameServerConfig;
    }

    public Client getClient() {
        if (this.connections.get() < this.transportConfig.getConnections() && this.connections.incrementAndGet() < this.transportConfig.getConnections()) {
            try {
                return this.initClient(this.node, this.transportConfig, this.transportClient);
            }
            catch (Exception e) {
                this.connections.decrementAndGet();
                if (e instanceof TransportException) {
                    throw (TransportException)e;
                }
                throw new ClientException(e);
            }
        }
        return this.doGetClient();
    }

    public Client doGetClient() {
        if (this.clients.size() == 1) {
            return this.clients.get(0);
        }
        return this.selectClient();
    }

    protected Client selectClient() {
        int index = this.next.getAndIncrement();
        if (index >= this.clients.size()) {
            this.next.set(1);
            index = 0;
        }
        return this.clients.get(index);
    }

    public Client tryGetClient() {
        return this.clients.get(0);
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public BrokerNode getNode() {
        return this.node;
    }

    protected Client initClient(BrokerNode node, TransportConfig transportConfig, TransportClient transportClient) throws Exception {
        Client client = new Client(node, transportConfig, transportClient, this.nameServerConfig);
        client.start();
        this.clients.add(client);
        return client;
    }

    protected void doStart() throws Exception {
        this.initClient(this.node, this.transportConfig, this.transportClient);
    }

    protected void doStop() {
        for (Client client : this.clients) {
            client.stop();
        }
    }
}

