/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.transport.ClientGroup;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientGroupManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ClientGroupManager.class);
    private TransportConfig config;
    private Cache<BrokerNode, ClientGroup> clientGroupCache;

    public ClientGroupManager(TransportConfig config) {
        this.config = config;
    }

    public ClientGroup tryGetClientGroup(BrokerNode node) {
        return (ClientGroup)((Object)this.clientGroupCache.asMap().get(node));
    }

    public ClientGroup getClientGroup(BrokerNode node) {
        return (ClientGroup)((Object)this.clientGroupCache.getIfPresent((Object)node));
    }

    public ClientGroup getClientGroup(BrokerNode node, final Callable<ClientGroup> callable) throws Exception {
        return (ClientGroup)((Object)this.clientGroupCache.get((Object)node, (Callable)new Callable<ClientGroup>(){

            @Override
            public ClientGroup call() throws Exception {
                return (ClientGroup)((Object)callable.call());
            }
        }));
    }

    public void closeClientGroup(ClientGroup clientGroup) {
        this.clientGroupCache.invalidate((Object)clientGroup.getNode());
    }

    public void closeClientGroup(BrokerNode node) {
        this.clientGroupCache.invalidate((Object)node);
    }

    public List<ClientGroup> getGroups() {
        return Lists.newArrayList(this.clientGroupCache.asMap().values());
    }

    protected void validate() throws Exception {
        this.clientGroupCache = CacheBuilder.newBuilder().expireAfterAccess((long)this.config.getChannelMaxIdleTime(), TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<BrokerNode, ClientGroup>(){

            public void onRemoval(RemovalNotification<BrokerNode, ClientGroup> removalNotification) {
                try {
                    ((ClientGroup)((Object)removalNotification.getValue())).stop();
                }
                catch (Exception e) {
                    logger.error("close client exception, address: {}, error: {}", (Object)((BrokerNode)removalNotification.getKey()).getHost(), (Object)e.getMessage());
                    logger.debug("close client exception, address: {}", (Object)((BrokerNode)removalNotification.getKey()).getHost(), (Object)e);
                }
            }
        }).build();
    }

    protected void doStop() {
        if (this.clientGroupCache != null) {
            for (Map.Entry entry : this.clientGroupCache.asMap().entrySet()) {
                ((ClientGroup)((Object)entry.getValue())).stop();
            }
        }
    }
}

