/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientGroup;
import org.joyqueue.client.internal.transport.ClientGroupManager;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.network.transport.TransportState;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHeartbeatThread
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(ClientHeartbeatThread.class);
    private TransportConfig transportConfig;
    private ClientGroupManager clientGroupManager;

    public ClientHeartbeatThread(TransportConfig transportConfig, ClientGroupManager clientGroupManager) {
        this.transportConfig = transportConfig;
        this.clientGroupManager = clientGroupManager;
    }

    @Override
    public void run() {
        for (ClientGroup clientGroup : this.clientGroupManager.getGroups()) {
            this.doHeartbeat(clientGroup);
        }
    }

    protected void doHeartbeat(ClientGroup clientGroup) {
        for (Client client : clientGroup.getClients()) {
            if (!client.getTransport().state().equals((Object)TransportState.DISCONNECTED) && (client.getLastUseTime() == 0L || SystemClock.now() - client.getLastUseTime() < (long)this.transportConfig.getHeartbeatMaxIdleTime())) continue;
            this.doHeartbeat(client);
        }
    }

    protected void doHeartbeat(Client client) {
        try {
            client.heartbeat(this.transportConfig.getHeartbeatTimeout());
        }
        catch (Exception e) {
            logger.debug("client heartbeat exception", (Throwable)e);
        }
    }
}

