/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.client.internal.transport;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.client.internal.exception.ClientException;
import org.joyqueue.client.internal.nameserver.NameServerConfig;
import org.joyqueue.client.internal.nameserver.NameServerConfigChecker;
import org.joyqueue.client.internal.transport.Client;
import org.joyqueue.client.internal.transport.ClientGroup;
import org.joyqueue.client.internal.transport.ClientGroupManager;
import org.joyqueue.client.internal.transport.ClientHeartbeatThread;
import org.joyqueue.client.internal.transport.config.TransportConfig;
import org.joyqueue.client.internal.transport.config.TransportConfigChecker;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.support.DefaultTransportClientFactory;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ClientManager.class);
    private TransportConfig transportConfig;
    private NameServerConfig nameServerConfig;
    private TransportClient transportClient;
    private ClientGroupManager clientGroupManager;
    private ScheduledExecutorService heartbeatThreadScheduler;

    public ClientManager(TransportConfig transportConfig, NameServerConfig nameServerConfig) {
        TransportConfigChecker.check(transportConfig);
        NameServerConfigChecker.check(nameServerConfig);
        this.transportConfig = transportConfig;
        this.nameServerConfig = nameServerConfig;
    }

    protected void validate() throws Exception {
        this.transportConfig = this.transportConfig.copy();
        this.clientGroupManager = new ClientGroupManager(this.transportConfig);
        this.transportClient = new DefaultTransportClientFactory().create(this.convertToClientConfig(this.transportConfig));
        this.heartbeatThreadScheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("joyqueue-client-heartbeat"));
    }

    protected void doStart() throws Exception {
        this.clientGroupManager.start();
        this.heartbeatThreadScheduler.scheduleWithFixedDelay(new ClientHeartbeatThread(this.transportConfig, this.clientGroupManager), this.transportConfig.getHeartbeatInterval(), this.transportConfig.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.heartbeatThreadScheduler != null) {
            this.heartbeatThreadScheduler.shutdown();
        }
        if (this.clientGroupManager != null) {
            this.clientGroupManager.stop();
        }
        if (this.transportClient != null) {
            this.transportClient.stop();
        }
    }

    public ClientGroup getClientGroup(BrokerNode node) {
        this.checkState();
        return this.clientGroupManager.getClientGroup(node);
    }

    public Client createClient(BrokerNode node) {
        this.checkState();
        try {
            Client client = new Client(node, this.transportConfig, this.transportClient, this.nameServerConfig);
            client.start();
            return client;
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    public Client getOrCreateClient(BrokerNode node) {
        this.checkState();
        return this.doGetOrCreateClientGroup(node).getClient();
    }

    public Client doGetOrCreateClient(BrokerNode node) {
        this.checkState();
        return this.doGetOrCreateClientGroup(node).getClient();
    }

    protected ClientGroup doGetOrCreateClientGroup(final BrokerNode node) {
        try {
            return this.clientGroupManager.getClientGroup(node, new Callable<ClientGroup>(){

                @Override
                public ClientGroup call() throws Exception {
                    ClientGroup clientGroup = new ClientGroup(node, ClientManager.this.transportConfig, ClientManager.this.transportClient, ClientManager.this.nameServerConfig);
                    clientGroup.start();
                    return clientGroup;
                }
            });
        }
        catch (Exception e) {
            logger.debug("get client exception, node: {}", (Object)node, (Object)e);
            throw new ClientException(e);
        }
    }

    public Client tryGetClient(BrokerNode node) {
        this.checkState();
        ClientGroup clientGroup = this.clientGroupManager.tryGetClientGroup(node);
        if (clientGroup == null) {
            return null;
        }
        return clientGroup.tryGetClient();
    }

    public Client getClient(BrokerNode node) {
        this.checkState();
        ClientGroup clientGroup = this.clientGroupManager.getClientGroup(node);
        if (clientGroup == null) {
            return null;
        }
        Client client = clientGroup.getClient();
        return client;
    }

    public void closeClient(BrokerNode node) {
        this.checkState();
        ClientGroup clientGroup = this.clientGroupManager.getClientGroup(node);
        if (clientGroup == null) {
            return;
        }
        this.clientGroupManager.closeClientGroup(clientGroup);
    }

    protected void checkState() {
        if (!this.isStarted()) {
            throw new ClientException("clientManager is not started", JoyQueueCode.CN_SERVICE_NOT_AVAILABLE.getCode());
        }
    }

    protected ClientConfig convertToClientConfig(TransportConfig transportConfig) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setSendTimeout(transportConfig.getSendTimeout());
        clientConfig.setIoThread(transportConfig.getIoThreads());
        clientConfig.setCallbackThreads(transportConfig.getCallbackThreads());
        clientConfig.setSoLinger(transportConfig.getSoLinger());
        clientConfig.setTcpNoDelay(transportConfig.isTcpNoDelay());
        clientConfig.setKeepAlive(transportConfig.isKeepAlive());
        clientConfig.setSoTimeout(transportConfig.getSoTimeout());
        clientConfig.setSocketBufferSize(transportConfig.getSocketBufferSize());
        clientConfig.setMaxOneway(transportConfig.getMaxOneway());
        clientConfig.setMaxAsync(transportConfig.getMaxAsync());
        clientConfig.setRetryPolicy(transportConfig.getRetryPolicy());
        clientConfig.setNonBlockOneway(transportConfig.isNonBlockOneway());
        clientConfig.setIoThreadName("joyqueue-client-io-eventLoop");
        return clientConfig;
    }
}

