/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.joyqueue.datasource.DataSourceConfig;
import org.joyqueue.datasource.DataSourceFactory;
import org.joyqueue.domain.ConsumeRetry;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.api.RetryPolicyProvider;
import org.joyqueue.server.retry.h2.config.H2RetryConfigKey;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.model.RetryStatus;
import org.joyqueue.server.retry.util.RetryUtil;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.db.DaoUtil;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2MessageRetry
implements MessageRetry<Long> {
    private static final Logger logger = LoggerFactory.getLogger(H2MessageRetry.class);
    private static final String QUERY_SQL_NOID = "select id, business_id, topic, app, data, exception, send_time from message_retry where status = " + RetryStatus.RETRY_ING.getValue() + " and topic = ? and app = ? and retry_time<=? limit ?, ?";
    private static final String QUERY_COUNT_SQL = "select count(1) from message_retry where status = " + RetryStatus.RETRY_ING.getValue() + " and topic = ? and app = ?";
    private static final String ERROR_UPDATE_SQL = "update message_retry set retry_time = ?, retry_count = retry_count + 1, update_time = ?, status = ? where id = ? and status = " + RetryStatus.RETRY_ING.getValue();
    private static final String EXPIRE_UPDATE_SQL = "update message_retry set status = " + RetryStatus.RETRY_EXPIRE.getValue() + ", update_time = ? where id = ? and status = " + RetryStatus.RETRY_ING.getValue();
    private static final String SUCCESS_UPDATE_SQL = "update message_retry set status = " + RetryStatus.RETRY_SUCCESS.getValue() + ", retry_count = retry_count + 1, update_time = ? where id = ? and status = " + RetryStatus.RETRY_ING.getValue();
    private static final String CREATE_SQL = "insert into message_retry (message_id, business_id, topic, app, send_time, expire_time, retry_time, retry_count, status, data, exception, create_time, update_time) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String GET_SQL = "select id, business_id, topic, app, data, exception, send_time from message_retry where status = " + RetryStatus.RETRY_ING.getValue() + " and topic = ? and app = ? and retry_time <= ? and id = ?";
    private static final String QUERY_ENTITY_SQL = "select id, create_time, retry_count from message_retry where id = ? and topic = ?";
    private static final String QUERY_ID_RETRY_TIME_SQL = "select id, retry_time from message_retry where status = " + RetryStatus.RETRY_ING.getValue() + " and topic = ? and app = ? and retry_time < NOW() order by id asc limit ?";
    private DataSource dataSource;
    private boolean isStartFlag = false;
    private RetryPolicyProvider retryPolicyProvider;
    private DataSourceConfig writeDataSourceConfig = null;
    private RetryPolicy retryPolicy = null;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void start() {
        this.dataSource = DataSourceFactory.build((DataSourceConfig)this.writeDataSourceConfig);
        this.isStartFlag = true;
        logger.info("db retry manager is started");
    }

    public boolean isStarted() {
        return this.isStartFlag;
    }

    public void stop() {
        if (this.dataSource != null) {
            Close.close((DataSource)this.dataSource);
            this.dataSource = null;
        }
        this.isStartFlag = false;
        logger.info("db retry manager is stopped");
    }

    public void setRetryPolicyProvider(RetryPolicyProvider retryPolicyProvider) {
        this.retryPolicyProvider = retryPolicyProvider;
    }

    public void addRetry(List<RetryMessageModel> retryMessageModelList) throws JoyQueueException {
        List<ConsumeRetry> consumeRetries = this.generateConsumeRetry(retryMessageModelList);
        this.insertConsumeRetry(consumeRetries);
    }

    public List<ConsumeRetry> generateConsumeRetry(List<RetryMessageModel> retryMessageModelList) throws JoyQueueException {
        LinkedList<ConsumeRetry> resultList = new LinkedList<ConsumeRetry>();
        for (RetryMessageModel retryMessageModel : retryMessageModelList) {
            ConsumeRetry consumeRetry = new ConsumeRetry();
            consumeRetry.setMessageId(RetryUtil.generateMessageId((String)retryMessageModel.getTopic(), (short)retryMessageModel.getPartition(), (long)retryMessageModel.getIndex(), (long)retryMessageModel.getSendTime()));
            consumeRetry.setBusinessId(retryMessageModel.getBusinessId());
            consumeRetry.setTopic(retryMessageModel.getTopic());
            consumeRetry.setApp(retryMessageModel.getApp());
            consumeRetry.setSendTime(retryMessageModel.getSendTime());
            RetryPolicy retryPolicy = this.retryPolicyProvider.getPolicy(TopicName.parse((String)retryMessageModel.getTopic()), retryMessageModel.getApp());
            consumeRetry.setExpireTime(this.getExpireTime(retryPolicy, SystemClock.now()));
            consumeRetry.setRetryTime(this.getRetryTime(retryPolicy, SystemClock.now(), 1));
            consumeRetry.setRetryCount((short)0);
            consumeRetry.setData(retryMessageModel.getBrokerMessage());
            consumeRetry.setException(retryMessageModel.getException());
            consumeRetry.setCreateTime(SystemClock.now());
            consumeRetry.setUpdateTime(SystemClock.now());
            consumeRetry.setStatus(RetryStatus.RETRY_ING.getValue());
            resultList.add(consumeRetry);
        }
        return resultList;
    }

    public Map<Long, ConsumeRetry> insertConsumeRetry(List<ConsumeRetry> messages) throws JoyQueueException {
        final HashMap<Long, ConsumeRetry> dbIdConsumeRetryMap = new HashMap<Long, ConsumeRetry>();
        String topic = messages.get(0).getTopic();
        String app = messages.get(0).getApp();
        try {
            int n = DaoUtil.insert((DataSource)this.dataSource, messages, (String)CREATE_SQL, (DaoUtil.UpdateCallback)new DaoUtil.InsertCallback<ConsumeRetry>(){

                public void after(ResultSet resultSet, ConsumeRetry consumeRetry) throws Exception {
                    long dbId = resultSet.getLong(1);
                    dbIdConsumeRetryMap.put(dbId, consumeRetry);
                }

                public void before(PreparedStatement statement, ConsumeRetry consumeRetry) throws Exception {
                    statement.setString(1, consumeRetry.getMessageId());
                    statement.setString(2, consumeRetry.getBusinessId());
                    if (consumeRetry.getBusinessId() != null && consumeRetry.getBusinessId().length() > 100) {
                        logger.error("businessId to long,topic:{},app:{},businessId:{}.", new Object[]{consumeRetry.getTopic(), consumeRetry.getApp(), consumeRetry.getBusinessId()});
                    }
                    statement.setString(3, consumeRetry.getTopic());
                    statement.setString(4, consumeRetry.getApp());
                    statement.setTimestamp(5, new Timestamp(consumeRetry.getSendTime()));
                    statement.setTimestamp(6, new Timestamp(consumeRetry.getExpireTime()));
                    statement.setTimestamp(7, new Timestamp(consumeRetry.getRetryTime()));
                    statement.setInt(8, consumeRetry.getRetryCount());
                    statement.setShort(9, consumeRetry.getStatus());
                    statement.setBytes(10, consumeRetry.getData());
                    statement.setBytes(11, consumeRetry.getException());
                    statement.setTimestamp(12, new Timestamp(consumeRetry.getCreateTime()));
                    statement.setTimestamp(13, new Timestamp(consumeRetry.getUpdateTime()));
                }
            });
        }
        catch (Exception e) {
            throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR.getMessage(new Object[0]) + ",topic:" + topic + ",app:" + app, (Throwable)e, JoyQueueCode.CN_DB_ERROR.getCode());
        }
        return dbIdConsumeRetryMap;
    }

    public long getExpireTime(RetryPolicy retryPolicy, long currentTime) {
        long expireTime = retryPolicy.getExpireTime() != null ? (long)retryPolicy.getExpireTime().intValue() : 0L;
        if ((expireTime = expireTime > 0L ? currentTime + expireTime : currentTime + 2592000000L) < 1000L) {
            expireTime = 1000L;
        }
        return expireTime;
    }

    private long getRetryTime(RetryPolicy retryPolicy, long currentTime, int retryTimes) {
        return retryPolicy.getTime(currentTime, retryTimes, currentTime);
    }

    public void retrySuccess(String topic, String app, Long[] messageIds) throws JoyQueueException {
        if (topic == null || topic.isEmpty() || app == null || app.isEmpty() || messageIds == null || messageIds.length == 0) {
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(messageIds.length);
        Long[] longArray = messageIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long messageId = longArray[i];
            if (messageId <= 0L) continue;
            idList.add(messageId);
        }
        try {
            Timestamp timestamp = new Timestamp(SystemClock.now());
            DaoUtil.update((DataSource)this.dataSource, idList, (String)SUCCESS_UPDATE_SQL, (statement, target) -> {
                statement.setTimestamp(1, timestamp);
                statement.setLong(2, (long)target);
            });
        }
        catch (Exception e) {
            throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public void retryError(String topic, String app, Long[] messageIds) throws JoyQueueException {
        if (topic == null || topic.isEmpty() || app == null || app.isEmpty() || messageIds == null || messageIds.length == 0) {
            return;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(ERROR_UPDATE_SQL);
            long now = SystemClock.now();
            Timestamp timestamp = new Timestamp(now);
            Long[] longArray = messageIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long messageId = longArray[i];
                Long nextRetryTime = this.getNextRetryTime(messageId, topic);
                if (nextRetryTime == null) continue;
                if (nextRetryTime <= 0L) {
                    statement.setTimestamp(1, timestamp);
                    statement.setTimestamp(2, timestamp);
                    statement.setInt(3, RetryStatus.RETRY_EXPIRE.getValue());
                } else {
                    statement.setTimestamp(1, new Timestamp(nextRetryTime));
                    statement.setTimestamp(2, timestamp);
                    statement.setInt(3, RetryStatus.RETRY_ING.getValue());
                }
                statement.setLong(4, messageId);
                statement.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Close.close((Connection)connection, statement, null);
                throw throwable;
            }
        }
        Close.close((Connection)connection, (Statement)statement, null);
    }

    protected Long getNextRetryTime(long id, String topic) throws JoyQueueException {
        Long nextRetryTime;
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block6: {
            connection = null;
            statement = null;
            resultSet = null;
            nextRetryTime = null;
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(QUERY_ENTITY_SQL);
            if (id > 0L) break block6;
            Long l = null;
            Close.close((Connection)connection, (Statement)statement, resultSet);
            return l;
        }
        try {
            statement.setLong(1, id);
            statement.setString(2, topic);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                resultSet.getLong(1);
                Timestamp createTime = resultSet.getTimestamp(2);
                long startTime = createTime.getTime();
                int retryCount = resultSet.getInt(3);
                nextRetryTime = this.retryPolicy.getTime(SystemClock.now(), retryCount, startTime);
            }
        }
        catch (Exception e) {
            try {
                throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Close.close((Connection)connection, statement, resultSet);
                throw throwable;
            }
        }
        Close.close((Connection)connection, (Statement)statement, (ResultSet)resultSet);
        return nextRetryTime;
    }

    public void retryExpire(String topic, String app, Long[] messageIds) throws JoyQueueException {
        if (topic == null || topic.isEmpty() || app == null || app.isEmpty() || messageIds == null || messageIds.length == 0) {
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(messageIds.length);
        Long[] longArray = messageIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long messageId = longArray[i];
            if (messageId <= 0L) continue;
            idList.add(messageId);
        }
        try {
            DaoUtil.update((DataSource)this.dataSource, idList, (String)EXPIRE_UPDATE_SQL, (statement, target) -> {
                statement.setTimestamp(1, new Timestamp(SystemClock.now()));
                statement.setLong(2, (long)target);
            });
        }
        catch (Exception e) {
            throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public List<RetryMessageModel> getRetry(final String topic, final String app, final short count, final long startIndex) throws JoyQueueException {
        if (topic == null || topic.isEmpty() || app == null || app.isEmpty() || count <= 0) {
            return new ArrayList<RetryMessageModel>(0);
        }
        final long nowTime = SystemClock.now();
        try {
            List list = DaoUtil.queryList((DataSource)this.dataSource, (String)QUERY_SQL_NOID, (DaoUtil.QueryCallback)new DaoUtil.QueryCallback<RetryMessageModel>(){

                public RetryMessageModel map(ResultSet rs) throws Exception {
                    RetryMessageModel message = new RetryMessageModel();
                    message.setIndex((long)rs.getInt(1));
                    message.setBusinessId(rs.getString(2));
                    message.setTopic(rs.getString(3));
                    message.setApp(rs.getString(4));
                    message.setPartition((short)Short.MAX_VALUE);
                    message.setBrokerMessage(rs.getBytes(5));
                    message.setException(rs.getBytes(6));
                    message.setSendTime(rs.getTimestamp(7).getTime());
                    return message;
                }

                public void before(PreparedStatement statement) throws Exception {
                    statement.setString(1, topic);
                    statement.setString(2, app);
                    statement.setTimestamp(3, new Timestamp(nowTime));
                    statement.setLong(4, startIndex);
                    statement.setInt(5, count);
                }
            });
            return list;
        }
        catch (Exception e) {
            throw new JoyQueueException(String.format("%s topic:%s,app:%s,count:%d", JoyQueueCode.CN_DB_ERROR.getMessage(new Object[0]), topic, app, count), (Throwable)e, JoyQueueCode.CN_DB_ERROR.getCode());
        }
    }

    public int countRetry(final String topic, final String app) throws JoyQueueException {
        if (topic == null || topic.isEmpty() || app == null || app.isEmpty()) {
            return 0;
        }
        long start = SystemClock.now();
        try {
            int count;
            int n = count = ((Integer)DaoUtil.queryObject((DataSource)this.dataSource, (String)QUERY_COUNT_SQL, (DaoUtil.QueryCallback)new DaoUtil.QueryCallback<Integer>(){

                public Integer map(ResultSet rs) throws Exception {
                    return rs.getInt(1);
                }

                public void before(PreparedStatement statement) throws Exception {
                    statement.setString(1, topic);
                    statement.setString(2, app);
                }
            })).intValue();
            return n;
        }
        catch (Exception e) {
            throw new JoyQueueException(JoyQueueCode.CN_DB_ERROR, (Throwable)e, new Object[0]);
        }
        finally {
            if (logger.isDebugEnabled()) {
                long end = SystemClock.now();
                logger.debug("\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u91cd\u8bd5\u8bb0\u5f55\u603b\u6570\u8017\u65f6\u7edf\u8ba1,topic=" + topic + ",app=" + app + ",time=" + (end - start));
            }
        }
    }

    public RetryMessageModel getMessageById(final String topic, final String app, final long id) throws JoyQueueException {
        final long nowTime = SystemClock.now();
        try {
            RetryMessageModel retryMessageModel = (RetryMessageModel)DaoUtil.queryObject((DataSource)this.dataSource, (String)GET_SQL, (DaoUtil.QueryCallback)new DaoUtil.QueryCallback<RetryMessageModel>(){

                public void before(PreparedStatement preparedStatement) throws Exception {
                    preparedStatement.setString(1, topic);
                    preparedStatement.setString(2, app);
                    preparedStatement.setTimestamp(3, new Timestamp(nowTime));
                    preparedStatement.setLong(4, id);
                }

                public RetryMessageModel map(ResultSet rs) throws Exception {
                    RetryMessageModel message = new RetryMessageModel();
                    message.setIndex((long)rs.getInt(1));
                    message.setBusinessId(rs.getString(2));
                    message.setTopic(rs.getString(3));
                    message.setApp(rs.getString(4));
                    message.setPartition((short)Short.MAX_VALUE);
                    message.setBrokerMessage(rs.getBytes(5));
                    message.setException(rs.getBytes(6));
                    message.setSendTime(rs.getLong(7));
                    return message;
                }
            });
            return retryMessageModel;
        }
        catch (Exception e) {
            throw new JoyQueueException(String.format("%s topic:%s,app:%s,id:%d", JoyQueueCode.CN_DB_ERROR.getMessage(new Object[0]), topic, app, id), (Throwable)e, JoyQueueCode.CN_DB_ERROR.getCode());
        }
    }

    public List<long[]> queryIdAndRetryTime(final String topic, final String app, final int count) throws JoyQueueException {
        try {
            List dbIds = DaoUtil.queryList((DataSource)this.dataSource, (String)QUERY_ID_RETRY_TIME_SQL, (DaoUtil.QueryCallback)new DaoUtil.QueryCallback<long[]>(){

                public void before(PreparedStatement preparedStatement) throws Exception {
                    preparedStatement.setString(1, topic);
                    preparedStatement.setString(2, app);
                    preparedStatement.setInt(3, count);
                }

                public long[] map(ResultSet resultSet) throws Exception {
                    long id = resultSet.getLong(1);
                    long retryTime = resultSet.getTimestamp(2).getTime();
                    long[] rst = new long[]{id, retryTime};
                    return rst;
                }
            });
            return dbIds;
        }
        catch (Exception e) {
            throw new JoyQueueException(String.format("%s topic:%s,app:%s,count:%d", JoyQueueCode.CN_DB_ERROR.getMessage(new Object[0]), topic, app, count), (Throwable)e, JoyQueueCode.CN_DB_ERROR.getCode());
        }
    }

    public void setSupplier(PropertySupplier supplier) {
        this.writeDataSourceConfig = new DataSourceConfig();
        this.writeDataSourceConfig.setDriver((String)supplier.getValue((PropertyDef)H2RetryConfigKey.DRIVER));
        this.writeDataSourceConfig.setUrl((String)supplier.getValue((PropertyDef)H2RetryConfigKey.WRITE_URL));
        this.writeDataSourceConfig.setUser((String)supplier.getValue((PropertyDef)H2RetryConfigKey.WRITE_USER_NAME));
        this.writeDataSourceConfig.setPassword((String)supplier.getValue((PropertyDef)H2RetryConfigKey.WRITE_PASSWORD));
        this.retryPolicy = new RetryPolicy((Integer)supplier.getValue((PropertyDef)H2RetryConfigKey.RETRY_DELAY), (Integer)supplier.getValue((PropertyDef)H2RetryConfigKey.MAX_RETRY_TIMES));
    }
}

