/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import io.journalkeeper.metric.JMetric;
import io.journalkeeper.metric.JMetricReport;
import io.journalkeeper.metrics.dropwizard.MetricReport;

public class MetricInstance
implements JMetric {
    private final String name;
    private final MetricRegistry metrics;
    private Histogram latency;
    private Counter counter;
    private Counter traffic;
    private long startTimeNs;
    private long tmpStartTime = 0L;

    public MetricInstance(String name) {
        this.name = name;
        this.metrics = new MetricRegistry();
        this.reset();
    }

    private String latencyMetricName() {
        return this.name + "-latency";
    }

    private String counterMetricName() {
        return this.name + "-counter";
    }

    private String trafficMetricName() {
        return this.name + "-traffic";
    }

    public void start() {
        this.tmpStartTime = System.nanoTime();
    }

    public void end() {
        this.end(0L);
    }

    public void end(long traffic) {
        this.mark(System.nanoTime() - this.tmpStartTime, traffic);
    }

    public void mark(long latencyNs, long traffic) {
        this.counter.inc();
        this.latency.update(latencyNs);
        this.traffic.inc(traffic);
    }

    public void reset() {
        this.metrics.remove(this.latencyMetricName());
        this.metrics.remove(this.counterMetricName());
        this.metrics.remove(this.trafficMetricName());
        this.latency = this.metrics.histogram(this.latencyMetricName());
        this.counter = this.metrics.counter(this.counterMetricName());
        this.traffic = this.metrics.counter(this.trafficMetricName());
        this.startTimeNs = System.nanoTime();
    }

    public JMetricReport get() {
        return new MetricReport(this.name, this.counter.getCount(), this.traffic.getCount(), this.latency.getSnapshot(), this.startTimeNs, System.nanoTime());
    }

    public String name() {
        return this.name;
    }
}

