/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.metrics.dropwizard;

import com.codahale.metrics.Snapshot;
import io.journalkeeper.metric.JMetricReport;

public class MetricReport
implements JMetricReport {
    private final long counter;
    private final long traffic;
    private final Snapshot latency;
    private final long start;
    private final long end;
    private final String name;

    public MetricReport(String name, long counter, long traffic, Snapshot latency, long start, long end) {
        this.counter = counter;
        this.traffic = traffic;
        this.latency = latency;
        this.start = start;
        this.end = end;
        this.name = name;
    }

    public long trafficTotal() {
        return this.traffic;
    }

    public long requestsTotal() {
        return this.counter;
    }

    public long trafficPs() {
        long div = (this.end - this.start) / 1000000000L;
        return div > 0L ? this.traffic / div : 0L;
    }

    public long requestsPs() {
        long div = (this.end - this.start) / 1000000000L;
        return div > 0L ? this.counter / div : 0L;
    }

    public double[] latency() {
        return new double[]{this.latency.getMean(), this.latency.getValue(0.5), this.latency.getValue(0.9), this.latency.getValue(0.95), this.latency.getValue(0.99), this.latency.getValue(0.999), this.latency.getValue(0.9999), this.latency.getMax()};
    }

    public long reportTime() {
        return this.end;
    }

    public String name() {
        return this.name;
    }
}

