/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.persistence.local.journal;

import io.journalkeeper.persistence.local.cache.BufferHolder;
import io.journalkeeper.persistence.local.cache.MemoryCacheManager;
import io.journalkeeper.persistence.local.journal.StoreFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;

public class LocalStoreFile
implements StoreFile,
BufferHolder {
    private static final Logger logger = LoggerFactory.getLogger(LocalStoreFile.class);
    private static final int MAPPED_BUFFER = 0;
    private static final int DIRECT_BUFFER = 1;
    private static final int NO_BUFFER = -1;
    private final long filePosition;
    private final int headerSize;
    private final File file;
    private final StampedLock bufferLock = new StampedLock();
    private ByteBuffer pageBuffer = null;
    private int bufferType = -1;
    private MemoryCacheManager bufferPool;
    private int capacity;
    private long lastAccessTime = System.currentTimeMillis();
    private int flushPosition;
    private int writePosition = 0;
    private long timestamp = -1L;
    private AtomicBoolean flushGate = new AtomicBoolean(false);

    LocalStoreFile(long filePosition, File base, int headerSize, MemoryCacheManager bufferPool, int maxFileDataLength) {
        this.filePosition = filePosition;
        this.headerSize = headerSize;
        this.bufferPool = bufferPool;
        this.capacity = maxFileDataLength;
        this.file = new File(base, String.valueOf(filePosition));
        if (this.file.exists() && this.file.length() > (long)headerSize) {
            this.flushPosition = this.writePosition = (int)(this.file.length() - (long)headerSize);
        }
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public long position() {
        return this.filePosition;
    }

    private void loadRoUnsafe() throws IOException {
        if (null != this.pageBuffer) {
            throw new IOException("Buffer already loaded!");
        }
        this.bufferPool.allocateMMap(this);
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");
             FileChannel fileChannel = raf.getChannel();){
            MappedByteBuffer loadBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.headerSize, this.file.length() - (long)this.headerSize);
            this.pageBuffer = loadBuffer;
            this.bufferType = 0;
            this.pageBuffer.clear();
        }
        catch (ClosedByInterruptException cie) {
            throw cie;
        }
        catch (Throwable t) {
            logger.warn("Exception: ", t);
            this.bufferPool.releaseMMap(this);
            this.pageBuffer = null;
            throw t;
        }
    }

    private void loadRwUnsafe() throws IOException {
        if (this.bufferType == 1) {
            return;
        }
        if (this.bufferType == 0) {
            this.unloadUnsafe();
        }
        ByteBuffer buffer = this.bufferPool.allocateDirect(this.capacity, this);
        this.loadDirectBuffer(buffer);
    }

    private void loadDirectBuffer(ByteBuffer buffer) throws IOException {
        if (this.file.exists() && this.file.length() > (long)this.headerSize) {
            try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");
                 FileChannel fileChannel = raf.getChannel();){
                int length;
                fileChannel.position(this.headerSize);
                while ((length = fileChannel.read(buffer)) > 0) {
                }
            }
            buffer.clear();
        }
        this.pageBuffer = buffer;
        this.bufferType = 1;
    }

    @Override
    public long timestamp() {
        if (this.timestamp == -1L) {
            this.readTimestamp();
        }
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTimestamp() {
        ByteBuffer timeBuffer = ByteBuffer.allocate(8);
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");
             FileChannel fileChannel = raf.getChannel();){
            fileChannel.position(0L);
            fileChannel.read(timeBuffer);
        }
        catch (Exception e) {
            logger.warn("Exception: ", (Throwable)e);
        }
        finally {
            this.timestamp = timeBuffer.getLong(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimestamp() {
        ByteBuffer timeBuffer = ByteBuffer.allocate(8);
        long creationTime = System.currentTimeMillis();
        timeBuffer.putLong(0, creationTime);
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
             FileChannel fileChannel = raf.getChannel();){
            fileChannel.position(0L);
            fileChannel.write(timeBuffer);
        }
        catch (Exception e) {
            logger.warn("Exception:", (Throwable)e);
        }
        finally {
            this.timestamp = creationTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unload() {
        long stamp = this.bufferLock.writeLock();
        try {
            if (this.isClean()) {
                this.unloadUnsafe();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bufferLock.unlockWrite(stamp);
        }
    }

    @Override
    public void forceUnload() {
        long stamp = this.bufferLock.writeLock();
        try {
            this.unloadUnsafe();
        }
        finally {
            this.bufferLock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean hasPage() {
        return this.bufferType != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(int position, int length) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (!this.hasPage()) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRoUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            ByteBuffer byteBuffer = this.pageBuffer.asReadOnlyBuffer();
            byteBuffer.position(position);
            byteBuffer.limit(this.writePosition);
            ByteBuffer dest = ByteBuffer.allocate(Math.min(length, byteBuffer.remaining()));
            if (length < byteBuffer.remaining()) {
                byteBuffer.limit(byteBuffer.position() + length);
            }
            dest.put(byteBuffer);
            dest.flip();
            ByteBuffer byteBuffer2 = dest;
            return byteBuffer2;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long readLong(int position) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (!this.hasPage()) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRoUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            Long l = this.pageBuffer.getLong(position);
            return l;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    private int appendToPageBuffer(ByteBuffer byteBuffer) {
        this.pageBuffer.position(this.writePosition);
        int writeLength = byteBuffer.remaining();
        this.pageBuffer.put(byteBuffer);
        this.writePosition += writeLength;
        return writeLength;
    }

    private int appendToPageBuffer(List<ByteBuffer> byteBuffers) {
        this.pageBuffer.position(this.writePosition);
        int writeLength = 0;
        for (ByteBuffer byteBuffer : byteBuffers) {
            writeLength += byteBuffer.remaining();
            this.pageBuffer.put(byteBuffer);
        }
        this.writePosition += writeLength;
        return writeLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int append(ByteBuffer byteBuffer) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (this.bufferType != 1) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRwUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            int n = this.appendToPageBuffer(byteBuffer);
            return n;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int append(List<ByteBuffer> byteBuffers) throws IOException {
        this.touch();
        long stamp = this.bufferLock.readLock();
        try {
            while (this.bufferType != 1) {
                long ws = this.bufferLock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    this.loadRwUnsafe();
                    continue;
                }
                this.bufferLock.unlockRead(stamp);
                stamp = this.bufferLock.writeLock();
            }
            long rs = this.bufferLock.tryConvertToReadLock(stamp);
            if (rs != 0L) {
                stamp = rs;
            }
            int n = this.appendToPageBuffer(byteBuffers);
            return n;
        }
        finally {
            this.bufferLock.unlock(stamp);
        }
    }

    private void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    /*
     * Exception decompiling
     */
    @Override
    public int flush() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int flushPageBuffer(FileChannel fileChannel) throws IOException {
        int flushEnd = this.writePosition;
        ByteBuffer flushBuffer = this.pageBuffer.asReadOnlyBuffer();
        flushBuffer.position(this.flushPosition);
        flushBuffer.limit(flushEnd);
        fileChannel.position(this.headerSize + this.flushPosition);
        int flushSize = flushEnd - this.flushPosition;
        while (flushBuffer.hasRemaining()) {
            fileChannel.write(flushBuffer);
        }
        this.flushPosition = flushEnd;
        return flushSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(int position) throws IOException {
        if (position < this.writePosition) {
            this.writePosition = position;
        }
        if (position < this.flushPosition) {
            while (!this.flushGate.compareAndSet(false, true)) {
                Thread.yield();
            }
            try {
                this.flushPosition = position;
                try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                     FileChannel fileChannel = raf.getChannel();){
                    fileChannel.truncate(position + this.headerSize);
                }
            }
            finally {
                this.flushGate.compareAndSet(true, false);
            }
        }
    }

    @Override
    public boolean isClean() {
        return this.flushPosition >= this.writePosition;
    }

    @Override
    public int writePosition() {
        return this.writePosition;
    }

    @Override
    public int fileDataSize() {
        return Math.max((int)this.file.length() - this.headerSize, 0);
    }

    @Override
    public int flushPosition() {
        return this.flushPosition;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    private void unloadUnsafe() {
        if (0 == this.bufferType) {
            this.unloadMappedBuffer();
        } else if (1 == this.bufferType) {
            this.unloadDirectBuffer();
        }
    }

    private void unloadDirectBuffer() {
        ByteBuffer direct = this.pageBuffer;
        this.pageBuffer = null;
        this.bufferType = -1;
        if (null != direct) {
            this.bufferPool.releaseDirect(direct, this);
        }
    }

    private void unloadMappedBuffer() {
        try {
            ByteBuffer mapped = this.pageBuffer;
            this.pageBuffer = null;
            this.bufferType = -1;
            if (null != mapped) {
                Method getCleanerMethod = mapped.getClass().getMethod("cleaner", new Class[0]);
                getCleanerMethod.setAccessible(true);
                Cleaner cleaner = (Cleaner)getCleanerMethod.invoke((Object)mapped, new Object[0]);
                cleaner.clean();
            }
            this.bufferPool.releaseMMap(this);
        }
        catch (Exception e) {
            logger.warn("Release direct buffer exception: ", (Throwable)e);
        }
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    public boolean isFree() {
        return this.isClean();
    }

    @Override
    public boolean evict() {
        return this.unload();
    }

    @Override
    public void force() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
             FileChannel fileChannel = raf.getChannel();){
            fileChannel.force(true);
        }
    }
}

