/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.convert;

import java.util.Date;
import java.util.List;
import org.joyqueue.broker.monitor.converter.Converter;
import org.joyqueue.broker.monitor.converter.DefaultConverter;
import org.joyqueue.broker.monitor.stat.BrokerStatExt;
import org.joyqueue.model.MonitorRecord;
import org.joyqueue.monitor.StringResponse;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusConvert
implements Converter<BrokerStatExt, StringResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusConvert.class);
    private DefaultConverter converter = new DefaultConverter();

    public StringResponse convert(BrokerStatExt brokerStatExt) {
        List records = this.converter.convert(brokerStatExt);
        StringResponse response = this.buildResponse(records);
        long time = brokerStatExt.getTimeStamp();
        if (time <= 0L) {
            time = SystemClock.now() / 1000L;
        }
        response.addHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        response.addHeader("Date", new Date(time * 1000L).toString());
        response.addHeader("Transfer-Encoding", "chunked");
        logger.info("Report Prometheus Convert");
        return response;
    }

    private StringResponse buildResponse(List<MonitorRecord> records) {
        StringResponse response = new StringResponse();
        String body = this.buildPrometheusResult(records);
        response.setBody(body);
        return response;
    }

    private String buildPrometheusResult(List<MonitorRecord> records) {
        StringBuilder buffer = new StringBuilder();
        try {
            for (MonitorRecord mr : records) {
                buffer.append(mr.getMetric());
                buffer.append("{");
                for (int index = 1; index < 6; ++index) {
                    String tag = mr.getTag("t" + index);
                    if (tag == null || tag.length() <= 0) continue;
                    buffer.append("t" + index).append("=\"").append(tag).append("\"").append(",");
                }
                buffer.append("}");
                buffer.append(" ");
                buffer.append(mr.getValue() + "");
                buffer.append("\n");
            }
        }
        catch (Exception e) {
            logger.error("Convert metrics error!", (Throwable)e);
            return "\n";
        }
        return buffer.toString();
    }

    public String type() {
        return "prometheus";
    }
}

