/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.Namespace;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicName;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.model.AppTokenQuery;
import org.joyqueue.nsr.model.BrokerQuery;
import org.joyqueue.nsr.model.ConfigQuery;
import org.joyqueue.nsr.model.ConsumerQuery;
import org.joyqueue.nsr.model.DataCenterQuery;
import org.joyqueue.nsr.model.PartitionGroupQuery;
import org.joyqueue.nsr.model.ProducerQuery;
import org.joyqueue.nsr.model.ReplicaQuery;
import org.joyqueue.nsr.model.TopicQuery;
import org.joyqueue.nsr.service.AppTokenService;
import org.joyqueue.nsr.service.BrokerService;
import org.joyqueue.nsr.service.ConfigService;
import org.joyqueue.nsr.service.ConsumerService;
import org.joyqueue.nsr.service.DataCenterService;
import org.joyqueue.nsr.service.NamespaceService;
import org.joyqueue.nsr.service.PartitionGroupReplicaService;
import org.joyqueue.nsr.service.PartitionGroupService;
import org.joyqueue.nsr.service.ProducerService;
import org.joyqueue.nsr.service.TopicService;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageServer
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(ManageServer.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final String ENCODING = "utf-8";
    private HttpServer server;
    private Vertx vertx;
    private TopicService topicService;
    private ProducerService producerService;
    private ConsumerService consumerService;
    private BrokerService brokerService;
    private ConfigService configService;
    private DataCenterService dataCenterService;
    private AppTokenService appTokenService;
    private NamespaceService namespaceService;
    private PartitionGroupService partitionGroupService;
    private PartitionGroupReplicaService partitionGroupReplicaService;
    private int managerPort = 0;

    public ManageServer(TopicService topicService, ProducerService producerService, ConsumerService consumerService, BrokerService brokerService, ConfigService configService, AppTokenService appTokenService, DataCenterService dataCenterService, NamespaceService namespaceService, PartitionGroupService partitionGroupService, PartitionGroupReplicaService partitionGroupReplicaService) {
        this.topicService = topicService;
        this.producerService = producerService;
        this.consumerService = consumerService;
        this.brokerService = brokerService;
        this.configService = configService;
        this.appTokenService = appTokenService;
        this.dataCenterService = dataCenterService;
        this.namespaceService = namespaceService;
        this.partitionGroupService = partitionGroupService;
        this.partitionGroupReplicaService = partitionGroupReplicaService;
    }

    public void setManagerPort(int managerPort) {
        this.managerPort = managerPort;
    }

    public void doStart() throws Exception {
        this.vertx = Vertx.vertx();
        this.server = this.vertx.createHttpServer();
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)BodyHandler.create());
        router.post("/topic/getByCode").handler(routingContext -> {
            try {
                TopicQuery topicQuery = (TopicQuery)JSON.parseObject((String)routingContext.getBodyAsString(), TopicQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.topicService.getTopicByCode(topicQuery.getNamespace(), topicQuery.getCode())));
            }
            catch (Exception e) {
                logger.error("topic add errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/getById").handler(routingContext -> {
            try {
                String bodyTxt = routingContext.getBodyAsString();
                Topic topic = this.topicService.getById((String)JSON.parseObject((String)bodyTxt, String.class));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)topic));
            }
            catch (Exception e) {
                logger.error("topic add errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/findUnsubscribedByQuery").handler(routingContext -> {
            try {
                String bodyTxt = routingContext.getBodyAsString();
                PageResult<Topic> pageResult = this.topicService.findUnsubscribedByQuery((QPageQuery<TopicQuery>)((QPageQuery)JSON.parseObject((String)bodyTxt, (TypeReference)new TypeReference<QPageQuery<TopicQuery>>(){}, (Feature[])new Feature[0])));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(pageResult));
            }
            catch (Exception e) {
                logger.error("topic findByQuery errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/search").handler(routingContext -> {
            try {
                String bodyTxt = routingContext.getBodyAsString();
                PageResult<Topic> pageResult = this.topicService.search((QPageQuery<TopicQuery>)((QPageQuery)JSON.parseObject((String)bodyTxt, (TypeReference)new TypeReference<QPageQuery<TopicQuery>>(){}, (Feature[])new Feature[0])));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(pageResult));
            }
            catch (Exception e) {
                logger.error("topic findByQuery errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/add").handler(routingContext -> {
            try {
                String bodyTxt = routingContext.getBodyAsString();
                JSONObject json = JSONObject.parseObject((String)bodyTxt);
                Topic topic = (Topic)JSONObject.parseObject((String)json.getString("topic"), Topic.class);
                List list = JSONObject.parseArray((String)json.getString("partitionGroups"), PartitionGroup.class);
                this.topicService.addTopic(topic, list);
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("topic add errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/remove").handler(routingContext -> {
            try {
                this.topicService.removeTopic((Topic)JSONObject.parseObject((String)routingContext.getBodyAsString(), Topic.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("topic remove errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/update").handler(routingContext -> {
            try {
                this.topicService.update((Topic)JSONObject.parseObject((String)routingContext.getBodyAsString(), Topic.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("topic update errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/addPartitionGroup").handler(routingContext -> {
            try {
                this.topicService.addPartitionGroup((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("topic addPartitionGroup errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/removePartitionGroup").handler(routingContext -> {
            try {
                this.topicService.removePartitionGroup((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("topic removePartitionGroup errpr,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/updatePartitionGroup").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.topicService.updatePartitionGroup((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class))));
            }
            catch (Exception e) {
                logger.error("topic updatePartitionGroup error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/leaderChange").handler(routingContext -> {
            try {
                this.topicService.leaderChange((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end("success");
            }
            catch (Exception e) {
                logger.error("topic leaderChange error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/topic/getPartitionGroup").handler(routingContext -> {
            try {
                JSONObject json = JSONObject.parseObject((String)routingContext.getBodyAsString());
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.topicService.getPartitionGroup(json.getString("namespace"), json.getString("topic"), json.getJSONArray("groups").toArray())));
            }
            catch (Exception e) {
                logger.error("topic getPartitionGroup error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.producerService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("producer getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/add").handler(routingContext -> {
            try {
                this.producerService.add((Producer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Producer.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("producer add error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/update").handler(routingContext -> {
            try {
                this.producerService.update((Producer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Producer.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("producer update error,request", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/remove").handler(routingContext -> {
            try {
                this.producerService.delete(((Producer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Producer.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("producer remove error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/getByTopic").handler(routingContext -> {
            try {
                ProducerQuery producerQuery = (ProducerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ProducerQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.producerService.getByTopic(TopicName.parse((String)producerQuery.getTopic(), (String)producerQuery.getNamespace()))));
            }
            catch (Exception e) {
                logger.error("producer list error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/getByTopicAndApp").handler(routingContext -> {
            try {
                ProducerQuery producerQuery = (ProducerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ProducerQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString((Object)this.producerService.getByTopicAndApp(TopicName.parse((String)producerQuery.getTopic(), (String)producerQuery.getNamespace()), producerQuery.getApp())));
            }
            catch (Exception e) {
                logger.error("producer getlist error request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/producer/getByApp").handler(routingContext -> {
            try {
                ProducerQuery producerQuery = (ProducerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ProducerQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.producerService.getByApp(producerQuery.getApp())));
            }
            catch (Exception e) {
                logger.error("producer findByQuery error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/getById").handler(routingContext -> {
            try {
                Consumer consumer = this.consumerService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)consumer));
            }
            catch (Exception e) {
                logger.error("consumer getById error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/getByTopicAndApp").handler(routingContext -> {
            try {
                ConsumerQuery consumerQuery = (ConsumerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ConsumerQuery.class);
                Consumer consumer = this.consumerService.getByTopicAndApp(TopicName.parse((String)consumerQuery.getTopic(), (String)consumerQuery.getNamespace()), consumerQuery.getApp());
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)consumer));
            }
            catch (Exception e) {
                logger.error("consumer getByTopicAndApp error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/add").handler(routingContext -> {
            try {
                this.consumerService.add((Consumer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Consumer.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("consumer add error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/update").handler(routingContext -> {
            try {
                this.consumerService.update((Consumer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Consumer.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("consumer update error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/remove").handler(routingContext -> {
            try {
                this.consumerService.delete(((Consumer)JSONObject.parseObject((String)routingContext.getBodyAsString(), Consumer.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("consumer remove error,request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/getByTopic").handler(routingContext -> {
            try {
                ConsumerQuery consumerQuery = (ConsumerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ConsumerQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.consumerService.getByTopic(TopicName.parse((String)consumerQuery.getTopic(), (String)consumerQuery.getNamespace()))));
            }
            catch (Exception e) {
                logger.error("consumer getByTopic error request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/getByApp").handler(routingContext -> {
            try {
                ConsumerQuery consumerQuery = (ConsumerQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ConsumerQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.consumerService.getByApp(consumerQuery.getApp())));
            }
            catch (Exception e) {
                logger.error("consumer getByApp error request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/consumer/list").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.consumerService.getAll()));
            }
            catch (Exception e) {
                logger.error("consumer list error request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.configService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("config getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/getByGroupAndKey").handler(routingContext -> {
            try {
                ConfigQuery configQuery = (ConfigQuery)JSON.parseObject((String)routingContext.getBodyAsString(), ConfigQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.configService.getByGroupAndKey(configQuery.getGroup(), configQuery.getKey())));
            }
            catch (Exception e) {
                logger.error("config getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/add").handler(routingContext -> {
            try {
                this.configService.add((Config)JSONObject.parseObject((String)routingContext.getBodyAsString(), Config.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("config add error,requset[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/update").handler(routingContext -> {
            try {
                this.configService.update((Config)JSONObject.parseObject((String)routingContext.getBodyAsString(), Config.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("config update error request[{}]", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/remove").handler(routingContext -> {
            try {
                this.configService.delete(((Config)JSONObject.parseObject((String)routingContext.getBodyAsString(), Config.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("config remove [{}] error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/config/list").handler(routingContext -> {
            try {
                List<Config> configs = this.configService.getAll();
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(configs));
            }
            catch (Exception e) {
                logger.error("config config [{}] error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.brokerService.getById((Integer)JSON.parseObject((String)routingContext.getBodyAsString(), Integer.class))));
            }
            catch (Exception e) {
                logger.error("broker  getById error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/getByIds").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(this.brokerService.getByIds(JSON.parseArray((String)routingContext.getBodyAsString(), Integer.class))));
            }
            catch (Exception e) {
                logger.error("broker  getById error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/add").handler(routingContext -> {
            try {
                this.brokerService.add((Broker)JSONObject.parseObject((String)routingContext.getBodyAsString(), Broker.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("broker[{}] add error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/update").handler(routingContext -> {
            try {
                this.brokerService.update((Broker)JSONObject.parseObject((String)routingContext.getBodyAsString(), Broker.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("broker[{}] add error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/remove").handler(routingContext -> {
            try {
                this.brokerService.delete(((Broker)JSONObject.parseObject((String)routingContext.getBodyAsString(), Broker.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("broker[{}] remove error", (Object)routingContext.getBodyAsString(), (Object)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/list").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSONArray.toJSONString(this.brokerService.getAll()));
            }
            catch (Exception e) {
                logger.error("broker list error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/broker/search").handler(routingContext -> {
            try {
                QPageQuery pageQuery = (QPageQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), (TypeReference)new TypeReference<QPageQuery<BrokerQuery>>(){}, (Feature[])new Feature[0]);
                PageResult<Broker> pageResult = this.brokerService.search((QPageQuery<BrokerQuery>)pageQuery);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(pageResult));
            }
            catch (Exception e) {
                logger.error("broker findByQuery error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.appTokenService.getById((Long)JSON.parseObject((String)routingContext.getBodyAsString(), Long.class))));
            }
            catch (Exception e) {
                logger.error("apptoken getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/add").handler(routingContext -> {
            try {
                this.appTokenService.add((AppToken)JSONObject.parseObject((String)routingContext.getBodyAsString(), AppToken.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("apptoken add error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/update").handler(routingContext -> {
            try {
                this.appTokenService.update((AppToken)JSONObject.parseObject((String)routingContext.getBodyAsString(), AppToken.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("apptoken update error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/remove").handler(routingContext -> {
            try {
                this.appTokenService.delete(((AppToken)JSONObject.parseObject((String)routingContext.getBodyAsString(), AppToken.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("apptoken remove error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/findByApp").handler(routingContext -> {
            try {
                AppTokenQuery appTokenQuery = (AppTokenQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), AppTokenQuery.class);
                List<AppToken> appTokenList = this.appTokenService.getByApp(appTokenQuery.getApp());
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(appTokenList));
            }
            catch (Exception e) {
                logger.error("apptoken list error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/apptoken/findByAppAndToken").handler(routingContext -> {
            try {
                QPageQuery pageQuery = (QPageQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), (TypeReference)new TypeReference<QPageQuery<AppTokenQuery>>(){}, (Feature[])new Feature[0]);
                AppToken appToken = this.appTokenService.getByAppAndToken(((AppTokenQuery)pageQuery.getQuery()).getApp(), ((AppTokenQuery)pageQuery.getQuery()).getToken());
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)appToken));
            }
            catch (Exception e) {
                logger.error("apptoken findByQuery error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/datacenter/list").handler(routingContext -> {
            try {
                DataCenterQuery dataCenterQuery = (DataCenterQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), DataCenterQuery.class);
                List<DataCenter> dataCenters = this.dataCenterService.getAll();
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)ENCODING).end(JSON.toJSONString(dataCenters));
            }
            catch (Exception e) {
                logger.error("datacenter list error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/datacenter/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).putHeader(HttpHeaders.CONTENT_ENCODING, (CharSequence)ENCODING).end(JSON.toJSONString((Object)this.dataCenterService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("datacenter getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/datacenter/add").handler(routingContext -> {
            try {
                this.dataCenterService.add((DataCenter)JSONObject.parseObject((String)routingContext.getBodyAsString(), DataCenter.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("datacenter add error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/datacenter/update").handler(routingContext -> {
            try {
                this.dataCenterService.update((DataCenter)JSONObject.parseObject((String)routingContext.getBodyAsString(), DataCenter.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("datacenter update error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/datacenter/remove").handler(routingContext -> {
            try {
                this.dataCenterService.delete(((DataCenter)JSONObject.parseObject((String)routingContext.getBodyAsString(), DataCenter.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("datacenter remove error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/list").handler(routingContext -> {
            try {
                List<Namespace> namespaces = this.namespaceService.getAll();
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(namespaces));
            }
            catch (Exception e) {
                logger.error("namespace list error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/getByCode").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.namespaceService.getByCode((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("namespace getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.namespaceService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("namespace getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/add").handler(routingContext -> {
            try {
                this.namespaceService.add((Namespace)JSONObject.parseObject((String)routingContext.getBodyAsString(), Namespace.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("namespace add error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/update").handler(routingContext -> {
            try {
                this.namespaceService.update((Namespace)JSONObject.parseObject((String)routingContext.getBodyAsString(), Namespace.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("namespace update error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/namespace/remove").handler(routingContext -> {
            try {
                this.namespaceService.delete(((Namespace)JSONObject.parseObject((String)routingContext.getBodyAsString(), Namespace.class)).getCode());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("namespace remove error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.partitionGroupService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("partitiongroup getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/add").handler(routingContext -> {
            try {
                this.partitionGroupService.add((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("partitiongroup add error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/update").handler(routingContext -> {
            try {
                this.partitionGroupService.update((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("partitiongroup update error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/remove").handler(routingContext -> {
            try {
                this.partitionGroupService.delete(((PartitionGroup)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroup.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("partitiongroup remove error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/getByTopicAndGroup").handler(routingContext -> {
            try {
                PartitionGroupQuery query = (PartitionGroupQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroupQuery.class);
                PartitionGroup partitionGroup = this.partitionGroupService.getByTopicAndGroup(TopicName.parse((String)query.getTopic(), (String)query.getNamespace()), query.getGroup());
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)partitionGroup));
            }
            catch (Exception e) {
                logger.error("partitiongroup getByTopicAndGroup error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/partitiongroup/getByTopic").handler(routingContext -> {
            try {
                PartitionGroupQuery query = (PartitionGroupQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), PartitionGroupQuery.class);
                List<PartitionGroup> result = this.partitionGroupService.getByTopic(TopicName.parse((String)query.getTopic(), (String)query.getNamespace()));
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(result));
            }
            catch (Exception e) {
                logger.error("partitiongroup getByTopicAndGroup error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/getByBroker").handler(routingContext -> {
            try {
                ReplicaQuery replicaQuery = (ReplicaQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), ReplicaQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(this.partitionGroupReplicaService.getByBrokerId(replicaQuery.getBrokerId())));
            }
            catch (Exception e) {
                logger.error("replica getByBroker error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/getByTopic").handler(routingContext -> {
            try {
                ReplicaQuery replicaQuery = (ReplicaQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), ReplicaQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(this.partitionGroupReplicaService.getByTopic(TopicName.parse((String)replicaQuery.getTopic(), (String)replicaQuery.getNamespace()))));
            }
            catch (Exception e) {
                logger.error("replica getByTopic error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/getByTopicAndGroup").handler(routingContext -> {
            try {
                ReplicaQuery replicaQuery = (ReplicaQuery)JSONObject.parseObject((String)routingContext.getBodyAsString(), ReplicaQuery.class);
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString(this.partitionGroupReplicaService.getByTopicAndGroup(TopicName.parse((String)replicaQuery.getTopic(), (String)replicaQuery.getNamespace()), replicaQuery.getGroup())));
            }
            catch (Exception e) {
                logger.error("replica getByTopicAndGroup error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/getById").handler(routingContext -> {
            try {
                routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)APPLICATION_JSON).end(JSON.toJSONString((Object)this.partitionGroupReplicaService.getById((String)JSON.parseObject((String)routingContext.getBodyAsString(), String.class))));
            }
            catch (Exception e) {
                logger.error("replica getById error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/add").handler(routingContext -> {
            try {
                this.partitionGroupReplicaService.add((Replica)JSONObject.parseObject((String)routingContext.getBodyAsString(), Replica.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("replica add error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/update").handler(routingContext -> {
            try {
                this.partitionGroupReplicaService.update((Replica)JSONObject.parseObject((String)routingContext.getBodyAsString(), Replica.class));
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("replica update error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        router.post("/replica/remove").handler(routingContext -> {
            try {
                this.partitionGroupReplicaService.delete(((Replica)JSONObject.parseObject((String)routingContext.getBodyAsString(), Replica.class)).getId());
                routingContext.response().end("success");
            }
            catch (Exception e) {
                logger.error("replica remove error", (Throwable)e);
                routingContext.fail((Throwable)e);
            }
        });
        this.server.requestHandler(request -> router.accept(request)).listen(this.managerPort);
    }

    public void doStop() {
        if (this.server != null) {
            this.server.close();
        }
        if (this.vertx != null) {
            this.vertx.close();
        }
    }
}

