/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.service.AppTokenService;
import org.joyqueue.nsr.service.BrokerService;
import org.joyqueue.nsr.service.ConfigService;
import org.joyqueue.nsr.service.ConsumerService;
import org.joyqueue.nsr.service.DataCenterService;
import org.joyqueue.nsr.service.PartitionGroupReplicaService;
import org.joyqueue.nsr.service.PartitionGroupService;
import org.joyqueue.nsr.service.ProducerService;
import org.joyqueue.nsr.service.TopicService;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaManager
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(MetaManager.class);
    private TopicService topicService;
    private BrokerService brokerService;
    private ConsumerService consumerService;
    private ProducerService producerService;
    private PartitionGroupService partitionGroupService;
    private PartitionGroupReplicaService partitionGroupReplicaService;
    private ConfigService configService;
    private DataCenterService dataCenterService;
    private AppTokenService appTokenService;

    public MetaManager(ConfigService configService, TopicService topicService, BrokerService brokerService, ConsumerService consumerService, ProducerService producerService, PartitionGroupService partitionGroupService, PartitionGroupReplicaService partitionGroupReplicaService, AppTokenService appTokenService, DataCenterService dataCenterService) {
        Preconditions.checkArgument((topicService != null ? 1 : 0) != 0, (Object)"topic service can not be null");
        Preconditions.checkArgument((brokerService != null ? 1 : 0) != 0, (Object)"broker service can not be null");
        Preconditions.checkArgument((consumerService != null ? 1 : 0) != 0, (Object)"consumer service can not be null");
        Preconditions.checkArgument((producerService != null ? 1 : 0) != 0, (Object)"producer service can not be null");
        Preconditions.checkArgument((dataCenterService != null ? 1 : 0) != 0, (Object)"data center service can not be null");
        Preconditions.checkArgument((partitionGroupService != null ? 1 : 0) != 0, (Object)"partition group service can not be null");
        Preconditions.checkArgument((partitionGroupReplicaService != null ? 1 : 0) != 0, (Object)"partition group replica service can not be null");
        this.topicService = topicService;
        this.brokerService = brokerService;
        this.configService = configService;
        this.consumerService = consumerService;
        this.producerService = producerService;
        this.appTokenService = appTokenService;
        this.dataCenterService = dataCenterService;
        this.partitionGroupService = partitionGroupService;
        this.partitionGroupReplicaService = partitionGroupReplicaService;
    }

    protected void doStart() throws Exception {
        super.doStart();
        logger.info("metadata manager is started");
    }

    protected void doStop() {
        super.doStop();
        logger.info("metadata manager is stopped");
    }

    public Topic getTopicByName(TopicName topic) {
        return this.topicService.getById(topic.getFullName());
    }

    public Broker getBrokerById(Integer brokerId) {
        return this.brokerService.getById(brokerId);
    }

    public Broker getBrokerByIpAndPort(String brokerIp, Integer brokerPort) {
        return this.brokerService.getByIpAndPort(brokerIp, brokerPort);
    }

    public boolean addBroker(Broker broker) {
        this.brokerService.add(broker);
        return true;
    }

    public boolean updateBroker(Broker broker) {
        this.brokerService.update(broker);
        return true;
    }

    public Consumer addConsumer(Consumer consumer) {
        this.consumerService.add(consumer);
        return consumer;
    }

    public Producer addProducer(Producer producer) {
        this.producerService.add(producer);
        return producer;
    }

    public boolean removeConsumer(TopicName topic, String app) {
        Consumer consumer = new Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        this.consumerService.delete(consumer.getId());
        return true;
    }

    public boolean removeProducer(TopicName topic, String app) {
        Producer producer = new Producer();
        producer.setTopic(topic);
        producer.setApp(app);
        this.producerService.delete(producer.getId());
        return true;
    }

    public Producer getProducer(TopicName topic, String app) {
        return this.producerService.getByTopicAndApp(topic, app);
    }

    public List<Producer> getProducer(String app) {
        return this.producerService.getByApp(app);
    }

    public Consumer getConsumer(TopicName topic, String app) {
        return this.consumerService.getByTopicAndApp(topic, app);
    }

    public List<Consumer> getConsumer(String app) {
        return this.consumerService.getByApp(app);
    }

    public List<Consumer> getConsumerByTopic(TopicName topic) {
        return this.consumerService.getByTopic(topic);
    }

    public List<Producer> getProducerByTopic(TopicName topic) {
        return this.producerService.getByTopic(topic);
    }

    public List<PartitionGroup> getPartitionGroupByTopic(TopicName topic) {
        return this.partitionGroupService.getByTopic(topic);
    }

    public Set<TopicName> getTopicByBroker(Integer brokerId) {
        List<Replica> list = this.partitionGroupReplicaService.getByBrokerId(brokerId);
        HashSet<TopicName> topics = new HashSet<TopicName>();
        if (null != list && list.size() > 0) {
            list.forEach(replica -> topics.add(replica.getTopic()));
        }
        return topics;
    }

    public List<Replica> getReplicaByBroker(Integer brokerId) {
        return this.partitionGroupReplicaService.getByBrokerId(brokerId);
    }

    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        this.topicService.addTopic(topic, partitionGroups);
    }

    public AppToken findAppToken(String app, String token) {
        return this.appTokenService.getByAppAndToken(app, token);
    }

    public List<Broker> getAllBrokers() {
        return this.brokerService.getAll();
    }

    public Collection<DataCenter> getAllDataCenter() {
        return this.dataCenterService.getAll();
    }

    public DataCenter getDataCenter(String code) {
        return this.dataCenterService.getById(code);
    }

    public Config getConfig(String group, String key) {
        return this.configService.getByGroupAndKey(group, key);
    }

    public List<Config> getAllConfigs() {
        return this.configService.getAll();
    }

    public List<Topic> getAllTopics() {
        return this.topicService.getAll();
    }

    public List<PartitionGroup> getAllPartitionGroups() {
        return this.partitionGroupService.getAll();
    }

    public List<Consumer> getAllConsumers() {
        return this.consumerService.getAll();
    }

    public List<Producer> getAllProducers() {
        return this.producerService.getAll();
    }

    public List<AppToken> getAllAppToken() {
        return this.appTokenService.getAll();
    }

    public List<Broker> getBrokerByRetryType(String retryType) {
        return this.brokerService.getByRetryType(retryType);
    }

    public void leaderReport(PartitionGroup partitionGroup) {
        this.topicService.leaderReport(partitionGroup);
    }

    public TopicService getTopicService() {
        return this.topicService;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public ConsumerService getConsumerService() {
        return this.consumerService;
    }

    public ProducerService getProducerService() {
        return this.producerService;
    }

    public PartitionGroupService getPartitionGroupService() {
        return this.partitionGroupService;
    }

    public PartitionGroupReplicaService getPartitionGroupReplicaService() {
        return this.partitionGroupReplicaService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public AppTokenService getAppTokenService() {
        return this.appTokenService;
    }
}

