/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.config;

import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.helper.PortHelper;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.nsr.config.MessengerConfigKey;
import org.joyqueue.nsr.config.NameServerConfigKey;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class MessengerConfig {
    private ServerConfig serverConfig;
    private ClientConfig clientConfig;
    private PropertySupplier propertySupplier;

    public MessengerConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.serverConfig = TransportConfigSupport.buildServerConfig((PropertySupplier)propertySupplier, (String)"nameservice.messenger.server.");
        this.clientConfig = TransportConfigSupport.buildClientConfig((PropertySupplier)propertySupplier, (String)"nameservice.messenger.client.");
    }

    public int getSessionExpireTime() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.SESSION_EXPIRE_TIME);
    }

    public int getSessionTimeout() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.SESSION_TIMEOUT);
    }

    public int getPublishTimeout() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.PUBLISH_TIMEOUT);
    }

    public boolean getPublishEnable() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.PUBLISH_ENABLE);
    }

    public int getHandlerThreads() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.HANDLER_THREADS);
    }

    public int getHandlerQueues() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.HANDLER_QUEUES);
    }

    public int getHandlerKeepalive() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.HANDLER_KEEPALIVE);
    }

    public boolean getPublishForce() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.PUBLISH_FORCE);
    }

    public boolean getPublishIgnoreConnectionError() {
        return (Boolean)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.PUBLISH_IGNORE_CONNECTION_ERROR);
    }

    public int getHeartbeatTimeout() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.HEARTBEAT_TIMEOUT);
    }

    public int getHeartbeatInterval() {
        return (Integer)this.propertySupplier.getValue((PropertyDef)MessengerConfigKey.HEARTBEAT_INTERVAL);
    }

    public int getPort() {
        return PortHelper.getMessengerPort((int)((Integer)this.propertySupplier.getValue((PropertyDef)BrokerConfigKey.FRONTEND_SERVER_PORT)));
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getName() {
        return (String)this.propertySupplier.getValue((PropertyDef)NameServerConfigKey.NAMESERVICE_NAME);
    }
}

