/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.config;

import com.google.common.base.Preconditions;
import java.io.File;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.nsr.config.NameServiceConfigKey;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.io.Files;

public class NameServiceConfig {
    private ClientConfig clientConfig;
    private PropertySupplier propertySupplier;
    private String dataPath;

    public NameServiceConfig(PropertySupplier propertySupplier) {
        Preconditions.checkArgument((propertySupplier != null ? 1 : 0) != 0, (Object)"property supplier can not be null.");
        this.propertySupplier = propertySupplier;
        this.clientConfig = TransportConfigSupport.buildClientConfig((PropertySupplier)propertySupplier, (String)"nameservice.");
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getNameserverAddress() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ADDRESS);
    }

    public int getHandlerThreads() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_HANDLER_THREADS);
    }

    public int getHandlerQueues() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_HANDLER_QUEUES);
    }

    public int getHandlerKeepalive() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_HANDLER_KEEPALIVE);
    }

    public int getAllMetadataTransportTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_TRANSPORT_TIMEOUT);
    }

    public boolean getAllMetadataCacheEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_CACHE_ENABLE);
    }

    public String getAllMetadataCacheFile() {
        return this.getAndCreateDataPath() + PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_CACHE_FILE);
    }

    public int getAllMetadataCacheExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_CACHE_EXPIRE_TIME);
    }

    public int getAllMetadataInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_INTERVAL);
    }

    public boolean getAllMetadataRewriteEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_ALL_METADATA_REWRITE_ENABLE);
    }

    public boolean getCompensationEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_ENABLE);
    }

    public int getCompensationInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_INTERVAL);
    }

    public int getCompensationRetryTimes() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_RETRY_TIMES);
    }

    public int getCompensationRetryInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_RETRY_INTERVAL);
    }

    public boolean getCompensationTopicEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_TOPIC_ENABLE);
    }

    public boolean getCompensationBrokerEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_BROKER_ENABLE);
    }

    public boolean getCompensationProducerEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_PRODUCER_ENABLE);
    }

    public boolean getCompensationConsumerEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_CONSUMER_ENABLE);
    }

    public boolean getCompensationDataCenterEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_DATACENTER_ENABLE);
    }

    public boolean getCompensationConfigEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_CONFIG_ENABLE);
    }

    public boolean getCompensationEventEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_EVENT_ENABLE);
    }

    public boolean getCompensationCacheEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_CACHE_ENABLE);
    }

    public boolean getCompensationErrorCacheEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_ERROR_CACHE_ENABLE);
    }

    public int getCompensationErrorThreshold() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_ERROR_THRESHOLD);
    }

    public int getCompensationThreshold() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_THRESHOLD);
    }

    public int getCompensationErrorRetryInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_ERROR_RETRY_INTERVAL);
    }

    public String getMessengerType() {
        return (String)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_TYPE);
    }

    public boolean getMessengerIgniteEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_IGNITE_ENABLE);
    }

    public boolean getMessengerPublishLeaderChangeEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_PUBLISH_LEADER_CHANGE_ENABLE);
    }

    public boolean getMessengerPublishTopicEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_PUBLISH_TOPIC_ENABLE);
    }

    public boolean getMessengerPublishLeaderReportEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_PUBLISH_LEADER_REPORT_ENABLE);
    }

    public boolean getMessengerPublishSubscriptionEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_MESSENGER_PUBLISH_SUBSCRIPTION_ENABLE);
    }

    public boolean getMessengerPublishBrokerEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_COMPENSATION_BROKER_ENABLE);
    }

    public int getThinTransportTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_THIN_TRANSPORT_TIMEOUT);
    }

    public int getThinTransportTopicTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_THIN_TRANSPORT_TOPIC_TIMEOUT);
    }

    public boolean getThinCacheEnable() {
        return (Boolean)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_THIN_CACHE_ENABLE);
    }

    public int getThinCacheExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)NameServiceConfigKey.NAMESERVER_THIN_CACHE_EXPIRE_TIME);
    }

    public void setPropertySupplier(PropertySupplier propertySupplier) {
        if (propertySupplier != null) {
            this.propertySupplier = propertySupplier;
            this.clientConfig = TransportConfigSupport.buildClientConfig((PropertySupplier)propertySupplier, (String)"nameservice.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAndCreateDataPath() {
        if (this.dataPath != null) {
            return this.dataPath;
        }
        NameServiceConfig nameServiceConfig = this;
        synchronized (nameServiceConfig) {
            if (this.dataPath == null) {
                Property property = this.propertySupplier == null ? null : this.propertySupplier.getProperty("application.data.path");
                String path = property == null ? null : property.getString();
                File dataFile = path == null ? new File(new File(System.getProperty("user.home")), ".joyqueue") : new File(path);
                Files.createDirectory((File)dataFile);
                this.dataPath = dataFile.getPath();
            }
        }
        return this.dataPath;
    }
}

