/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.nsr.exception.MessengerException;
import org.joyqueue.nsr.message.MessageListener;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.message.support.network.command.MessengerPublishRequest;
import org.joyqueue.nsr.message.support.network.transport.MessengerTransportServerFactory;
import org.joyqueue.nsr.message.support.session.MessengerSessionManager;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessenger
extends Service
implements Messenger<MetaEvent>,
PropertySupplierAware {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMessenger.class);
    private final EventBus eventBus = new EventBus("joyqueue-messenger-eventBus");
    private MessengerConfig config;
    private MessengerSessionManager messengerSessionManager;
    private TransportServer messengerTransportServer;

    protected void validate() throws Exception {
        this.messengerSessionManager = new MessengerSessionManager(this.config);
    }

    protected void doStart() throws Exception {
        this.config.getServerConfig().setIoThread(1);
        this.config.getServerConfig().setPort(this.config.getPort());
        this.config.getServerConfig().setIoThreadName("joyqueue-messenger-io-eventLoop");
        this.config.getServerConfig().setAcceptThreadName("joyqueue-messenger-accept-eventLoop");
        this.messengerTransportServer = new MessengerTransportServerFactory(this.config, this.eventBus).bind(this.config.getServerConfig());
        this.messengerTransportServer.start();
        this.messengerSessionManager.start();
        this.eventBus.start();
    }

    protected void doStop() {
        this.messengerSessionManager.stop();
        this.messengerTransportServer.stop();
        this.eventBus.stop();
    }

    @Override
    public void publish(final MetaEvent event, List<Broker> brokers) {
        if (!this.config.getPublishEnable() || CollectionUtils.isEmpty(brokers)) {
            return;
        }
        final boolean[] success = new boolean[]{true};
        final CountDownLatch latch = new CountDownLatch(brokers.size());
        for (final Broker broker : brokers) {
            MessengerPublishRequest messengerPublishRequest = new MessengerPublishRequest(event);
            try {
                this.messengerSessionManager.getOrCreateSession(broker.getId(), broker.getIp(), broker.getMessengerPort()).async((Command)new JoyQueueCommand((JoyQueuePayload)messengerPublishRequest), this.config.getSessionTimeout(), new CommandCallback(){

                    public void onSuccess(Command request, Command response) {
                        BooleanAck booleanAck = (BooleanAck)response.getPayload();
                        if (booleanAck.getHeader().getStatus() != JoyQueueCode.SUCCESS.getCode()) {
                            logger.warn("messenger publish error, event: {}, id: {}, ip: {}, port: {}, code: {}", new Object[]{event, broker.getId(), broker.getIp(), broker.getMessengerPort(), booleanAck.type()});
                            success[0] = false;
                        }
                        latch.countDown();
                    }

                    public void onException(Command request, Throwable cause) {
                        logger.warn("messenger publish error, event: {}, id: {}, ip: {}, port: {}", new Object[]{event, broker.getId(), broker.getIp(), broker.getMessengerPort(), cause});
                        boolean isSuccess = false;
                        if (cause instanceof TransportException.RequestErrorException && DefaultMessenger.this.config.getPublishIgnoreConnectionError()) {
                            isSuccess = true;
                        }
                        success[0] = isSuccess;
                        latch.countDown();
                    }
                });
            }
            catch (Exception e) {
                if (!this.config.getPublishIgnoreConnectionError()) {
                    success[0] = false;
                    logger.warn("create session exception, event: {}, brokerId: {}, brokerIp: {}, brokerPort: {}", new Object[]{event, broker.getId(), broker.getIp(), broker.getMessengerPort(), e});
                }
                latch.countDown();
            }
        }
        try {
            if (!latch.await(this.config.getPublishTimeout(), TimeUnit.MILLISECONDS)) {
                logger.warn("messenger publish timeout, event: {}, brokers: {}, timeout: {}", new Object[]{event, brokers, this.config.getPublishTimeout()});
                if (!this.config.getPublishForce()) {
                    throw new MessengerException("messenger publish timeout");
                }
            }
        }
        catch (InterruptedException e) {
            throw new MessengerException("messenger publish exception", e);
        }
        if (!success[0] && !this.config.getPublishForce()) {
            logger.warn("messenger publish failed, event: {}, brokers: {}", (Object)event, brokers);
            throw new MessengerException("messenger publish failed");
        }
    }

    @Override
    public void publish(MetaEvent event, Broker ... brokers) {
        this.publish(event, (List<Broker>)Lists.newArrayList((Object[])brokers));
    }

    @Override
    public void fastPublish(MetaEvent event, List<Broker> brokers) {
        if (CollectionUtils.isEmpty(brokers)) {
            return;
        }
        for (Broker broker : brokers) {
            try {
                MessengerPublishRequest messengerPublishRequest = new MessengerPublishRequest(event);
                this.messengerSessionManager.getOrCreateSession(broker.getId(), broker.getIp(), broker.getMessengerPort()).oneway((Command)new JoyQueueCommand((JoyQueuePayload)messengerPublishRequest), this.config.getSessionTimeout());
            }
            catch (Exception e) {
                logger.warn("messenger fastPublish failed, event: {}, broker: {}", (Object)event, (Object)broker);
            }
        }
    }

    @Override
    public void fastPublish(MetaEvent event, Broker ... brokers) {
        this.fastPublish(event, (List<Broker>)Lists.newArrayList((Object[])brokers));
    }

    @Override
    public void addListener(MessageListener listener) {
        this.eventBus.addListener((EventListener)listener);
    }

    public void setSupplier(PropertySupplier supplier) {
        this.config = new MessengerConfig(supplier);
    }

    public String type() {
        return "default";
    }
}

