/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support.network.handler;

import com.alibaba.fastjson.JSON;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.provider.ExecutorServiceProvider;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.nsr.message.support.network.command.MessengerPublishRequest;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessengerPublishRequestHandler
implements CommandHandler,
Type,
ExecutorServiceProvider {
    protected static final Logger logger = LoggerFactory.getLogger(MessengerPublishRequestHandler.class);
    private MessengerConfig config;
    private EventBus eventBus;
    private ExecutorService threadPool;

    public MessengerPublishRequestHandler(MessengerConfig config, EventBus eventBus) {
        this.config = config;
        this.eventBus = eventBus;
        this.threadPool = new ThreadPoolExecutor(config.getHandlerThreads(), config.getHandlerThreads(), (long)config.getHandlerKeepalive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(config.getHandlerQueues()), (ThreadFactory)new NamedThreadFactory("joyqueue-messenger-handler"));
    }

    public Command handle(Transport transport, Command command) {
        MessengerPublishRequest payload = (MessengerPublishRequest)((Object)command.getPayload());
        MetaEvent event = payload.getEvent();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("onEvent, event: {}", (Object)JSON.toJSONString((Object)event));
            }
            this.eventBus.inform((Object)event);
            return BooleanAck.build();
        }
        catch (Exception e) {
            logger.error("messenger inform exception, event: {}", (Object)event, (Object)e);
            return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[0]);
        }
    }

    public ExecutorService getExecutorService(Transport transport, Command command) {
        return this.threadPool;
    }

    public int type() {
        return 50;
    }
}

