/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support.network.transport;

import org.joyqueue.network.codec.BooleanAckCodec;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.TransportServerFactory;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.codec.support.JoyQueueCodec;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.support.DefaultCommandHandlerFactory;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.support.DefaultTransportServerFactory;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.nsr.message.support.network.codec.MessengerHeartbeatRequestCodec;
import org.joyqueue.nsr.message.support.network.codec.MessengerPublishRequestCodec;
import org.joyqueue.nsr.message.support.network.handler.MessengerHeartbeatRequestHandler;
import org.joyqueue.nsr.message.support.network.handler.MessengerPublishRequestHandler;
import org.joyqueue.toolkit.concurrent.EventBus;

public class MessengerTransportServerFactory
implements TransportServerFactory {
    private TransportServerFactory transportServerFactory;
    private MessengerConfig config;
    private EventBus eventBus;

    public MessengerTransportServerFactory(MessengerConfig config, EventBus eventBus) {
        PayloadCodecFactory payloadCodecFactory = new PayloadCodecFactory();
        payloadCodecFactory.register((PayloadCodec)new MessengerPublishRequestCodec());
        payloadCodecFactory.register((PayloadCodec)new MessengerHeartbeatRequestCodec());
        payloadCodecFactory.register((PayloadCodec)new BooleanAckCodec());
        DefaultCommandHandlerFactory commandHandlerFactory = new DefaultCommandHandlerFactory();
        commandHandlerFactory.register((CommandHandler)new MessengerPublishRequestHandler(config, eventBus));
        commandHandlerFactory.register((CommandHandler)new MessengerHeartbeatRequestHandler());
        this.eventBus = eventBus;
        this.transportServerFactory = new DefaultTransportServerFactory((Codec)new JoyQueueCodec(payloadCodecFactory), (CommandHandlerFactory)commandHandlerFactory);
    }

    public TransportServer bind(ServerConfig serverConfig) {
        return this.transportServerFactory.bind(serverConfig);
    }

    public TransportServer bind(ServerConfig serverConfig, String host) {
        return this.transportServerFactory.bind(serverConfig, host);
    }

    public TransportServer bind(ServerConfig serverConfig, String host, int port) {
        return this.transportServerFactory.bind(serverConfig, host, port);
    }
}

