/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support.session;

import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.toolkit.service.Service;

public class MessengerSession
extends Service {
    private int brokerId;
    private String brokerHost;
    private int brokerPort;
    private MessengerConfig config;
    private Transport transport;

    public MessengerSession() {
    }

    public MessengerSession(int brokerId, String brokerHost, int brokerPort, MessengerConfig config, Transport transport) {
        this.brokerId = brokerId;
        this.brokerHost = brokerHost;
        this.brokerPort = brokerPort;
        this.config = config;
        this.transport = transport;
    }

    protected void doStop() {
        this.transport.stop();
    }

    public void oneway(Command command) throws TransportException {
        this.oneway(command, this.config.getSessionTimeout());
    }

    public void oneway(Command command, long timeout) throws TransportException {
        this.transport.oneway(command, timeout);
    }

    public Command sync(Command command) throws TransportException {
        return this.sync(command, this.config.getSessionTimeout());
    }

    public Command sync(Command command, int timeout) throws TransportException {
        return this.transport.sync(command, (long)timeout);
    }

    public void async(Command command, CommandCallback callback) throws TransportException {
        this.async(command, this.config.getSessionTimeout(), callback);
    }

    public void async(Command command, long timeout, CommandCallback callback) throws TransportException {
        this.transport.async(command, timeout, callback);
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public String getBrokerHost() {
        return this.brokerHost;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public String toString() {
        return "MessengerSession{brokerId=" + this.brokerId + ", brokerHost='" + this.brokerHost + '\'' + ", brokerPort=" + this.brokerPort + '}';
    }
}

