/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support.session;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.JoyQueueCommand;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.nsr.message.support.network.command.MessengerHeartbeatRequest;
import org.joyqueue.nsr.message.support.session.MessengerSession;
import org.joyqueue.nsr.message.support.session.MessengerSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessengerSessionHeartbeatThread
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(MessengerSessionHeartbeatThread.class);
    private MessengerConfig config;
    private MessengerSessionManager messengerSessionManager;

    public MessengerSessionHeartbeatThread(MessengerConfig config, MessengerSessionManager messengerSessionManager) {
        this.config = config;
        this.messengerSessionManager = messengerSessionManager;
    }

    @Override
    public void run() {
        ArrayList sessions = Lists.newArrayList(this.messengerSessionManager.getSessions().values());
        for (MessengerSession session : sessions) {
            try {
                session.sync((Command)new JoyQueueCommand((JoyQueuePayload)new MessengerHeartbeatRequest()), this.config.getHeartbeatTimeout());
            }
            catch (Exception e) {
                logger.warn("heartbeat exception, session: {}", (Object)session, (Object)e);
            }
        }
    }
}

