/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.message.support.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.domain.Broker;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.MessengerConfig;
import org.joyqueue.nsr.message.support.network.transport.MessengerTransportClientFactory;
import org.joyqueue.nsr.message.support.session.MessengerSession;
import org.joyqueue.nsr.message.support.session.MessengerSessionHeartbeatThread;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessengerSessionManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(MessengerSessionManager.class);
    private MessengerConfig config;
    private TransportClient client;
    private Cache<Integer, MessengerSession> sessions;
    private ScheduledExecutorService heartbeatThreadPool;

    public MessengerSessionManager(MessengerConfig config) {
        this.config = config;
    }

    protected void validate() throws Exception {
        this.client = new MessengerTransportClientFactory().create(this.config.getClientConfig());
        this.sessions = CacheBuilder.newBuilder().expireAfterAccess((long)this.config.getSessionExpireTime(), TimeUnit.MILLISECONDS).removalListener(notification -> {
            try {
                MessengerSession session = (MessengerSession)((Object)((Object)notification.getValue()));
                logger.info("create session, id: {}, ip: {}, port: {}", new Object[]{session.getBrokerId(), session.getBrokerHost(), session.getBrokerHost()});
                session.stop();
            }
            catch (Exception e) {
                logger.error("stop session exception, id: {}", notification.getKey(), (Object)e);
            }
        }).build();
    }

    public void doStop() {
        if (this.heartbeatThreadPool != null) {
            this.heartbeatThreadPool.shutdown();
        }
        if (this.client != null) {
            this.client.stop();
        }
        if (this.sessions != null) {
            this.sessions.cleanUp();
        }
    }

    public MessengerSession getSession(Broker broker) {
        return this.getSession(broker.getId());
    }

    public MessengerSession getSession(int brokerId) {
        return (MessengerSession)((Object)this.sessions.getIfPresent((Object)brokerId));
    }

    public MessengerSession getOrCreateSession(Broker broker) {
        return this.getOrCreateSession(broker.getId(), broker.getIp(), broker.getBackEndPort());
    }

    public MessengerSession getOrCreateSession(int brokerId, String brokerHost, int brokerPort) throws TransportException {
        this.maybeInitHeartbeat();
        try {
            return (MessengerSession)((Object)this.sessions.get((Object)brokerId, () -> {
                Transport transport = this.client.createTransport((SocketAddress)new InetSocketAddress(brokerHost, brokerPort));
                logger.info("create session, id: {}, ip: {}, port: {}", new Object[]{brokerId, brokerHost, brokerPort});
                return new MessengerSession(brokerId, brokerHost, brokerPort, this.config, transport);
            }));
        }
        catch (ExecutionException e) {
            throw new TransportException.ConnectionException(String.format("create session failed, broker: {id: %s, ip: %s, port: %s}", brokerId, brokerHost, brokerPort), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeInitHeartbeat() {
        if (this.heartbeatThreadPool != null) {
            return;
        }
        MessengerSessionManager messengerSessionManager = this;
        synchronized (messengerSessionManager) {
            if (this.heartbeatThreadPool != null) {
                return;
            }
            this.heartbeatThreadPool = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("joyqueue-messenger-heartbeat"));
            this.heartbeatThreadPool.scheduleWithFixedDelay(new MessengerSessionHeartbeatThread(this.config, this), this.config.getHeartbeatInterval(), this.config.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
        }
    }

    public ConcurrentMap<Integer, MessengerSession> getSessions() {
        return this.sessions.asMap();
    }
}

