/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.nameservice.MetadataCacheManager;
import org.joyqueue.nsr.nameservice.MetadataCompensator;
import org.joyqueue.nsr.nameservice.NameServiceCacheEventListener;
import org.joyqueue.nsr.nameservice.NameServiceCompensateThread;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensatedNameService
extends Service
implements NameService,
PropertySupplierAware {
    protected static final Logger logger = LoggerFactory.getLogger(CompensatedNameService.class);
    private final EventBus<NameServerEvent> eventBus = new EventBus("joyqueue-compensated-nameservice-eventBus");
    private final ExtensionPoint<Messenger, String> serviceProviderPoint = new ExtensionPointLazy(Messenger.class);
    private NameServiceConfig config;
    private NameService delegate;
    private PropertySupplier supplier;
    private Messenger messenger;
    private MetadataCacheManager metadataCacheManager;
    private MetadataCompensator metadataCompensator;
    private NameServiceCompensateThread nameServiceCompensateThread;
    private int brokerId;
    private AtomicLong nameserverLastAvailableTime = new AtomicLong();
    private AtomicInteger nameserverNotAvailableCounter = new AtomicInteger(0);

    public CompensatedNameService(NameService delegate) {
        this.delegate = delegate;
    }

    public void setSupplier(PropertySupplier supplier) {
        this.supplier = supplier;
        this.config = new NameServiceConfig(supplier);
        this.messenger = (Messenger)this.serviceProviderPoint.get((Object)this.config.getMessengerType());
        this.metadataCacheManager = new MetadataCacheManager(this.config);
        this.metadataCompensator = new MetadataCompensator(this.config, this.eventBus);
        this.nameServiceCompensateThread = new NameServiceCompensateThread(this.config, this.delegate, this.metadataCacheManager, this.metadataCompensator);
        try {
            this.enrichIfNecessary(this.messenger);
            this.delegate.start();
            this.eventBus.start();
            this.metadataCacheManager.start();
            this.metadataCompensator.start();
            this.nameServiceCompensateThread.doCompensate();
        }
        catch (Exception e) {
            throw new NsrException(e);
        }
    }

    protected void doStart() throws Exception {
        try {
            this.nameServiceCompensateThread.start();
        }
        catch (Exception e) {
            throw new NsrException(e);
        }
        this.messenger.addListener(new NameServiceCacheEventListener(this.config, this.eventBus, this.metadataCacheManager));
    }

    protected void doStop() {
        this.nameServiceCompensateThread.stop();
        this.metadataCompensator.stop();
        this.metadataCacheManager.stop();
        this.delegate.stop();
        this.messenger.stop();
    }

    protected <T> T enrichIfNecessary(T obj) throws Exception {
        if (obj instanceof LifeCycle && ((LifeCycle)obj).isStarted()) {
            return obj;
        }
        if (obj instanceof PropertySupplierAware) {
            ((PropertySupplierAware)obj).setSupplier(this.supplier);
        }
        if (obj instanceof LifeCycle) {
            ((LifeCycle)obj).start();
        }
        return obj;
    }

    @Override
    public TopicConfig subscribe(Subscription subscription, ClientType clientType) {
        return this.delegate.subscribe(subscription, clientType);
    }

    @Override
    public List<TopicConfig> subscribe(List<Subscription> subscriptions, ClientType clientType) {
        return this.delegate.subscribe(subscriptions, clientType);
    }

    @Override
    public void unSubscribe(Subscription subscription) {
        this.delegate.unSubscribe(subscription);
    }

    @Override
    public void unSubscribe(List<Subscription> subscriptions) {
        this.delegate.unSubscribe(subscriptions);
    }

    @Override
    public boolean hasSubscribe(String app, Subscription.Type subscribe) {
        if (this.config.getCompensationEnable()) {
            return this.hasSubscribeByCache(app, subscribe);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.hasSubscribeByCache(app, subscribe);
        }
        try {
            boolean result = this.delegate.hasSubscribe(app, subscribe);
            this.setNameserverAvailable();
            return result;
        }
        catch (Exception e) {
            logger.error("hasSubscribe exception, app: {}, subscribe: {}", new Object[]{app, subscribe, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.hasSubscribeByCache(app, subscribe);
            }
            throw new NsrException(e);
        }
    }

    protected boolean hasSubscribeByCache(String app, Subscription.Type subscribe) {
        switch (subscribe) {
            case CONSUMPTION: {
                return MapUtils.isNotEmpty(this.metadataCacheManager.getConsumerByApp(app));
            }
            case PRODUCTION: {
                return MapUtils.isNotEmpty(this.metadataCacheManager.getProducerByApp(app));
            }
        }
        return false;
    }

    @Override
    public void leaderReport(TopicName topic, int partitionGroup, int leaderBrokerId, Set<Integer> isrId, int termId) {
        this.delegate.leaderReport(topic, partitionGroup, leaderBrokerId, isrId, termId);
    }

    @Override
    public Broker getBroker(int brokerId) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getBroker(brokerId);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getBroker(brokerId);
        }
        try {
            Broker broker = this.delegate.getBroker(brokerId);
            this.setNameserverAvailable();
            return broker;
        }
        catch (Exception e) {
            logger.error("gerBroker exception, brokerId: {}", (Object)brokerId, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getBroker(brokerId);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Broker> getAllBrokers() {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getAllBrokers();
        }
        try {
            List<Broker> allBrokers = this.delegate.getAllBrokers();
            this.setNameserverAvailable();
            return allBrokers;
        }
        catch (Exception e) {
            logger.error("getAllBrokers exception", (Throwable)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getAllBrokers();
            }
            throw new NsrException(e);
        }
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        this.delegate.addTopic(topic, partitionGroups);
    }

    @Override
    public TopicConfig getTopicConfig(TopicName topic) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getTopicConfig(topic);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getTopicConfig(topic);
        }
        try {
            TopicConfig topicConfig = this.delegate.getTopicConfig(topic);
            this.setNameserverAvailable();
            return topicConfig;
        }
        catch (Exception e) {
            logger.error("getTopicConfig exception, topic: {}", (Object)topic, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getTopicConfig(topic);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Set<String> getAllTopicCodes() {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getAllTopicCodes();
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getAllTopicCodes();
        }
        try {
            Set<String> allTopicCodes = this.delegate.getAllTopicCodes();
            this.setNameserverAvailable();
            return allTopicCodes;
        }
        catch (Exception e) {
            logger.error("getAllTopicCodes exception", (Throwable)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getAllTopicCodes();
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Set<String> getTopics(String app, Subscription.Type subscription) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getTopics(app, subscription);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getTopics(app, subscription);
        }
        try {
            Set<String> topics = this.delegate.getTopics(app, subscription);
            this.setNameserverAvailable();
            return topics;
        }
        catch (Exception e) {
            logger.error("getTopics exception, app: {}, subscription: {}", new Object[]{app, subscription, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getTopics(app, subscription);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getTopicConfigByBroker(brokerId);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getTopicConfigByBroker(brokerId);
        }
        try {
            Map<TopicName, TopicConfig> topicConfigByBroker = this.delegate.getTopicConfigByBroker(brokerId);
            this.setNameserverAvailable();
            return topicConfigByBroker;
        }
        catch (Exception e) {
            logger.error("getTopicConfigByBroker exception, brokerId: {}", (Object)brokerId, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getTopicConfigByBroker(brokerId);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Broker register(Integer brokerId, String brokerIp, Integer port) {
        Broker broker = this.delegate.register(brokerId, brokerIp, port);
        if (broker != null) {
            this.brokerId = broker.getId();
            this.metadataCompensator.setBrokerId(this.brokerId);
        }
        return broker;
    }

    @Override
    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getProducerByTopicAndApp(topic, app);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getProducerByTopicAndApp(topic, app);
        }
        try {
            Producer producerByTopicAndApp = this.delegate.getProducerByTopicAndApp(topic, app);
            this.setNameserverAvailable();
            return producerByTopicAndApp;
        }
        catch (Exception e) {
            logger.error("getProducerByTopicAndApp exception, topic: {}, app: {}", new Object[]{topic, app, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getProducerByTopicAndApp(topic, app);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getConsumerByTopicAndApp(topic, app);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getConsumerByTopicAndApp(topic, app);
        }
        try {
            Consumer consumerByTopicAndApp = this.delegate.getConsumerByTopicAndApp(topic, app);
            this.setNameserverAvailable();
            return consumerByTopicAndApp;
        }
        catch (Exception e) {
            logger.error("getConsumerByTopicAndApp exception, topic: {}, app: {}", new Object[]{topic, app, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getConsumerByTopicAndApp(topic, app);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByApp(String subscribeApp, Subscription.Type subscribe) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getTopicConfigByApp(subscribeApp, subscribe);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getTopicConfigByApp(subscribeApp, subscribe);
        }
        try {
            Map<TopicName, TopicConfig> topicConfigByApp = this.delegate.getTopicConfigByApp(subscribeApp, subscribe);
            this.setNameserverAvailable();
            return topicConfigByApp;
        }
        catch (Exception e) {
            logger.error("getTopicConfigByApp exception, subscribeApp: {}, subscribe: {}", new Object[]{subscribeApp, subscribe, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getTopicConfigByApp(subscribeApp, subscribe);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public DataCenter getDataCenter(String ip) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getDataCenter(ip);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getDataCenter(ip);
        }
        try {
            DataCenter dataCenter = this.delegate.getDataCenter(ip);
            this.setNameserverAvailable();
            return dataCenter;
        }
        catch (Exception e) {
            logger.error("getDataCenter exception, ip: {}", (Object)ip, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getDataCenter(ip);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public String getConfig(String group, String key) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getConfig(group, key);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getConfig(group, key);
        }
        try {
            String config = this.delegate.getConfig(group, key);
            this.setNameserverAvailable();
            return config;
        }
        catch (Exception e) {
            logger.error("getConfig exception, group: {}, key: {}", new Object[]{group, key, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getConfig(group, key);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Config> getAllConfigs() {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getAllConfigs();
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getAllConfigs();
        }
        try {
            List<Config> allConfigs = this.delegate.getAllConfigs();
            this.setNameserverAvailable();
            return allConfigs;
        }
        catch (Exception e) {
            logger.error("getAllConfigs exception", (Throwable)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getAllConfigs();
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Broker> getBrokerByRetryType(String retryType) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getBrokerByRetryType(retryType);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getBrokerByRetryType(retryType);
        }
        try {
            List<Broker> brokerByRetryType = this.delegate.getBrokerByRetryType(retryType);
            this.setNameserverAvailable();
            return brokerByRetryType;
        }
        catch (Exception e) {
            logger.error("getBrokerByRetryType exception, retryType: {}", (Object)retryType, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getBrokerByRetryType(retryType);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Consumer> getConsumerByTopic(TopicName topic) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getConsumerByTopic(topic);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getConsumerByTopic(topic);
        }
        try {
            List<Consumer> consumerByTopic = this.delegate.getConsumerByTopic(topic);
            this.setNameserverAvailable();
            return consumerByTopic;
        }
        catch (Exception e) {
            logger.error("getConsumerByTopic exception, topic: {}", (Object)topic, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getConsumerByTopic(topic);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Producer> getProducerByTopic(TopicName topic) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getProducerByTopic(topic);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getProducerByTopic(topic);
        }
        try {
            List<Producer> producerByTopic = this.delegate.getProducerByTopic(topic);
            this.setNameserverAvailable();
            return producerByTopic;
        }
        catch (Exception e) {
            logger.error("getProducerByTopic exception, topic: {}", (Object)topic, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getProducerByTopic(topic);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public List<Replica> getReplicaByBroker(Integer brokerId) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getReplicaByBroker(brokerId);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getReplicaByBroker(brokerId);
        }
        try {
            List<Replica> replicaByBroker = this.delegate.getReplicaByBroker(brokerId);
            this.setNameserverAvailable();
            return replicaByBroker;
        }
        catch (Exception e) {
            logger.error("getReplicaByBroker exception, brokerId: {}", (Object)brokerId, (Object)e);
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getReplicaByBroker(brokerId);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public AppToken getAppToken(String app, String token) {
        if (this.config.getCompensationCacheEnable()) {
            return this.metadataCacheManager.getAppToken(app, token);
        }
        if (this.config.getCompensationErrorCacheEnable() && !this.nameserverIsAvailable()) {
            return this.metadataCacheManager.getAppToken(app, token);
        }
        try {
            AppToken appToken = this.delegate.getAppToken(app, token);
            this.setNameserverAvailable();
            return appToken;
        }
        catch (Exception e) {
            logger.error("getAppToken exception, app: {}, token: {}", new Object[]{app, token, e});
            this.setNameserverNotAvailable();
            if (this.config.getCompensationErrorCacheEnable()) {
                return this.metadataCacheManager.getAppToken(app, token);
            }
            throw new NsrException(e);
        }
    }

    @Override
    public AllMetadata getAllMetadata() {
        return this.delegate.getAllMetadata();
    }

    @Override
    public void addListener(EventListener<NameServerEvent> listener) {
        this.eventBus.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<NameServerEvent> listener) {
        this.eventBus.removeListener(listener);
    }

    @Override
    public void addEvent(NameServerEvent event) {
        this.eventBus.add((Object)event);
    }

    protected boolean nameserverIsAvailable() {
        boolean result;
        long now = SystemClock.now();
        long nameserverLastAvailableTime = this.nameserverLastAvailableTime.get();
        boolean bl = result = nameserverLastAvailableTime == 0L || this.config.getCompensationErrorThreshold() > this.nameserverNotAvailableCounter.get();
        if (!result) {
            if (now - nameserverLastAvailableTime < (long)this.config.getCompensationErrorRetryInterval()) {
                return false;
            }
            if (this.nameserverLastAvailableTime.compareAndSet(nameserverLastAvailableTime, now)) {
                this.nameserverNotAvailableCounter.set(0);
                return true;
            }
        }
        return result;
    }

    protected void setNameserverNotAvailable() {
        this.nameserverNotAvailableCounter.incrementAndGet();
    }

    protected void setNameserverAvailable() {
        this.nameserverLastAvailableTime.set(SystemClock.now());
        this.nameserverNotAvailableCounter.set(0);
    }

    public NameService getDelegate() {
        return this.delegate;
    }
}

