/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.joyqueue.nsr.nameservice.NameServiceCacheDoubleCopy;
import org.joyqueue.nsr.util.DCWrapper;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCacheManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataCacheManager.class);
    private NameServiceConfig config;
    private NameServiceCacheDoubleCopy nameServiceCacheDoubleCopy;
    private volatile AllMetadataCache cache;
    private ReentrantLock lock = new ReentrantLock();
    private volatile long timestamp = 0L;

    public MetadataCacheManager(NameServiceConfig config) {
        this.config = config;
    }

    protected void validate() throws Exception {
        this.nameServiceCacheDoubleCopy = new NameServiceCacheDoubleCopy(new File(this.config.getAllMetadataCacheFile()));
    }

    protected void doStart() throws Exception {
        this.nameServiceCacheDoubleCopy.recover();
        this.cache = this.nameServiceCacheDoubleCopy.getCache();
    }

    public AllMetadataCache buildCache(AllMetadata allMetadata) {
        HashMap brokerMap = Maps.newHashMap((Map)allMetadata.getBrokers());
        HashMap topicConfigMap = Maps.newHashMap((Map)allMetadata.getTopics());
        LinkedList allProducers = Lists.newLinkedList((Iterable)allMetadata.getProducers());
        LinkedList allConsumers = Lists.newLinkedList((Iterable)allMetadata.getConsumers());
        LinkedList allDataCenters = Lists.newLinkedList((Iterable)allMetadata.getDataCenters());
        LinkedList allConfigs = Lists.newLinkedList((Iterable)allMetadata.getConfigs());
        LinkedList allAppTokens = Lists.newLinkedList((Iterable)allMetadata.getAppTokens());
        LinkedList allBrokers = Lists.newLinkedList();
        LinkedList allTopicConfigs = Lists.newLinkedList();
        LinkedList allTopicCodes = Lists.newLinkedList();
        HashMap topicConfigBrokerMap = Maps.newHashMapWithExpectedSize((int)brokerMap.size());
        HashMap producerTopicMap = Maps.newHashMapWithExpectedSize((int)allTopicConfigs.size());
        HashMap consumerTopicMap = Maps.newHashMapWithExpectedSize((int)allTopicConfigs.size());
        HashMap producerAppMap = Maps.newHashMapWithExpectedSize((int)allTopicConfigs.size());
        HashMap consumerAppMap = Maps.newHashMapWithExpectedSize((int)allTopicConfigs.size());
        HashMap allAppTokenMap = Maps.newHashMapWithExpectedSize((int)brokerMap.size());
        LinkedList allDataCenterWrappers = Lists.newLinkedList();
        HashMap configKeyMap = Maps.newHashMapWithExpectedSize((int)allConfigs.size());
        HashMap dataCenterWrapperCodeMap = Maps.newHashMapWithExpectedSize((int)allDataCenterWrappers.size());
        for (Map.Entry topicEntry : topicConfigMap.entrySet()) {
            TopicName topicName = (TopicName)topicEntry.getKey();
            TopicConfig topicConfig = (TopicConfig)topicEntry.getValue();
            allTopicConfigs.add(topicConfig);
            allTopicCodes.add(topicName.getFullName());
            for (Map.Entry partitionGroupEntry : topicConfig.getPartitionGroups().entrySet()) {
                PartitionGroup partitionGroup = (PartitionGroup)partitionGroupEntry.getValue();
                HashMap partitionGroupBrokerMap = Maps.newHashMap();
                partitionGroup.setBrokers((Map)partitionGroupBrokerMap);
                for (Integer replica : partitionGroup.getReplicas()) {
                    Map brokerTopicConfigMap;
                    Broker partitionGroupBroker = (Broker)brokerMap.get(replica);
                    if (partitionGroupBroker != null) {
                        partitionGroupBrokerMap.put(replica, partitionGroupBroker);
                    }
                    if ((brokerTopicConfigMap = (Map)topicConfigBrokerMap.get(replica)) == null) {
                        brokerTopicConfigMap = Maps.newHashMap();
                        topicConfigBrokerMap.put(replica, brokerTopicConfigMap);
                    }
                    brokerTopicConfigMap.put(topicName, topicConfig);
                }
            }
        }
        for (Map.Entry brokerEntry : brokerMap.entrySet()) {
            Broker broker = (Broker)brokerEntry.getValue();
            allBrokers.add(broker);
        }
        for (Producer producer : allProducers) {
            Map appProducerMap = (Map)producerTopicMap.get(producer.getTopic());
            if (appProducerMap == null) {
                appProducerMap = Maps.newHashMap();
                producerTopicMap.put(producer.getTopic(), appProducerMap);
            }
            appProducerMap.put(producer.getApp(), producer);
            Map topicProducerMap = (Map)producerAppMap.get(producer.getApp());
            if (topicProducerMap == null) {
                topicProducerMap = Maps.newHashMap();
                producerAppMap.put(producer.getApp(), topicProducerMap);
            }
            topicProducerMap.put(producer.getTopic(), producer);
        }
        for (Consumer consumer : allConsumers) {
            Map appConsumerMap = (Map)consumerTopicMap.get(consumer.getTopic());
            if (appConsumerMap == null) {
                appConsumerMap = Maps.newHashMap();
                consumerTopicMap.put(consumer.getTopic(), appConsumerMap);
            }
            appConsumerMap.put(consumer.getApp(), consumer);
            Map topicConsumerMap = (Map)consumerAppMap.get(consumer.getApp());
            if (topicConsumerMap == null) {
                topicConsumerMap = Maps.newHashMap();
                consumerAppMap.put(consumer.getApp(), topicConsumerMap);
            }
            topicConsumerMap.put(consumer.getTopic(), consumer);
        }
        for (AppToken appToken : allAppTokens) {
            List appTokens = (List)allAppTokenMap.get(appToken.getApp());
            if (appTokens == null) {
                appTokens = Lists.newLinkedList();
                allAppTokenMap.put(appToken.getApp(), appTokens);
            }
            appTokens.add(appToken);
        }
        for (Config config : allConfigs) {
            configKeyMap.put(config.getId(), config);
        }
        for (DataCenter dataCenter : allDataCenters) {
            DCWrapper dcWrapper = new DCWrapper(dataCenter);
            allDataCenterWrappers.add(dcWrapper);
            dataCenterWrapperCodeMap.put(dataCenter.getCode(), dcWrapper);
        }
        AllMetadataCache cache = new AllMetadataCache();
        cache.setAllBrokers(allBrokers);
        cache.setBrokerMap(brokerMap);
        cache.setTopicConfigMap(topicConfigMap);
        cache.setAllTopicConfigs(allTopicConfigs);
        cache.setAllTopicCodes(allTopicCodes);
        cache.setTopicConfigBrokerMap(topicConfigBrokerMap);
        cache.setProducerTopicMap(producerTopicMap);
        cache.setProducerAppMap(producerAppMap);
        cache.setAllProducers(allProducers);
        cache.setConsumerTopicMap(consumerTopicMap);
        cache.setConsumerAppMap(consumerAppMap);
        cache.setAllConsumers(allConsumers);
        cache.setAllConfigs(allConfigs);
        cache.setConfigKeyMap(configKeyMap);
        cache.setAllAppTokenMap(allAppTokenMap);
        cache.setAllDataCenters(allDataCenterWrappers);
        cache.setDataCenterCodeMap(dataCenterWrapperCodeMap);
        return cache;
    }

    public void fillCache(AllMetadataCache cache) {
        this.cache = cache;
    }

    public void flushCache() {
        this.nameServiceCacheDoubleCopy.flush(this.cache);
    }

    public Broker getBroker(int brokerId) {
        this.checkCacheStatus();
        return this.cache.getBrokerMap().get(brokerId);
    }

    public List<Broker> getAllBrokers() {
        this.checkCacheStatus();
        return this.cache.getAllBrokers();
    }

    public TopicConfig getTopicConfig(TopicName topic) {
        this.checkCacheStatus();
        return this.cache.getTopicConfigMap().get(topic);
    }

    public Set<String> getAllTopicCodes() {
        this.checkCacheStatus();
        return Sets.newHashSet(this.cache.getAllTopicCodes());
    }

    public Set<String> getTopics(String app, Subscription.Type subscription) {
        this.checkCacheStatus();
        if (Subscription.Type.PRODUCTION.equals((Object)subscription)) {
            Map<TopicName, Producer> producerMap = this.cache.getProducerAppMap().get(app);
            if (producerMap == null) {
                return Collections.emptySet();
            }
            HashSet result = Sets.newHashSet();
            for (Map.Entry<TopicName, Producer> entry : producerMap.entrySet()) {
                result.add(entry.getKey().getFullName());
            }
            return result;
        }
        if (Subscription.Type.CONSUMPTION.equals((Object)subscription)) {
            Map<TopicName, Consumer> consumerMap = this.cache.getConsumerAppMap().get(app);
            if (consumerMap == null) {
                return Collections.emptySet();
            }
            HashSet result = Sets.newHashSet();
            for (Map.Entry<TopicName, Consumer> entry : consumerMap.entrySet()) {
                result.add(entry.getKey().getFullName());
            }
            return result;
        }
        throw new UnsupportedOperationException(subscription.name());
    }

    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        this.checkCacheStatus();
        return (Map)ObjectUtils.defaultIfNull(this.cache.getTopicConfigBrokerMap().get(brokerId), Collections.emptyMap());
    }

    public Map<TopicName, Producer> getProducerByApp(String app) {
        return this.cache.getProducerAppMap().get(app);
    }

    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        this.checkCacheStatus();
        Map<String, Producer> producerMap = this.cache.getProducerTopicMap().get(topic);
        if (producerMap == null) {
            return null;
        }
        return producerMap.get(app);
    }

    public Map<TopicName, Consumer> getConsumerByApp(String app) {
        return this.cache.getConsumerAppMap().get(app);
    }

    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        this.checkCacheStatus();
        Map<String, Consumer> consumerMap = this.cache.getConsumerTopicMap().get(topic);
        if (consumerMap == null) {
            return null;
        }
        return consumerMap.get(app);
    }

    public Map<TopicName, TopicConfig> getTopicConfigByApp(String subscribeApp, Subscription.Type subscribe) {
        this.checkCacheStatus();
        if (Subscription.Type.PRODUCTION.equals((Object)subscribe)) {
            Map<TopicName, Producer> producerMap = this.cache.getProducerAppMap().get(subscribeApp);
            if (producerMap == null) {
                return Collections.emptyMap();
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)producerMap.size());
            for (Map.Entry<TopicName, Producer> entry : producerMap.entrySet()) {
                TopicName topicName = entry.getKey();
                TopicConfig topicConfig = this.cache.getTopicConfigMap().get(topicName);
                if (topicConfig == null) continue;
                result.put(topicName, topicConfig);
            }
            return result;
        }
        if (Subscription.Type.CONSUMPTION.equals((Object)subscribe)) {
            Map<TopicName, Consumer> consumerMap = this.cache.getConsumerAppMap().get(subscribeApp);
            if (consumerMap == null) {
                return Collections.emptyMap();
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)consumerMap.size());
            for (Map.Entry<TopicName, Consumer> entry : consumerMap.entrySet()) {
                TopicName topicName = entry.getKey();
                TopicConfig topicConfig = this.cache.getTopicConfigMap().get(topicName);
                if (topicConfig == null) continue;
                result.put(topicName, topicConfig);
            }
            return result;
        }
        throw new UnsupportedOperationException(subscribe.name());
    }

    public DataCenter getDataCenter(String ip) {
        this.checkCacheStatus();
        for (DCWrapper dataCenter : this.cache.getAllDataCenters()) {
            if (!dataCenter.match(ip)) continue;
            return dataCenter.getDataCenter();
        }
        return null;
    }

    public String getConfig(String group, String key) {
        this.checkCacheStatus();
        List<Config> configs = this.cache.getAllConfigs();
        for (Config config : configs) {
            if (!StringUtils.equals((CharSequence)config.getGroup(), (CharSequence)group) || !StringUtils.equals((CharSequence)config.getKey(), (CharSequence)key)) continue;
            return config.getValue();
        }
        return null;
    }

    public List<Config> getAllConfigs() {
        this.checkCacheStatus();
        return this.cache.getAllConfigs();
    }

    public List<Broker> getBrokerByRetryType(String retryType) {
        this.checkCacheStatus();
        LinkedList result = Lists.newLinkedList();
        for (Broker broker : this.cache.getAllBrokers()) {
            if (!StringUtils.equals((CharSequence)broker.getRetryType(), (CharSequence)retryType)) continue;
            result.add(broker);
        }
        return result;
    }

    public List<Consumer> getConsumerByTopic(TopicName topic) {
        this.checkCacheStatus();
        Map<String, Consumer> consumerMap = this.cache.getConsumerTopicMap().get(topic);
        if (consumerMap == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(consumerMap.values());
    }

    public List<Producer> getProducerByTopic(TopicName topic) {
        this.checkCacheStatus();
        Map<String, Producer> producerMap = this.cache.getProducerTopicMap().get(topic);
        if (producerMap == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(producerMap.values());
    }

    public List<Replica> getReplicaByBroker(Integer brokerId) {
        this.checkCacheStatus();
        Map<TopicName, TopicConfig> brokerTopicConfigMap = this.cache.getTopicConfigBrokerMap().get(brokerId);
        if (brokerTopicConfigMap == null) {
            return Collections.emptyList();
        }
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry<TopicName, TopicConfig> entry : brokerTopicConfigMap.entrySet()) {
            TopicConfig topicConfig = entry.getValue();
            for (Map.Entry partitionGroupEntry : topicConfig.getPartitionGroups().entrySet()) {
                PartitionGroup partitionGroup = (PartitionGroup)partitionGroupEntry.getValue();
                if (!partitionGroup.getReplicas().contains(brokerId)) continue;
                result.add(new Replica(String.valueOf(brokerId), topicConfig.getName(), partitionGroup.getGroup(), brokerId.intValue()));
            }
        }
        return result;
    }

    public AppToken getAppToken(String app, String token) {
        this.checkCacheStatus();
        List<AppToken> appTokens = this.cache.getAllAppTokenMap().get(app);
        if (appTokens == null) {
            return null;
        }
        for (AppToken appToken : appTokens) {
            if (!StringUtils.equals((CharSequence)appToken.getToken(), (CharSequence)token)) continue;
            return appToken;
        }
        return null;
    }

    protected void checkCacheStatus() {
        if (this.cache != null) {
            return;
        }
        throw new NsrException();
    }

    public AllMetadataCache getCache() {
        return this.cache;
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void updateTimestamp() {
        this.timestamp = SystemClock.now();
    }
}

