/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.AddBrokerEvent;
import org.joyqueue.nsr.event.AddConfigEvent;
import org.joyqueue.nsr.event.AddConsumerEvent;
import org.joyqueue.nsr.event.AddDataCenterEvent;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.AddProducerEvent;
import org.joyqueue.nsr.event.AddTopicEvent;
import org.joyqueue.nsr.event.CompensateEvent;
import org.joyqueue.nsr.event.RemoveBrokerEvent;
import org.joyqueue.nsr.event.RemoveConfigEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemoveDataCenterEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveProducerEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdateBrokerEvent;
import org.joyqueue.nsr.event.UpdateConfigEvent;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.nsr.event.UpdateDataCenterEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.nsr.event.UpdateProducerEvent;
import org.joyqueue.nsr.event.UpdateTopicEvent;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.joyqueue.nsr.util.DCWrapper;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCompensator
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataCompensator.class);
    private NameServiceConfig config;
    private EventBus<NameServerEvent> eventBus;
    private int brokerId = -1;

    public MetadataCompensator(NameServiceConfig config, EventBus<NameServerEvent> eventBus) {
        this.config = config;
        this.eventBus = eventBus;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public void compensate(AllMetadataCache oldCache, AllMetadataCache newCache) {
        if (this.brokerId <= 0) {
            return;
        }
        if (this.config.getCompensationBrokerEnable()) {
            this.compensateBroker(oldCache, newCache);
        }
        if (this.config.getCompensationTopicEnable()) {
            this.compensateTopic(oldCache, newCache);
        }
        if (this.config.getCompensationProducerEnable()) {
            this.compensateProducer(oldCache, newCache);
        }
        if (this.config.getCompensationConsumerEnable()) {
            this.compensateConsumer(oldCache, newCache);
        }
        if (this.config.getCompensationDataCenterEnable()) {
            this.compensateDataCenter(oldCache, newCache);
        }
        if (this.config.getCompensationConfigEnable()) {
            this.compensateConfig(oldCache, newCache);
        }
        if (this.config.getCompensationEventEnable()) {
            this.publishEvent(new CompensateEvent(oldCache, newCache));
        }
    }

    protected void compensateTopic(AllMetadataCache oldCache, AllMetadataCache newCache) {
        for (Map.Entry<TopicName, TopicConfig> currentTopicEntry : newCache.getTopicConfigMap().entrySet()) {
            TopicConfig newTopicConfig = currentTopicEntry.getValue();
            TopicConfig oldTopicConfig = oldCache.getTopicConfigMap().get(currentTopicEntry.getKey());
            if (oldTopicConfig == null) {
                if (!newTopicConfig.isReplica(this.brokerId)) continue;
                this.publishEvent(new AddTopicEvent((Topic)newTopicConfig, Lists.newArrayList(newTopicConfig.getPartitionGroups().values())));
                for (PartitionGroup partitionGroup : newTopicConfig.fetchTopicPartitionGroupsByBrokerId(this.brokerId)) {
                    this.publishEvent(new AddPartitionGroupEvent(newTopicConfig.getName(), partitionGroup));
                }
                continue;
            }
            if (oldTopicConfig.isReplica(this.brokerId) && !newTopicConfig.isReplica(this.brokerId)) {
                for (PartitionGroup partitionGroup : oldTopicConfig.fetchTopicPartitionGroupsByBrokerId(this.brokerId)) {
                    this.publishEvent(new RemovePartitionGroupEvent(oldTopicConfig.getName(), partitionGroup));
                }
                continue;
            }
            if (!newTopicConfig.isReplica(this.brokerId)) continue;
            if (!this.compareTopic(oldTopicConfig, newTopicConfig)) {
                this.publishEvent(new UpdateTopicEvent((Topic)oldTopicConfig, (Topic)newTopicConfig));
            }
            for (PartitionGroup newPartitionGroup : newTopicConfig.fetchTopicPartitionGroupsByBrokerId(this.brokerId)) {
                PartitionGroup oldPartitionGroup = (PartitionGroup)oldTopicConfig.getPartitionGroups().get(newPartitionGroup.getGroup());
                if (oldPartitionGroup == null || !oldPartitionGroup.getReplicas().contains(this.brokerId)) {
                    this.publishEvent(new AddPartitionGroupEvent(newTopicConfig.getName(), newPartitionGroup));
                    continue;
                }
                if (this.comparePartitionGroup(oldPartitionGroup, newPartitionGroup)) continue;
                this.publishEvent(new UpdatePartitionGroupEvent(newTopicConfig.getName(), oldPartitionGroup, newPartitionGroup));
            }
            for (PartitionGroup oldPartitionGroup : oldTopicConfig.fetchTopicPartitionGroupsByBrokerId(this.brokerId)) {
                PartitionGroup newPartitionGroup = (PartitionGroup)newTopicConfig.getPartitionGroups().get(oldPartitionGroup.getGroup());
                if (newPartitionGroup != null && newPartitionGroup.getReplicas().contains(this.brokerId)) continue;
                this.publishEvent(new RemovePartitionGroupEvent(newTopicConfig.getName(), oldPartitionGroup));
            }
        }
        for (Map.Entry<TopicName, TopicConfig> oldTopicEntry : oldCache.getTopicConfigMap().entrySet()) {
            TopicConfig newTopic = newCache.getTopicConfigMap().get(oldTopicEntry.getKey());
            TopicConfig oldTopic = oldTopicEntry.getValue();
            if (newTopic != null || !oldTopic.isReplica(this.brokerId)) continue;
            for (PartitionGroup partitionGroup : oldTopic.fetchTopicPartitionGroupsByBrokerId(this.brokerId)) {
                this.publishEvent(new RemovePartitionGroupEvent(oldTopic.getName(), partitionGroup));
            }
            this.publishEvent(new RemoveTopicEvent((Topic)oldTopic, Lists.newArrayList(oldTopicEntry.getValue().getPartitionGroups().values())));
        }
    }

    protected void compensateBroker(AllMetadataCache oldCache, AllMetadataCache newCache) {
        for (Map.Entry<Integer, Broker> newBrokerEntry : newCache.getBrokerMap().entrySet()) {
            Broker oldBroker = oldCache.getBrokerMap().get(newBrokerEntry.getKey());
            if (!newBrokerEntry.getValue().getId().equals(this.brokerId)) continue;
            if (oldBroker == null) {
                this.publishEvent(new AddBrokerEvent(newBrokerEntry.getValue()));
                continue;
            }
            if (this.compareBroker(oldBroker, newBrokerEntry.getValue())) continue;
            this.publishEvent(new UpdateBrokerEvent(oldBroker, newBrokerEntry.getValue()));
        }
        for (Map.Entry<Integer, Broker> oldBrokerEntry : oldCache.getBrokerMap().entrySet()) {
            if (!oldBrokerEntry.getValue().getId().equals(this.brokerId) || newCache.getBrokerMap().containsKey(oldBrokerEntry.getKey())) continue;
            this.publishEvent(new RemoveBrokerEvent(oldBrokerEntry.getValue()));
        }
    }

    protected void compensateProducer(AllMetadataCache oldCache, AllMetadataCache newCache) {
        TopicConfig oldTopicConfig;
        TopicConfig newTopicConfig;
        for (Producer newProducer : newCache.getAllProducers()) {
            Producer oldProducer;
            newTopicConfig = newCache.getTopicConfigMap().get(newProducer.getTopic());
            oldTopicConfig = oldCache.getTopicConfigMap().get(newProducer.getTopic());
            Map<TopicName, Producer> oldTopicProducerMap = oldCache.getProducerAppMap().get(newProducer.getApp());
            Producer producer = oldProducer = oldTopicProducerMap == null ? null : oldTopicProducerMap.get(newProducer.getTopic());
            if (newTopicConfig == null || !newTopicConfig.isReplica(this.brokerId)) continue;
            if (oldProducer == null) {
                this.publishEvent(new AddProducerEvent(newProducer.getTopic(), newProducer));
                continue;
            }
            if (oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) {
                this.publishEvent(new AddProducerEvent(newProducer.getTopic(), newProducer));
                continue;
            }
            if (this.compareProducer(oldProducer, newProducer)) continue;
            this.publishEvent(new UpdateProducerEvent(newProducer.getTopic(), oldProducer, newProducer));
        }
        for (Producer oldProducer : oldCache.getAllProducers()) {
            Producer newProducer;
            newTopicConfig = newCache.getTopicConfigMap().get(oldProducer.getTopic());
            oldTopicConfig = oldCache.getTopicConfigMap().get(oldProducer.getTopic());
            Map<TopicName, Producer> newTopicProducerMap = newCache.getProducerAppMap().get(oldProducer.getApp());
            Producer producer = newProducer = newTopicProducerMap == null ? null : newTopicProducerMap.get(oldProducer.getTopic());
            if (newProducer == null) {
                if (oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) continue;
                this.publishEvent(new RemoveProducerEvent(oldProducer.getTopic(), oldProducer));
                continue;
            }
            if (newTopicConfig != null && newTopicConfig.isReplica(this.brokerId) || oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) continue;
            this.publishEvent(new RemoveProducerEvent(oldProducer.getTopic(), oldProducer));
        }
    }

    protected void compensateConsumer(AllMetadataCache oldCache, AllMetadataCache newCache) {
        TopicConfig oldTopicConfig;
        TopicConfig newTopicConfig;
        for (Consumer newConsumer : newCache.getAllConsumers()) {
            Consumer oldConsumer;
            newTopicConfig = newCache.getTopicConfigMap().get(newConsumer.getTopic());
            oldTopicConfig = oldCache.getTopicConfigMap().get(newConsumer.getTopic());
            Map<TopicName, Consumer> oldTopicConsumerMap = oldCache.getConsumerAppMap().get(newConsumer.getApp());
            Consumer consumer = oldConsumer = oldTopicConsumerMap == null ? null : oldTopicConsumerMap.get(newConsumer.getTopic());
            if (newTopicConfig == null || !newTopicConfig.isReplica(this.brokerId)) continue;
            if (oldConsumer == null) {
                this.publishEvent(new AddConsumerEvent(newConsumer.getTopic(), newConsumer));
                continue;
            }
            if (oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) {
                this.publishEvent(new AddConsumerEvent(newConsumer.getTopic(), newConsumer));
                continue;
            }
            if (this.compareConsumer(oldConsumer, newConsumer)) continue;
            this.publishEvent(new UpdateConsumerEvent(newConsumer.getTopic(), oldConsumer, newConsumer));
        }
        for (Consumer oldConsumer : oldCache.getAllConsumers()) {
            Consumer newConsumer;
            newTopicConfig = newCache.getTopicConfigMap().get(oldConsumer.getTopic());
            oldTopicConfig = oldCache.getTopicConfigMap().get(oldConsumer.getTopic());
            Map<TopicName, Consumer> newTopicConsumerMap = newCache.getConsumerAppMap().get(oldConsumer.getApp());
            Consumer consumer = newConsumer = newTopicConsumerMap == null ? null : newTopicConsumerMap.get(oldConsumer.getTopic());
            if (newConsumer == null) {
                if (oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) continue;
                this.publishEvent(new RemoveConsumerEvent(oldConsumer.getTopic(), oldConsumer));
                continue;
            }
            if (newTopicConfig != null && newTopicConfig.isReplica(this.brokerId) || oldTopicConfig == null || !oldTopicConfig.isReplica(this.brokerId)) continue;
            this.publishEvent(new RemoveConsumerEvent(oldConsumer.getTopic(), oldConsumer));
        }
    }

    protected void compensateDataCenter(AllMetadataCache oldCache, AllMetadataCache newCache) {
        for (DCWrapper newDataCenter : newCache.getAllDataCenters()) {
            DCWrapper oldDataCenter = oldCache.getDataCenterCodeMap().get(newDataCenter.getDataCenter().getCode());
            if (oldDataCenter == null) {
                this.publishEvent(new AddDataCenterEvent(newDataCenter.getDataCenter()));
                continue;
            }
            if (this.compareDataCenter(oldDataCenter, newDataCenter)) continue;
            this.publishEvent(new UpdateDataCenterEvent(oldDataCenter.getDataCenter(), newDataCenter.getDataCenter()));
        }
        for (DCWrapper oldDataCenter : oldCache.getAllDataCenters()) {
            if (newCache.getDataCenterCodeMap().containsKey(oldDataCenter.getDataCenter().getCode())) continue;
            this.publishEvent(new RemoveDataCenterEvent(oldDataCenter.getDataCenter()));
        }
    }

    protected void compensateConfig(AllMetadataCache oldCache, AllMetadataCache newCache) {
        for (Config newConfig : newCache.getAllConfigs()) {
            Config oldConfig = oldCache.getConfigKeyMap().get(newConfig.getId());
            if (oldConfig == null) {
                this.publishEvent(new AddConfigEvent(newConfig));
                continue;
            }
            if (this.compareConfig(oldConfig, newConfig)) continue;
            this.publishEvent(new UpdateConfigEvent(oldConfig, newConfig));
        }
        for (Config oldConfig : oldCache.getAllConfigs()) {
            if (newCache.getConfigKeyMap().containsKey(oldConfig.getId())) continue;
            this.publishEvent(new RemoveConfigEvent(oldConfig));
        }
    }

    protected void publishEvent(MetaEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("publish event, event: {}", (Object)JSON.toJSONString((Object)event));
        }
        NameServerEvent nameServerEvent = new NameServerEvent();
        nameServerEvent.setMetaEvent(event);
        nameServerEvent.setEventType(event.getEventType());
        this.eventBus.inform((Object)nameServerEvent);
    }

    protected boolean compareTopic(TopicConfig topicConfig1, TopicConfig topicConfig2) {
        if (!topicConfig1.getName().equals((Object)topicConfig2.getName())) {
            return false;
        }
        return topicConfig1.getPartitions() == topicConfig2.getPartitions();
    }

    protected boolean comparePartitionGroup(PartitionGroup partitionGroup1, PartitionGroup partitionGroup2) {
        return partitionGroup1.equals((Object)partitionGroup2);
    }

    protected boolean compareBroker(Broker broker1, Broker broker2) {
        return broker1.equals((Object)broker2);
    }

    protected boolean compareProducer(Producer producer1, Producer producer2) {
        return producer1.equals((Object)producer2);
    }

    protected boolean compareConsumer(Consumer consumer1, Consumer consumer2) {
        return consumer1.equals((Object)consumer2);
    }

    protected boolean compareDataCenter(DCWrapper dataCenter1, DCWrapper dataCenter2) {
        return StringUtils.equals((CharSequence)dataCenter1.getDataCenter().getName(), (CharSequence)dataCenter2.getDataCenter().getName()) && StringUtils.equals((CharSequence)dataCenter1.getDataCenter().getRegion(), (CharSequence)dataCenter2.getDataCenter().getRegion()) && StringUtils.equals((CharSequence)dataCenter1.getDataCenter().getUrl(), (CharSequence)dataCenter2.getDataCenter().getUrl());
    }

    protected boolean compareConfig(Config config1, Config config2) {
        return config1.equals((Object)config2);
    }
}

