/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataValidator {
    protected static final Logger logger = LoggerFactory.getLogger(MetadataValidator.class);
    private NameServiceConfig config;

    public MetadataValidator(NameServiceConfig config) {
        this.config = config;
    }

    public boolean validateChange(AllMetadataCache oldCache, AllMetadataCache newCache) {
        if (oldCache.getAllTopicConfigs().size() - newCache.getAllTopicConfigs().size() > this.config.getCompensationThreshold()) {
            logger.error("validate change error, oldTopic: {}, newTopic: {}, threshold: {}", new Object[]{oldCache.getAllTopicConfigs().size(), newCache.getAllTopicConfigs().size(), this.config.getCompensationThreshold()});
            return false;
        }
        if (oldCache.getAllConsumers().size() - newCache.getAllConsumers().size() > this.config.getCompensationThreshold()) {
            logger.error("validate change error, oldConsumer: {}, newConsumer: {}, threshold: {}", new Object[]{oldCache.getAllConsumers().size(), newCache.getAllConsumers().size(), this.config.getCompensationThreshold()});
            return false;
        }
        if (oldCache.getAllProducers().size() - newCache.getAllProducers().size() > this.config.getCompensationThreshold()) {
            logger.error("validate change error, oldProducer: {}, oldConsumer: {}, threshold: {}", new Object[]{oldCache.getAllProducers().size(), newCache.getAllProducers().size(), this.config.getCompensationThreshold()});
            return false;
        }
        return true;
    }
}

