/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.jd.laf.extension.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.monitor.TraceStat;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.NsrPlugins;
import org.joyqueue.nsr.config.NameServerConfig;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.nameservice.NameServerInternal;
import org.joyqueue.nsr.network.NsrTransportServerFactory;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServer
extends Service
implements NameService,
PropertySupplierAware,
Type {
    protected static final Logger logger = LoggerFactory.getLogger(NameServer.class);
    private NameServerInternal delegate = new NameServerInternal();
    private PointTracer tracer;
    private NameServerConfig nameServerConfig;
    private NsrTransportServerFactory transportServerFactory;
    private TransportServer transportServer;
    private Cache<String, Map<TopicName, TopicConfig>> appTopicCache;
    private Cache<String, Optional<TopicConfig>> topicCache;

    @Override
    public TopicConfig subscribe(Subscription subscription, ClientType clientType) {
        TraceStat trace = this.tracer.begin("NameService.subscribe");
        try {
            TopicConfig result = this.delegate.subscribe(subscription, clientType);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<TopicConfig> subscribe(List<Subscription> subscriptions, ClientType clientType) {
        TraceStat trace = this.tracer.begin("NameService.subscribes");
        try {
            List<TopicConfig> result = this.delegate.subscribe(subscriptions, clientType);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public void unSubscribe(Subscription subscription) {
        TraceStat trace = this.tracer.begin("NameService.Subscribe");
        try {
            this.delegate.unSubscribe(subscription);
            this.tracer.end(trace);
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public void unSubscribe(List<Subscription> subscriptions) {
        TraceStat trace = this.tracer.begin("NameService.Subscribes");
        try {
            this.delegate.unSubscribe(subscriptions);
            this.tracer.end(trace);
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public boolean hasSubscribe(String app, Subscription.Type subscribe) {
        TraceStat trace = this.tracer.begin("NameService.hasSubscribe");
        try {
            boolean result = this.delegate.hasSubscribe(app, subscribe);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public void leaderReport(TopicName topic, int partitionGroup, int leaderBrokerId, Set<Integer> isrId, int termId) {
        TraceStat trace = this.tracer.begin("NameService.leaderReport");
        try {
            this.delegate.leaderReport(topic, partitionGroup, leaderBrokerId, isrId, termId);
            this.tracer.end(trace);
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Broker getBroker(int brokerId) {
        TraceStat trace = this.tracer.begin("NameService.getBroker");
        try {
            Broker result = this.delegate.getBroker(brokerId);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Broker> getAllBrokers() {
        TraceStat trace = this.tracer.begin("NameService.getAllBrokers");
        try {
            List<Broker> result = this.delegate.getAllBrokers();
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        TraceStat trace = this.tracer.begin("NameService.addTopic");
        try {
            this.delegate.addTopic(topic, partitionGroups);
            this.tracer.end(trace);
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public TopicConfig getTopicConfig(TopicName topic) {
        TraceStat trace = this.tracer.begin("NameService.getTopicConfig");
        try {
            TopicConfig result = this.doGetTopicConfig(topic);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected TopicConfig doGetTopicConfig(TopicName topicName) {
        if (this.nameServerConfig.getCacheEnable()) {
            try {
                Optional result = (Optional)this.topicCache.get((Object)topicName.getFullName(), () -> Optional.ofNullable(this.delegate.getTopicConfig(topicName)));
                return result.isPresent() ? (TopicConfig)result.get() : null;
            }
            catch (Exception e) {
                logger.error("getTopicConfig exception, topicName: {}", (Object)topicName, (Object)e);
                throw new NsrException(e);
            }
        }
        return this.delegate.getTopicConfig(topicName);
    }

    @Override
    public Set<String> getAllTopicCodes() {
        TraceStat trace = this.tracer.begin("NameService.getAllTopicCodes");
        try {
            Set<String> result = this.delegate.getAllTopicCodes();
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Set<String> getTopics(String app, Subscription.Type subscription) {
        TraceStat trace = this.tracer.begin("NameService.getTopics");
        try {
            Set<String> result = this.delegate.getTopics(app, subscription);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        TraceStat trace = this.tracer.begin("NameService.getTopicConfigByBroker");
        try {
            Map<TopicName, TopicConfig> result = this.delegate.getTopicConfigByBroker(brokerId);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Broker register(Integer brokerId, String brokerIp, Integer port) {
        TraceStat trace = this.tracer.begin("NameService.register");
        try {
            Broker result = this.delegate.register(brokerId, brokerIp, port);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        TraceStat trace = this.tracer.begin("NameService.getProducerByTopicAndApp");
        try {
            Producer result = this.delegate.getProducerByTopicAndApp(topic, app);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        TraceStat trace = this.tracer.begin("NameService.getConsumerByTopicAndApp");
        try {
            Consumer result = this.delegate.getConsumerByTopicAndApp(topic, app);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByApp(String subscribeApp, Subscription.Type subscribe) {
        TraceStat trace = this.tracer.begin("NameService.getTopicConfigByApp");
        try {
            Map<TopicName, TopicConfig> result = this.doGetTopicConfigByApp(subscribeApp, subscribe);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected Map<TopicName, TopicConfig> doGetTopicConfigByApp(final String subscribeApp, final Subscription.Type subscribe) {
        if (this.nameServerConfig.getCacheEnable()) {
            try {
                return (Map)this.appTopicCache.get((Object)(subscribeApp + "_" + String.valueOf(subscribe)), (Callable)new Callable<Map<TopicName, TopicConfig>>(){

                    @Override
                    public Map<TopicName, TopicConfig> call() throws Exception {
                        return NameServer.this.delegate.getTopicConfigByApp(subscribeApp, subscribe);
                    }
                });
            }
            catch (ExecutionException e) {
                logger.error("getTopicConfigByApp exception, subscribeApp: {}, subscribe: {}", (Object)subscribeApp, (Object)subscribe);
                return Maps.newHashMap();
            }
        }
        return this.delegate.getTopicConfigByApp(subscribeApp, subscribe);
    }

    @Override
    public DataCenter getDataCenter(String ip) {
        TraceStat trace = this.tracer.begin("NameService.getDataCenter");
        try {
            DataCenter result = this.delegate.getDataCenter(ip);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public String getConfig(String group, String key) {
        TraceStat trace = this.tracer.begin("NameService.getConfig");
        try {
            String result = this.delegate.getConfig(group, key);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Config> getAllConfigs() {
        TraceStat trace = this.tracer.begin("NameService.getAllConfigs");
        try {
            List<Config> result = this.delegate.getAllConfigs();
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Broker> getBrokerByRetryType(String retryType) {
        TraceStat trace = this.tracer.begin("NameService.getBrokerByRetryType");
        try {
            List<Broker> result = this.delegate.getBrokerByRetryType(retryType);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Consumer> getConsumerByTopic(TopicName topic) {
        TraceStat trace = this.tracer.begin("NameService.getConsumerByTopic");
        try {
            List<Consumer> result = this.delegate.getConsumerByTopic(topic);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Producer> getProducerByTopic(TopicName topic) {
        TraceStat trace = this.tracer.begin("NameService.getProducerByTopic");
        try {
            List<Producer> result = this.delegate.getProducerByTopic(topic);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public List<Replica> getReplicaByBroker(Integer brokerId) {
        TraceStat trace = this.tracer.begin("NameService.getReplicaByBroker");
        try {
            List<Replica> result = this.delegate.getReplicaByBroker(brokerId);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public AppToken getAppToken(String app, String token) {
        TraceStat trace = this.tracer.begin("NameService.getAppToken");
        try {
            AppToken result = this.delegate.getAppToken(app, token);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public AllMetadata getAllMetadata() {
        TraceStat trace = this.tracer.begin("NameService.getAllMetadata");
        try {
            AllMetadata result = this.delegate.getAllMetadata();
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    @Override
    public void addListener(EventListener<NameServerEvent> listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<NameServerEvent> listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void addEvent(NameServerEvent event) {
        this.delegate.addEvent(event);
    }

    protected void doStop() {
        Close.close((LifeCycle)this.transportServer);
        this.delegate.doStop();
    }

    public void setSupplier(PropertySupplier propertySupplier) {
        this.delegate.setSupplier(propertySupplier);
        this.tracer = (PointTracer)NsrPlugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
        this.nameServerConfig = new NameServerConfig(propertySupplier);
        this.transportServerFactory = new NsrTransportServerFactory(this, propertySupplier);
        this.transportServer = this.buildTransportServer();
        this.topicCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.nameServerConfig.getTopicCacheExpireTime(), TimeUnit.MILLISECONDS).build();
        this.appTopicCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.nameServerConfig.getTopicCacheExpireTime(), TimeUnit.MILLISECONDS).build();
        try {
            this.transportServer.start();
        }
        catch (Exception e) {
            throw new NsrException(e);
        }
    }

    protected TransportServer buildTransportServer() {
        ServerConfig serverConfig = this.nameServerConfig.getServerConfig();
        serverConfig.setPort(this.nameServerConfig.getServicePort());
        serverConfig.setAcceptThreadName("joyqueue-nameserver-accept-eventLoop");
        serverConfig.setIoThreadName("joyqueue-nameserver-io-eventLoop");
        return this.transportServerFactory.bind(serverConfig, serverConfig.getHost(), serverConfig.getPort());
    }

    public Object type() {
        return "server";
    }
}

