/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.ManageServer;
import org.joyqueue.nsr.MetaManager;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.ServiceProvider;
import org.joyqueue.nsr.config.NameServerConfig;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.service.AppTokenService;
import org.joyqueue.nsr.service.BrokerService;
import org.joyqueue.nsr.service.ConfigService;
import org.joyqueue.nsr.service.ConsumerService;
import org.joyqueue.nsr.service.DataCenterService;
import org.joyqueue.nsr.service.NamespaceService;
import org.joyqueue.nsr.service.PartitionGroupReplicaService;
import org.joyqueue.nsr.service.PartitionGroupService;
import org.joyqueue.nsr.service.ProducerService;
import org.joyqueue.nsr.service.TopicService;
import org.joyqueue.nsr.util.DCWrapper;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServerInternal
extends Service
implements NameService,
PropertySupplierAware {
    private NameServerConfig nameServerConfig;
    private ManageServer manageServer;
    private MetaManager metaManager;
    private PropertySupplier propertySupplier;
    private ServiceProvider serviceProvider;
    protected EventBus<NameServerEvent> eventManager = new EventBus("joyqueue-nameserver-eventBus");
    public static ExtensionPoint<ServiceProvider, String> serviceProviderPoint = new ExtensionPointLazy(ServiceProvider.class);
    private static final Logger logger = LoggerFactory.getLogger(NameServerInternal.class);
    private Cache<String, Boolean> hasSubscribeCache = CacheBuilder.newBuilder().expireAfterWrite(60000L, TimeUnit.MILLISECONDS).build();

    public void setSupplier(PropertySupplier supplier) {
        try {
            this.propertySupplier = supplier;
            if (this.nameServerConfig == null) {
                this.nameServerConfig = new NameServerConfig(this.propertySupplier);
            }
            if (this.serviceProvider == null) {
                this.serviceProvider = this.loadServiceProvider(this.propertySupplier);
            }
            if (this.metaManager == null) {
                this.metaManager = this.buildMetaManager();
            }
            if (this.manageServer == null) {
                this.manageServer = this.buildManageServer();
            }
            this.manageServer.setManagerPort(this.nameServerConfig.getManagerPort());
            this.metaManager.start();
            this.eventManager.start();
            this.manageServer.start();
            logger.info("nameServer is started");
        }
        catch (Exception e) {
            throw new NsrException(e);
        }
    }

    public void doStop() {
        super.doStop();
        try {
            Close.close((LifeCycle)this.manageServer);
            Close.close((LifeCycle)this.metaManager);
            Close.close(this.eventManager);
            if (this.serviceProvider instanceof LifeCycle) {
                Close.close((LifeCycle)((LifeCycle)this.serviceProvider));
            }
        }
        finally {
            logger.info("nameServer is stopped");
        }
    }

    @Override
    public List<TopicConfig> subscribe(List<Subscription> subscriptions, ClientType clientType) {
        ArrayList<TopicConfig> configs = new ArrayList<TopicConfig>();
        subscriptions.forEach(subscription -> {
            TopicConfig topicConfig = this.subscribe((Subscription)subscription, clientType);
            if (null != topicConfig) {
                configs.add(topicConfig);
            }
        });
        return configs;
    }

    @Override
    public TopicConfig subscribe(Subscription subscription, ClientType clientType) {
        if (subscription.getType() == Subscription.Type.CONSUMPTION) {
            TopicName topic = subscription.getTopic();
            String app = subscription.getApp();
            TopicConfig topicConfig = this.doGetTopicConfig(topic);
            if (null == topicConfig) {
                return null;
            }
            Consumer consumer = this.metaManager.getConsumer(topic, app);
            if (null == consumer) {
                consumer = new Consumer();
                consumer.setTopic(topic);
                consumer.setApp(app);
                consumer.setClientType(clientType);
                consumer = this.metaManager.addConsumer(consumer);
            }
            return topicConfig;
        }
        if (subscription.getType() == Subscription.Type.PRODUCTION) {
            TopicName topic = subscription.getTopic();
            String app = subscription.getApp();
            TopicConfig topicConfig = this.doGetTopicConfig(topic);
            if (null == topicConfig) {
                return null;
            }
            Producer producer = this.metaManager.getProducer(topic, app);
            if (null == producer) {
                producer = new Producer();
                producer.setTopic(topic);
                producer.setApp(app);
                producer.setClientType(clientType);
                producer = this.metaManager.addProducer(producer);
            }
            return topicConfig;
        }
        throw new IllegalStateException("operation do not supported");
    }

    @Override
    public void unSubscribe(Subscription subscription) {
        if (subscription.getType() == Subscription.Type.CONSUMPTION) {
            TopicConfig topicConfig = this.doGetTopicConfig(subscription.getTopic());
            if (null == topicConfig) {
                return;
            }
            this.metaManager.removeConsumer(subscription.getTopic(), subscription.getApp());
        } else if (subscription.getType() == Subscription.Type.PRODUCTION) {
            TopicConfig topicConfig = this.doGetTopicConfig(subscription.getTopic());
            if (null == topicConfig) {
                return;
            }
            this.metaManager.removeProducer(subscription.getTopic(), subscription.getApp());
        } else {
            throw new IllegalStateException("operation do not supported");
        }
    }

    @Override
    public void unSubscribe(List<Subscription> subscriptions) {
        subscriptions.forEach(subscription -> this.unSubscribe((Subscription)subscription));
    }

    @Override
    public void leaderReport(TopicName topic, int partitionGroup, int leaderBrokerId, Set<Integer> isrId, int termId) {
        logger.info("Leader report, topic is {}, partition group is {}, leader is {}, term is {}", new Object[]{topic, partitionGroup, leaderBrokerId, termId});
        TopicConfig topicConfig = this.doGetTopicConfig(topic);
        if (topicConfig == null) {
            logger.warn("topic not exist, topic: {}, partitionGroup: {}, leaderBrokerId: {}", new Object[]{topic, partitionGroup, leaderBrokerId});
            return;
        }
        PartitionGroup group = null;
        for (PartitionGroup pgroup : topicConfig.getPartitionGroups().values()) {
            if (pgroup.getGroup() != partitionGroup) continue;
            if (pgroup.getTerm() > termId || pgroup.getTerm() == termId && leaderBrokerId == -1) {
                logger.warn("Leader report for topic {} group {}, term {} less than current term {}, leaderId is {}", new Object[]{topic, partitionGroup, termId, pgroup.getTerm(), leaderBrokerId});
                return;
            }
            group = pgroup;
            break;
        }
        if (null == group) {
            throw new RuntimeException(String.format("topic[%s] group[%s] is not exist", topic, partitionGroup));
        }
        group.setIsrs(isrId);
        group.setLeader(Integer.valueOf(leaderBrokerId));
        group.setTerm(Integer.valueOf(termId));
        this.metaManager.leaderReport(group);
    }

    @Override
    public Broker getBroker(int brokerId) {
        return this.metaManager.getBrokerById(brokerId);
    }

    @Override
    public List<Broker> getAllBrokers() {
        return this.metaManager.getAllBrokers();
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        this.metaManager.addTopic(topic, partitionGroups);
    }

    @Override
    public TopicConfig getTopicConfig(TopicName topicName) {
        return this.doGetTopicConfig(topicName);
    }

    protected TopicConfig doGetTopicConfig(TopicName topicName) {
        Topic topic = this.metaManager.getTopicByName(topicName);
        if (null == topic) {
            return null;
        }
        List<PartitionGroup> partitionGroups = this.metaManager.getPartitionGroupByTopic(topicName);
        TopicConfig topicConfig = TopicConfig.toTopicConfig((Topic)topic);
        topicConfig.setPartitionGroups(partitionGroups.stream().collect(Collectors.toMap(PartitionGroup::getGroup, group -> group)));
        if (null != partitionGroups) {
            partitionGroups.forEach(group -> {
                HashMap brokerMap = new HashMap();
                group.getReplicas().forEach(brokerId -> {
                    if (!brokerMap.containsKey(brokerId)) {
                        Broker broker = this.getBroker((int)brokerId);
                        if (broker == null) {
                            throw new NsrException(String.format("broker %s not exist, topic: %s, group: {}", brokerId, topicName, group.getGroup()));
                        }
                        brokerMap.put(brokerId, broker);
                    }
                });
                group.setBrokers(brokerMap);
            });
        }
        return topicConfig;
    }

    @Override
    public Set<String> getAllTopicCodes() {
        List<Topic> allTopics = this.metaManager.getAllTopics();
        if (null != allTopics) {
            HashSet<String> topics = new HashSet<String>();
            allTopics.forEach(topic -> topics.add(topic.getName().getFullName()));
            return topics;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getTopics(String app, Subscription.Type subscribe) {
        HashSet<String> topics = new HashSet<String>();
        if (null == subscribe) {
            List<Consumer> consumers;
            List<Producer> producers = this.metaManager.getProducer(app);
            if (null != producers) {
                producers.forEach(producer -> topics.add(producer.getTopic().getFullName()));
            }
            if (null != (consumers = this.metaManager.getConsumer(app))) {
                consumers.forEach(consumer -> topics.add(consumer.getTopic().getFullName()));
            }
        } else {
            switch (subscribe) {
                case PRODUCTION: {
                    List<Producer> producers = this.metaManager.getProducer(app);
                    if (null == producers) break;
                    producers.forEach(producer -> topics.add(producer.getTopic().getFullName()));
                    break;
                }
                case CONSUMPTION: {
                    List<Consumer> consumers = this.metaManager.getConsumer(app);
                    if (null == consumers) break;
                    consumers.forEach(consumer -> topics.add(consumer.getTopic().getFullName()));
                }
            }
        }
        return topics;
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        HashMap<TopicName, TopicConfig> map = new HashMap<TopicName, TopicConfig>();
        List<Replica> replicas = this.metaManager.getReplicaByBroker(brokerId);
        for (Replica replica : replicas) {
            if (map.containsKey(replica.getTopic())) continue;
            TopicConfig topicConfig = this.doGetTopicConfig(replica.getTopic());
            if (topicConfig == null) {
                logger.error("topic not exist, topic: {}, brokerId: {}", (Object)replica.getTopic(), (Object)brokerId);
                continue;
            }
            map.put(replica.getTopic(), this.doGetTopicConfig(replica.getTopic()));
        }
        return map;
    }

    @Override
    public List<Replica> getReplicaByBroker(Integer brokerId) {
        return this.metaManager.getReplicaByBroker(brokerId);
    }

    @Override
    public AppToken getAppToken(String app, String token) {
        return this.metaManager.findAppToken(app, token);
    }

    @Override
    public Broker register(Integer brokerId, String brokerIp, Integer port) {
        Broker broker = null;
        if (null == brokerId) {
            broker = this.metaManager.getBrokerByIpAndPort(brokerIp, port);
            if (null == broker) {
                brokerId = this.generateBrokerId();
                broker = new Broker();
                broker.setId(brokerId.intValue());
                broker.setIp(brokerIp);
                DataCenter dataCenter = this.getDataCenter(brokerIp);
                broker.setDataCenter(dataCenter.getCode());
                broker.setPort(port.intValue());
                broker.setRetryType("RemoteRetry");
                broker.setPermission(Broker.PermissionEnum.FULL);
                this.metaManager.addBroker(broker);
                logger.info("register broker success broker.id {}", (Object)brokerId);
            } else {
                brokerId = broker.getId();
            }
        }
        if (null != (broker = this.metaManager.getBrokerById(brokerId))) {
            broker.setIp(brokerIp);
            broker.setPort(port.intValue());
            broker.setDataCenter(this.getDataCenter(brokerIp).getCode());
            this.metaManager.updateBroker(broker);
        }
        return broker;
    }

    protected int generateBrokerId() {
        int id = 0;
        while (id <= 0) {
            int result = (int)(System.nanoTime() % 1000000000L);
            id = result + RandomUtils.nextInt((int)0, (int)result);
        }
        return id;
    }

    @Override
    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        return this.metaManager.getProducer(topic, app);
    }

    @Override
    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        return this.metaManager.getConsumer(topic, app);
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByApp(String subscribeApp, Subscription.Type subscribe) {
        HashMap<TopicName, TopicConfig> appTopicConfigs = new HashMap<TopicName, TopicConfig>();
        List<Consumer> subscriptions = null;
        switch (subscribe) {
            case CONSUMPTION: {
                subscriptions = this.metaManager.getConsumer(subscribeApp);
                break;
            }
            case PRODUCTION: {
                subscriptions = this.metaManager.getProducer(subscribeApp);
            }
        }
        if (null != subscriptions) {
            subscriptions.forEach(p -> {
                TopicConfig topicConfig = this.doGetTopicConfig(p.getTopic());
                if (null != topicConfig) {
                    appTopicConfigs.put(p.getTopic(), topicConfig);
                }
            });
        }
        return appTopicConfigs;
    }

    @Override
    public boolean hasSubscribe(final String subscribeApp, final Subscription.Type subscribe) {
        try {
            return (Boolean)this.hasSubscribeCache.get((Object)(subscribeApp + "_" + subscribe), (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    switch (subscribe) {
                        case CONSUMPTION: {
                            List<Consumer> consumers = NameServerInternal.this.metaManager.getConsumer(subscribeApp);
                            return null != consumers && consumers.size() > 0;
                        }
                        case PRODUCTION: {
                            List<Producer> producers = NameServerInternal.this.metaManager.getProducer(subscribeApp);
                            return null != producers && producers.size() > 0;
                        }
                    }
                    return false;
                }
            });
        }
        catch (ExecutionException e) {
            logger.error("hasSubscribe, subscribeApp: {}, subscribe: {}", new Object[]{subscribeApp, subscribe, e});
            return true;
        }
    }

    @Override
    public DataCenter getDataCenter(String ip) {
        Collection<DataCenter> dcs = this.metaManager.getAllDataCenter();
        Optional<DataCenter> optional = dcs.stream().filter(dataCenter -> new DCWrapper((DataCenter)dataCenter).match(ip)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return DataCenter.DEFAULT;
    }

    @Override
    public String getConfig(String group, String key) {
        Config config = this.metaManager.getConfig(group, key);
        return config == null ? null : config.getValue();
    }

    @Override
    public List<Config> getAllConfigs() {
        return this.metaManager.getAllConfigs();
    }

    @Override
    public List<Broker> getBrokerByRetryType(String retryType) {
        return this.metaManager.getBrokerByRetryType(retryType);
    }

    @Override
    public List<Consumer> getConsumerByTopic(TopicName topic) {
        return this.metaManager.getConsumerByTopic(topic);
    }

    @Override
    public List<Producer> getProducerByTopic(TopicName topic) {
        return this.metaManager.getProducerByTopic(topic);
    }

    @Override
    public AllMetadata getAllMetadata() {
        Map<TopicName, TopicConfig> topicConfigs = this.getAllTopicConfigs();
        List<Broker> allBrokers = this.metaManager.getAllBrokers();
        List<Config> allConfigs = this.metaManager.getAllConfigs();
        ArrayList allDataCenters = Lists.newArrayList(this.metaManager.getAllDataCenter());
        List<Consumer> allConsumers = this.metaManager.getAllConsumers();
        List<Producer> allProducers = this.metaManager.getAllProducers();
        List<AppToken> allAppTokens = this.metaManager.getAllAppToken();
        HashMap allBrokerMap = Maps.newHashMap();
        for (Broker broker : allBrokers) {
            allBrokerMap.put(broker.getId(), broker);
        }
        for (Map.Entry entry : topicConfigs.entrySet()) {
            TopicConfig topicConfig = (TopicConfig)entry.getValue();
            for (Map.Entry partitionGroupEntry : topicConfig.getPartitionGroups().entrySet()) {
                PartitionGroup partitionGroup = (PartitionGroup)partitionGroupEntry.getValue();
                HashMap partitionGroupBrokers = Maps.newHashMap();
                for (Integer replica : partitionGroup.getReplicas()) {
                    Broker broker = (Broker)allBrokerMap.get(replica);
                    if (broker == null) continue;
                    partitionGroupBrokers.put(replica, broker);
                }
            }
        }
        AllMetadata allMetadata = new AllMetadata();
        allMetadata.setTopics(topicConfigs);
        allMetadata.setBrokers((Map)allBrokerMap);
        allMetadata.setProducers(allProducers);
        allMetadata.setConsumers(allConsumers);
        allMetadata.setDataCenters((List)allDataCenters);
        allMetadata.setConfigs(allConfigs);
        allMetadata.setAppTokens(allAppTokens);
        return allMetadata;
    }

    protected Map<TopicName, TopicConfig> getAllTopicConfigs() {
        List<Topic> topics = this.metaManager.getAllTopics();
        List<PartitionGroup> partitionGroups = this.metaManager.getAllPartitionGroups();
        HashMap partitionGroupMap = Maps.newHashMap();
        for (PartitionGroup partitionGroup : partitionGroups) {
            Map topicPartitionGroups = (Map)partitionGroupMap.get(partitionGroup.getTopic());
            if (topicPartitionGroups == null) {
                topicPartitionGroups = Maps.newHashMap();
                partitionGroupMap.put(partitionGroup.getTopic(), topicPartitionGroups);
            }
            topicPartitionGroups.put(partitionGroup.getGroup(), partitionGroup);
        }
        HashMap result = Maps.newHashMap();
        for (Topic topic : topics) {
            TopicConfig topicConfig = TopicConfig.toTopicConfig((Topic)topic);
            Map topicPartitionGroups = (Map)partitionGroupMap.get(topic.getName());
            if (topicPartitionGroups == null) {
                topicPartitionGroups = Maps.newHashMap();
            }
            topicConfig.setPartitionGroups(topicPartitionGroups);
            result.put(topicConfig.getName(), topicConfig);
        }
        return result;
    }

    @Override
    public void addListener(EventListener<NameServerEvent> listener) {
        this.eventManager.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<NameServerEvent> listener) {
        this.eventManager.removeListener(listener);
    }

    @Override
    public void addEvent(NameServerEvent event) {
        this.eventManager.add((Object)event);
    }

    private ManageServer buildManageServer() {
        TopicService topicService = this.serviceProvider.getService(TopicService.class);
        BrokerService brokerService = this.serviceProvider.getService(BrokerService.class);
        ConsumerService consumerService = this.serviceProvider.getService(ConsumerService.class);
        ProducerService producerService = this.serviceProvider.getService(ProducerService.class);
        ConfigService configService = this.serviceProvider.getService(ConfigService.class);
        AppTokenService appTokenService = this.serviceProvider.getService(AppTokenService.class);
        DataCenterService dataCenterService = this.serviceProvider.getService(DataCenterService.class);
        NamespaceService namespaceService = this.serviceProvider.getService(NamespaceService.class);
        PartitionGroupService partitionGroupService = this.serviceProvider.getService(PartitionGroupService.class);
        PartitionGroupReplicaService partitionGroupReplicaService = this.serviceProvider.getService(PartitionGroupReplicaService.class);
        Preconditions.checkArgument((brokerService != null ? 1 : 0) != 0, (Object)"broker service can not be null");
        Preconditions.checkArgument((topicService != null ? 1 : 0) != 0, (Object)"topic service can not be null");
        Preconditions.checkArgument((consumerService != null ? 1 : 0) != 0, (Object)"consumer service can not be null");
        Preconditions.checkArgument((producerService != null ? 1 : 0) != 0, (Object)"producer service can not be null");
        Preconditions.checkArgument((appTokenService != null ? 1 : 0) != 0, (Object)"appToken service can not be null");
        Preconditions.checkArgument((namespaceService != null ? 1 : 0) != 0, (Object)"namespace service can not be null");
        Preconditions.checkArgument((dataCenterService != null ? 1 : 0) != 0, (Object)"datacenter service can not be null");
        Preconditions.checkArgument((partitionGroupReplicaService != null ? 1 : 0) != 0, (Object)"replica service can not be null");
        Preconditions.checkArgument((partitionGroupService != null ? 1 : 0) != 0, (Object)"partitionGroup service can not be null");
        return new ManageServer(topicService, producerService, consumerService, brokerService, configService, appTokenService, dataCenterService, namespaceService, partitionGroupService, partitionGroupReplicaService);
    }

    private MetaManager buildMetaManager() {
        TopicService topicService = this.serviceProvider.getService(TopicService.class);
        ConfigService configService = this.serviceProvider.getService(ConfigService.class);
        BrokerService brokerService = this.serviceProvider.getService(BrokerService.class);
        ConsumerService consumerService = this.serviceProvider.getService(ConsumerService.class);
        ProducerService producerService = this.serviceProvider.getService(ProducerService.class);
        AppTokenService appTokenService = this.serviceProvider.getService(AppTokenService.class);
        DataCenterService dataCenterService = this.serviceProvider.getService(DataCenterService.class);
        PartitionGroupService partitionGroupService = this.serviceProvider.getService(PartitionGroupService.class);
        PartitionGroupReplicaService partitionGroupReplicaService = this.serviceProvider.getService(PartitionGroupReplicaService.class);
        return new MetaManager(configService, topicService, brokerService, consumerService, producerService, partitionGroupService, partitionGroupReplicaService, appTokenService, dataCenterService);
    }

    private ServiceProvider loadServiceProvider(PropertySupplier propertySupplier) throws Exception {
        ServiceProvider serviceProvider = (ServiceProvider)serviceProviderPoint.get();
        Preconditions.checkArgument((serviceProvider != null ? 1 : 0) != 0, (Object)"service provider can not be null.");
        if (serviceProvider instanceof PropertySupplierAware) {
            ((PropertySupplierAware)serviceProvider).setSupplier(propertySupplier);
        }
        if (serviceProvider instanceof LifeCycle) {
            ((LifeCycle)serviceProvider).start();
        }
        return serviceProvider;
    }

    private String createAppTokenCacheKey(String app, String token) {
        return app + "@" + token;
    }
}

