/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.joyqueue.toolkit.io.DoubleCopy;
import org.joyqueue.toolkit.io.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceCacheDoubleCopy
extends DoubleCopy {
    protected static final Logger logger = LoggerFactory.getLogger(NameServiceCacheDoubleCopy.class);
    private static final int DEFAULT_MAX_LENGTH = 0x6400000;
    private static final int VERSION_V0 = 0;
    private static final int CURRENT_VERSION = 0;
    private File file;
    protected NameServiceCacheEntry entry;

    public NameServiceCacheDoubleCopy(File file, int maxLength) throws IOException {
        super(file, maxLength);
        this.file = file;
    }

    public NameServiceCacheDoubleCopy(File file) throws IOException {
        this(file, 0x6400000);
    }

    public void flush(AllMetadataCache cache) {
        this.entry = this.entry == null ? new NameServiceCacheEntry(0, cache) : new NameServiceCacheEntry(this.entry.getVersion(), cache);
        super.flush();
    }

    protected String getName() {
        return "NameServiceCache";
    }

    protected byte[] serialize() {
        try {
            byte[] json = JSON.toJSONBytes((Object)this.entry, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            json = ZipUtil.compress((byte[])json);
            if (logger.isDebugEnabled()) {
                logger.debug("save nameservice cache, value: {}, file: {}", (Object)new String(json), (Object)this.file);
            }
            return json;
        }
        catch (Exception e) {
            logger.error("serialize cache exception", (Throwable)e);
            return new byte[0];
        }
    }

    protected void parse(byte[] data) {
        try {
            NameServiceCacheEntry entry;
            if (logger.isDebugEnabled()) {
                logger.debug("load nameservice cache, value: {}, file: {}", (Object)new String(data), (Object)this.file);
            }
            if ((entry = (NameServiceCacheEntry)JSON.parseObject((byte[])(data = ZipUtil.decompress((byte[])data).getBytes()), NameServiceCacheEntry.class, (Feature[])new Feature[0])) != null && entry.getVersion() != 0) {
                logger.warn("nameservice cache check version failed, current: {}, required: {}", (Object)entry.getVersion(), (Object)0);
                throw new NsrException("check version failed");
            }
            this.entry = entry;
        }
        catch (Exception e) {
            logger.error("load nameservice cache exception, file: {}", (Object)this.file, (Object)e);
            if (e instanceof NsrException) {
                throw (NsrException)e;
            }
            throw new NsrException(e);
        }
    }

    public AllMetadataCache getCache() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getCache();
    }

    public static class NameServiceCacheEntry {
        private int version;
        private AllMetadataCache cache;

        NameServiceCacheEntry() {
        }

        NameServiceCacheEntry(int version, AllMetadataCache cache) {
            this.version = version;
            this.cache = cache;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public AllMetadataCache getCache() {
            return this.cache;
        }

        public void setCache(AllMetadataCache cache) {
            this.cache = cache;
        }
    }
}

