/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.AddConsumerEvent;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.AddProducerEvent;
import org.joyqueue.nsr.event.AddTopicEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveProducerEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdateBrokerEvent;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.nsr.event.UpdateProducerEvent;
import org.joyqueue.nsr.event.UpdateTopicEvent;
import org.joyqueue.nsr.message.MessageListener;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.joyqueue.nsr.nameservice.MetadataCacheManager;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceCacheEventListener
implements MessageListener<MetaEvent> {
    protected static final Logger logger = LoggerFactory.getLogger(NameServiceCacheEventListener.class);
    private NameServiceConfig config;
    private EventBus<NameServerEvent> eventBus;
    private MetadataCacheManager metadataCacheManager;

    public NameServiceCacheEventListener(NameServiceConfig config, EventBus<NameServerEvent> eventBus, MetadataCacheManager metadataCacheManager) {
        this.config = config;
        this.eventBus = eventBus;
        this.metadataCacheManager = metadataCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(MetaEvent event) {
        if (!this.metadataCacheManager.tryLock()) {
            this.metadataCacheManager.updateTimestamp();
            return;
        }
        try {
            AllMetadataCache newCache = this.metadataCacheManager.getCache().clone();
            boolean updateCache = this.doUpdateCache(event, newCache);
            if (!updateCache) {
                return;
            }
            this.doOnEvent(event);
            this.metadataCacheManager.fillCache(newCache);
            this.metadataCacheManager.updateTimestamp();
        }
        finally {
            this.metadataCacheManager.unlock();
        }
    }

    protected boolean doUpdateCache(MetaEvent event, AllMetadataCache cache) {
        switch (event.getEventType()) {
            case ADD_TOPIC: {
                AddTopicEvent addTopicEvent = (AddTopicEvent)event;
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(addTopicEvent.getTopic().getName());
                if (oldTopicConfig != null) {
                    logger.warn("topic cache is exist, topic: {}", (Object)addTopicEvent.getTopic().getName());
                    break;
                }
                TopicConfig topicConfig = TopicConfig.toTopicConfig((Topic)addTopicEvent.getTopic(), addTopicEvent.getPartitionGroups());
                cache.getTopicConfigMap().put(topicConfig.getName(), topicConfig);
                cache.getAllTopicConfigs().add(topicConfig);
                cache.getAllTopicCodes().add(topicConfig.getName().getFullName());
                for (PartitionGroup partitionGroup : addTopicEvent.getPartitionGroups()) {
                    for (Integer replica : partitionGroup.getReplicas()) {
                        HashMap topicConfigBrokerMap = cache.getTopicConfigBrokerMap().get(replica);
                        if (topicConfigBrokerMap == null) {
                            topicConfigBrokerMap = Maps.newHashMap();
                            cache.getTopicConfigBrokerMap().put(replica, topicConfigBrokerMap);
                        }
                        topicConfigBrokerMap.put(topicConfig.getName(), topicConfig);
                    }
                }
                break;
            }
            case UPDATE_TOPIC: {
                UpdateTopicEvent updateTopicEvent = (UpdateTopicEvent)event;
                Topic newTopic = updateTopicEvent.getNewTopic();
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(newTopic.getName());
                if (oldTopicConfig == null) {
                    logger.warn("topic cache not exist, topic: {}", (Object)newTopic.getName());
                    break;
                }
                oldTopicConfig.setName(newTopic.getName());
                oldTopicConfig.setPartitions(newTopic.getPartitions());
                oldTopicConfig.setPriorityPartitions(newTopic.getPriorityPartitions());
                oldTopicConfig.setType(newTopic.getType());
                break;
            }
            case REMOVE_TOPIC: {
                RemoveTopicEvent removeTopicEvent = (RemoveTopicEvent)event;
                Topic topic = removeTopicEvent.getTopic();
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(topic.getName());
                if (oldTopicConfig == null) {
                    logger.warn("topic cache not found, topic: {}", (Object)topic.getName());
                    break;
                }
                cache.getTopicConfigMap().remove(oldTopicConfig);
                cache.getAllTopicConfigs().remove(oldTopicConfig);
                cache.getAllTopicCodes().remove(oldTopicConfig);
                for (Map.Entry partitionGroupEntry : oldTopicConfig.getPartitionGroups().entrySet()) {
                    for (Integer replica : ((PartitionGroup)partitionGroupEntry.getValue()).getReplicas()) {
                        Map<TopicName, TopicConfig> brokerTopicConfigMap = cache.getTopicConfigBrokerMap().get(replica);
                        if (brokerTopicConfigMap == null) continue;
                        brokerTopicConfigMap.remove(topic.getName());
                    }
                }
                break;
            }
            case ADD_PARTITION_GROUP: {
                AddPartitionGroupEvent addPartitionGroupEvent = (AddPartitionGroupEvent)event;
                PartitionGroup partitionGroup = addPartitionGroupEvent.getPartitionGroup();
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(partitionGroup.getTopic());
                if (oldTopicConfig == null) {
                    logger.warn("topic cache not exist, topic: {}", (Object)partitionGroup.getTopic());
                    break;
                }
                HashMap topicPartitionGroups = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                topicPartitionGroups.put(partitionGroup.getGroup(), partitionGroup);
                oldTopicConfig.setPartitionGroups((Map)topicPartitionGroups);
                for (Integer replica : partitionGroup.getReplicas()) {
                    HashMap topicConfigBrokerMap = cache.getTopicConfigBrokerMap().get(replica);
                    if (topicConfigBrokerMap == null) {
                        topicConfigBrokerMap = Maps.newHashMap();
                        cache.getTopicConfigBrokerMap().put(replica, topicConfigBrokerMap);
                    }
                    topicConfigBrokerMap.put(oldTopicConfig.getName(), oldTopicConfig);
                }
                break;
            }
            case UPDATE_PARTITION_GROUP: {
                Map<Object, Object> brokerTopicConfigMap;
                UpdatePartitionGroupEvent updatePartitionGroupEvent = (UpdatePartitionGroupEvent)event;
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(updatePartitionGroupEvent.getTopic());
                if (oldTopicConfig == null) {
                    logger.warn("topic cache not exist, topic: {}", (Object)updatePartitionGroupEvent.getTopic());
                    break;
                }
                PartitionGroup oldPartitionGroup = updatePartitionGroupEvent.getOldPartitionGroup();
                if (MapUtils.isEmpty((Map)oldTopicConfig.getPartitionGroups()) || !oldPartitionGroup.equals(oldTopicConfig.getPartitionGroups().get(oldPartitionGroup.getGroup()))) {
                    return false;
                }
                PartitionGroup newPartitionGroup = updatePartitionGroupEvent.getNewPartitionGroup();
                LinkedList removedReplica = Lists.newLinkedList();
                for (Integer oldReplica : oldPartitionGroup.getReplicas()) {
                    if (newPartitionGroup.getReplicas().contains(oldReplica)) continue;
                    removedReplica.add(oldReplica);
                }
                for (Integer newReplica : newPartitionGroup.getReplicas()) {
                    brokerTopicConfigMap = cache.getTopicConfigBrokerMap().get(newReplica);
                    if (brokerTopicConfigMap == null) {
                        brokerTopicConfigMap = Maps.newHashMap();
                        cache.getTopicConfigBrokerMap().put(newReplica, (Map<TopicName, TopicConfig>)brokerTopicConfigMap);
                    }
                    brokerTopicConfigMap.put(oldTopicConfig.getName(), oldTopicConfig);
                }
                for (Integer replica : removedReplica) {
                    brokerTopicConfigMap = cache.getTopicConfigBrokerMap().get(replica);
                    if (brokerTopicConfigMap == null) continue;
                    boolean isMatch = false;
                    for (Map.Entry entry : oldTopicConfig.getPartitionGroups().entrySet()) {
                        PartitionGroup partitionGroup = (PartitionGroup)entry.getValue();
                        if (partitionGroup.getGroup() == newPartitionGroup.getGroup() || !partitionGroup.getReplicas().contains(replica)) continue;
                        isMatch = true;
                        break;
                    }
                    if (isMatch) continue;
                    brokerTopicConfigMap.remove(oldTopicConfig.getName());
                }
                HashMap partitionGroupMap = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                partitionGroupMap.put(newPartitionGroup.getGroup(), newPartitionGroup);
                oldTopicConfig.setPartitionGroups((Map)partitionGroupMap);
                break;
            }
            case REMOVE_PARTITION_GROUP: {
                RemovePartitionGroupEvent removePartitionGroupEvent = (RemovePartitionGroupEvent)event;
                TopicConfig oldTopicConfig = cache.getTopicConfigMap().get(removePartitionGroupEvent.getTopic());
                if (oldTopicConfig == null) {
                    logger.warn("topic cache not exist, topic: {}", (Object)removePartitionGroupEvent.getTopic());
                    break;
                }
                PartitionGroup partitionGroup = removePartitionGroupEvent.getPartitionGroup();
                for (Integer replica : partitionGroup.getReplicas()) {
                    Map<TopicName, TopicConfig> brokerTopicConfigMap = cache.getTopicConfigBrokerMap().get(replica);
                    if (brokerTopicConfigMap == null) continue;
                    boolean isMatch = false;
                    for (Map.Entry entry : oldTopicConfig.getPartitionGroups().entrySet()) {
                        if (((PartitionGroup)entry.getValue()).getGroup() == partitionGroup.getGroup() || !partitionGroup.getReplicas().contains(replica)) continue;
                        isMatch = true;
                        break;
                    }
                    if (isMatch) continue;
                    brokerTopicConfigMap.remove(oldTopicConfig.getName());
                }
                HashMap partitionGroupMap = Maps.newHashMap((Map)oldTopicConfig.getPartitionGroups());
                partitionGroupMap.remove(partitionGroup.getGroup());
                oldTopicConfig.setPartitionGroups((Map)partitionGroupMap);
                break;
            }
            case ADD_PRODUCER: {
                AddProducerEvent addProducerEvent = (AddProducerEvent)event;
                TopicName topic = addProducerEvent.getTopic();
                Producer producer = addProducerEvent.getProducer();
                HashMap topicProducerMap = cache.getProducerTopicMap().get(topic);
                if (topicProducerMap == null) {
                    topicProducerMap = Maps.newHashMap();
                    cache.getProducerTopicMap().put(topic, topicProducerMap);
                }
                topicProducerMap.put(producer.getApp(), producer);
                HashMap appProducerMap = cache.getProducerAppMap().get(producer.getApp());
                if (appProducerMap == null) {
                    appProducerMap = Maps.newHashMap();
                    cache.getProducerAppMap().put(producer.getApp(), appProducerMap);
                }
                appProducerMap.put(topic, producer);
                cache.getAllProducers().add(producer);
                break;
            }
            case UPDATE_PRODUCER: {
                UpdateProducerEvent updateProducerEvent = (UpdateProducerEvent)event;
                TopicName topic = updateProducerEvent.getTopic();
                Producer producer = updateProducerEvent.getNewProducer();
                HashMap topicProducerMap = cache.getProducerTopicMap().get(topic);
                if (topicProducerMap == null) {
                    topicProducerMap = Maps.newHashMap();
                    cache.getProducerTopicMap().put(topic, topicProducerMap);
                }
                topicProducerMap.put(producer.getApp(), producer);
                HashMap appProducerMap = cache.getProducerAppMap().get(producer.getApp());
                if (appProducerMap == null) {
                    appProducerMap = Maps.newHashMap();
                    cache.getProducerAppMap().put(producer.getApp(), appProducerMap);
                }
                appProducerMap.put(topic, producer);
                cache.getAllProducers().remove(producer);
                cache.getAllProducers().add(producer);
                break;
            }
            case REMOVE_PRODUCER: {
                Map<TopicName, Producer> appProducerMap;
                RemoveProducerEvent removeProducerEvent = (RemoveProducerEvent)event;
                TopicName topic = removeProducerEvent.getTopic();
                Producer producer = removeProducerEvent.getProducer();
                Map<String, Producer> topicProducerMap = cache.getProducerTopicMap().get(topic);
                if (topicProducerMap != null) {
                    topicProducerMap.remove(producer.getApp());
                }
                if ((appProducerMap = cache.getProducerAppMap().get(producer.getApp())) != null) {
                    appProducerMap.remove(producer.getApp());
                }
                cache.getAllProducers().remove(producer);
                break;
            }
            case ADD_CONSUMER: {
                AddConsumerEvent addConsumerEvent = (AddConsumerEvent)event;
                TopicName topic = addConsumerEvent.getTopic();
                Consumer consumer = addConsumerEvent.getConsumer();
                HashMap topicConsumerMap = cache.getConsumerTopicMap().get(topic);
                if (topicConsumerMap == null) {
                    topicConsumerMap = Maps.newHashMap();
                    cache.getConsumerTopicMap().put(topic, topicConsumerMap);
                }
                topicConsumerMap.put(consumer.getApp(), consumer);
                HashMap appConsumerMap = cache.getConsumerAppMap().get(consumer.getApp());
                if (appConsumerMap == null) {
                    appConsumerMap = Maps.newHashMap();
                    cache.getConsumerAppMap().put(consumer.getApp(), appConsumerMap);
                }
                appConsumerMap.put(topic, consumer);
                cache.getAllConsumers().add(consumer);
                break;
            }
            case UPDATE_CONSUMER: {
                UpdateConsumerEvent updateConsumerEvent = (UpdateConsumerEvent)event;
                TopicName topic = updateConsumerEvent.getTopic();
                Consumer consumer = updateConsumerEvent.getNewConsumer();
                HashMap topicConsumerMap = cache.getConsumerTopicMap().get(topic);
                if (topicConsumerMap == null) {
                    topicConsumerMap = Maps.newHashMap();
                    cache.getConsumerTopicMap().put(topic, topicConsumerMap);
                }
                topicConsumerMap.put(consumer.getApp(), consumer);
                HashMap appConsumerMap = cache.getConsumerAppMap().get(consumer.getApp());
                if (appConsumerMap == null) {
                    appConsumerMap = Maps.newHashMap();
                    cache.getConsumerAppMap().put(consumer.getApp(), appConsumerMap);
                }
                appConsumerMap.put(topic, consumer);
                cache.getAllConsumers().remove(consumer);
                cache.getAllConsumers().add(consumer);
                break;
            }
            case REMOVE_CONSUMER: {
                Map<TopicName, Consumer> appConsumerMap;
                RemoveConsumerEvent removeConsumerEvent = (RemoveConsumerEvent)event;
                TopicName topic = removeConsumerEvent.getTopic();
                Consumer consumer = removeConsumerEvent.getConsumer();
                Map<String, Consumer> topicConsumerMap = cache.getConsumerTopicMap().get(topic);
                if (topicConsumerMap != null) {
                    topicConsumerMap.remove(consumer.getApp());
                }
                if ((appConsumerMap = cache.getConsumerAppMap().get(consumer.getApp())) != null) {
                    appConsumerMap.remove(topic);
                }
                cache.getAllConsumers().remove(consumer);
                break;
            }
            case UPDATE_BROKER: {
                UpdateBrokerEvent updateBrokerEvent = (UpdateBrokerEvent)event;
                Broker newBroker = updateBrokerEvent.getNewBroker();
                cache.getBrokerMap().put(newBroker.getId(), newBroker);
                break;
            }
        }
        return true;
    }

    protected void doOnEvent(MetaEvent event) {
        NameServerEvent nameServerEvent = new NameServerEvent();
        nameServerEvent.setMetaEvent(event);
        nameServerEvent.setEventType(event.getEventType());
        this.eventBus.inform((Object)nameServerEvent);
    }
}

