/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.alibaba.fastjson.JSON;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.nameservice.AllMetadataCache;
import org.joyqueue.nsr.nameservice.MetadataCacheManager;
import org.joyqueue.nsr.nameservice.MetadataCompensator;
import org.joyqueue.nsr.nameservice.MetadataValidator;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceCompensateThread
extends Service
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(NameServiceCompensateThread.class);
    private NameServiceConfig config;
    private NameService delegate;
    private MetadataCacheManager metadataCacheManager;
    private MetadataCompensator metadataCompensator;
    private MetadataValidator metadataValidator;
    private Thread compensationThread;
    private volatile boolean started = false;

    public NameServiceCompensateThread(NameServiceConfig config, NameService delegate, MetadataCacheManager metadataCacheManager, MetadataCompensator metadataCompensator) {
        this.config = config;
        this.delegate = delegate;
        this.metadataCacheManager = metadataCacheManager;
        this.metadataCompensator = metadataCompensator;
    }

    protected void validate() throws Exception {
        this.metadataValidator = new MetadataValidator(this.config);
        this.compensationThread = new Thread((Runnable)this, "joyqueue-nameservice-compensation");
        this.compensationThread.setDaemon(true);
    }

    protected void doStart() throws Exception {
        this.started = true;
        this.compensationThread.start();
    }

    protected void doStop() {
        this.started = false;
    }

    @Override
    public void run() {
        while (this.started) {
            try {
                this.doCompensate();
            }
            catch (Exception e) {
                logger.error("compensate exception", (Throwable)e);
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.config.getCompensationInterval());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCompensate() {
        if (!this.config.getCompensationEnable()) {
            return;
        }
        if (this.metadataCacheManager.getCache() == null) {
            AllMetadata allMetadata = this.delegate.getAllMetadata();
            AllMetadataCache newCache = this.metadataCacheManager.buildCache(allMetadata);
            if (logger.isDebugEnabled()) {
                logger.debug("doCompensate, newCache: {}, metadata: {}", (Object)JSON.toJSONString((Object)newCache), (Object)JSON.toJSONString((Object)allMetadata));
            }
            this.metadataCacheManager.fillCache(newCache);
            this.metadataCacheManager.flushCache();
        } else {
            if (this.metadataCompensator.getBrokerId() < 0) {
                return;
            }
            if (!this.metadataCacheManager.tryLock()) {
                return;
            }
            try {
                boolean isFlush = true;
                AllMetadata allMetadata = null;
                AllMetadataCache newCache = null;
                AllMetadataCache oldCache = this.metadataCacheManager.getCache();
                long version = this.metadataCacheManager.getTimestamp();
                if (SystemClock.now() - version < (long)this.config.getAllMetadataInterval()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("doCompensate, interval less than threshold, last: {}, threshold: {}", (Object)version, (Object)this.config.getAllMetadataInterval());
                    }
                    return;
                }
                for (int i = 0; i <= this.config.getCompensationRetryTimes(); ++i) {
                    long currentVersion;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doCompensate pre, oldCache: {}", (Object)JSON.toJSONString((Object)oldCache));
                    }
                    try {
                        allMetadata = this.delegate.getAllMetadata();
                    }
                    catch (Exception e) {
                        logger.error("getAllMetadata exception", (Throwable)e);
                        continue;
                    }
                    newCache = this.metadataCacheManager.buildCache(allMetadata);
                    if (logger.isDebugEnabled()) {
                        logger.debug("doCompensate, oldCache: {}, newCache: {}, metadata: {}", new Object[]{JSON.toJSONString((Object)oldCache), JSON.toJSONString((Object)newCache), JSON.toJSONString((Object)allMetadata)});
                    }
                    if (!this.metadataValidator.validateChange(oldCache, newCache)) {
                        logger.error("doCompensate validate error");
                        if (logger.isDebugEnabled()) {
                            logger.debug("doCompensate validate error, oldCache: {}, newCache: {}", (Object)oldCache, (Object)newCache);
                        }
                        isFlush = false;
                        break;
                    }
                    if (this.config.getCompensationEnable()) {
                        this.metadataCompensator.compensate(oldCache, newCache);
                    }
                    if (version == (currentVersion = this.metadataCacheManager.getTimestamp())) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("doCompensate retry, oldVersion: {}, currentVersion: {}", (Object)version, (Object)currentVersion);
                    }
                    version = currentVersion;
                    oldCache = newCache;
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.config.getCompensationRetryInterval());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (newCache != null && isFlush) {
                    this.metadataCacheManager.fillCache(newCache);
                    this.metadataCacheManager.flushCache();
                }
            }
            finally {
                this.metadataCacheManager.unlock();
            }
        }
    }
}

