/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.jd.laf.extension.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.config.NameServerConfig;
import org.joyqueue.nsr.nameservice.ThinNameService;
import org.joyqueue.nsr.network.NsrTransportServerFactory;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.service.Service;

public class ThinNameServer
extends Service
implements NameService,
PropertySupplierAware,
Type {
    private ThinNameService delegate = new ThinNameService();
    private NameServerConfig nameServerConfig;
    private NsrTransportServerFactory transportServerFactory;
    private TransportServer transportServer;

    @Override
    public TopicConfig subscribe(Subscription subscription, ClientType clientType) {
        return this.delegate.subscribe(subscription, clientType);
    }

    @Override
    public List<TopicConfig> subscribe(List<Subscription> subscriptions, ClientType clientType) {
        return this.delegate.subscribe(subscriptions, clientType);
    }

    @Override
    public void unSubscribe(Subscription subscription) {
        this.delegate.unSubscribe(subscription);
    }

    @Override
    public void unSubscribe(List<Subscription> subscriptions) {
        this.delegate.unSubscribe(subscriptions);
    }

    @Override
    public boolean hasSubscribe(String app, Subscription.Type subscribe) {
        return this.delegate.hasSubscribe(app, subscribe);
    }

    @Override
    public void leaderReport(TopicName topic, int partitionGroup, int leaderBrokerId, Set<Integer> isrId, int termId) {
        this.delegate.leaderReport(topic, partitionGroup, leaderBrokerId, isrId, termId);
    }

    @Override
    public Broker getBroker(int brokerId) {
        return this.delegate.getBroker(brokerId);
    }

    @Override
    public List<Broker> getAllBrokers() {
        return this.delegate.getAllBrokers();
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        this.delegate.addTopic(topic, partitionGroups);
    }

    @Override
    public TopicConfig getTopicConfig(TopicName topic) {
        return this.delegate.getTopicConfig(topic);
    }

    @Override
    public Set<String> getAllTopicCodes() {
        return this.delegate.getAllTopicCodes();
    }

    @Override
    public Set<String> getTopics(String app, Subscription.Type subscription) {
        return this.delegate.getTopics(app, subscription);
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        return this.delegate.getTopicConfigByBroker(brokerId);
    }

    @Override
    public Broker register(Integer brokerId, String brokerIp, Integer port) {
        return this.delegate.register(brokerId, brokerIp, port);
    }

    @Override
    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        return this.delegate.getProducerByTopicAndApp(topic, app);
    }

    @Override
    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        return this.delegate.getConsumerByTopicAndApp(topic, app);
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByApp(String app, Subscription.Type subscribe) {
        return this.delegate.getTopicConfigByApp(app, subscribe);
    }

    @Override
    public DataCenter getDataCenter(String ip) {
        return this.delegate.getDataCenter(ip);
    }

    @Override
    public String getConfig(String group, String key) {
        return this.delegate.getConfig(group, key);
    }

    @Override
    public List<Config> getAllConfigs() {
        return this.delegate.getAllConfigs();
    }

    @Override
    public List<Broker> getBrokerByRetryType(String retryType) {
        return this.delegate.getBrokerByRetryType(retryType);
    }

    @Override
    public List<Consumer> getConsumerByTopic(TopicName topic) {
        return this.delegate.getConsumerByTopic(topic);
    }

    @Override
    public List<Producer> getProducerByTopic(TopicName topic) {
        return this.delegate.getProducerByTopic(topic);
    }

    @Override
    public List<Replica> getReplicaByBroker(Integer brokerId) {
        return this.delegate.getReplicaByBroker(brokerId);
    }

    @Override
    public AppToken getAppToken(String app, String token) {
        return this.delegate.getAppToken(app, token);
    }

    @Override
    public AllMetadata getAllMetadata() {
        return this.delegate.getAllMetadata();
    }

    @Override
    public void addListener(EventListener<NameServerEvent> listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<NameServerEvent> listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void addEvent(NameServerEvent event) {
        this.delegate.addEvent(event);
    }

    public void setSupplier(PropertySupplier supplier) {
        this.delegate.setSupplier(supplier);
        this.nameServerConfig = new NameServerConfig(supplier);
        this.transportServerFactory = new NsrTransportServerFactory(this, supplier);
        this.transportServer = this.buildTransportServer();
    }

    public void start() throws Exception {
        this.delegate.start();
        this.transportServer.start();
    }

    public void stop() {
        this.transportServer.stop();
        this.delegate.stop();
    }

    protected TransportServer buildTransportServer() {
        ServerConfig serverConfig = this.nameServerConfig.getServerConfig();
        serverConfig.setPort(this.nameServerConfig.getServicePort());
        serverConfig.setAcceptThreadName("joyqueue-nameserver-accept-eventLoop");
        serverConfig.setIoThreadName("joyqueue-nameserver-io-eventLoop");
        return this.transportServerFactory.bind(serverConfig, serverConfig.getHost(), serverConfig.getPort());
    }

    public Object type() {
        return "thin-server";
    }
}

