/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.nameservice;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.jd.laf.extension.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Config;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.monitor.TraceStat;
import org.joyqueue.network.command.GetTopics;
import org.joyqueue.network.command.GetTopicsAck;
import org.joyqueue.network.command.Subscribe;
import org.joyqueue.network.command.SubscribeAck;
import org.joyqueue.network.command.UnSubscribe;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.NsrPlugins;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.network.NsrTransportClientFactory;
import org.joyqueue.nsr.network.command.AddTopic;
import org.joyqueue.nsr.network.command.GetAllBrokers;
import org.joyqueue.nsr.network.command.GetAllBrokersAck;
import org.joyqueue.nsr.network.command.GetAllConfigs;
import org.joyqueue.nsr.network.command.GetAllConfigsAck;
import org.joyqueue.nsr.network.command.GetAllMetadataRequest;
import org.joyqueue.nsr.network.command.GetAllMetadataResponse;
import org.joyqueue.nsr.network.command.GetAllTopics;
import org.joyqueue.nsr.network.command.GetAllTopicsAck;
import org.joyqueue.nsr.network.command.GetAppToken;
import org.joyqueue.nsr.network.command.GetAppTokenAck;
import org.joyqueue.nsr.network.command.GetBroker;
import org.joyqueue.nsr.network.command.GetBrokerAck;
import org.joyqueue.nsr.network.command.GetBrokerByRetryType;
import org.joyqueue.nsr.network.command.GetBrokerByRetryTypeAck;
import org.joyqueue.nsr.network.command.GetConfig;
import org.joyqueue.nsr.network.command.GetConfigAck;
import org.joyqueue.nsr.network.command.GetConsumerByTopic;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAck;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAndApp;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAndAppAck;
import org.joyqueue.nsr.network.command.GetDataCenter;
import org.joyqueue.nsr.network.command.GetDataCenterAck;
import org.joyqueue.nsr.network.command.GetProducerByTopic;
import org.joyqueue.nsr.network.command.GetProducerByTopicAck;
import org.joyqueue.nsr.network.command.GetProducerByTopicAndApp;
import org.joyqueue.nsr.network.command.GetProducerByTopicAndAppAck;
import org.joyqueue.nsr.network.command.GetReplicaByBroker;
import org.joyqueue.nsr.network.command.GetReplicaByBrokerAck;
import org.joyqueue.nsr.network.command.GetTopicConfig;
import org.joyqueue.nsr.network.command.GetTopicConfigAck;
import org.joyqueue.nsr.network.command.GetTopicConfigByApp;
import org.joyqueue.nsr.network.command.GetTopicConfigByAppAck;
import org.joyqueue.nsr.network.command.GetTopicConfigByBroker;
import org.joyqueue.nsr.network.command.GetTopicConfigByBrokerAck;
import org.joyqueue.nsr.network.command.HasSubscribe;
import org.joyqueue.nsr.network.command.HasSubscribeAck;
import org.joyqueue.nsr.network.command.LeaderReport;
import org.joyqueue.nsr.network.command.NsrConnection;
import org.joyqueue.nsr.network.command.Register;
import org.joyqueue.nsr.network.command.RegisterAck;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThinNameService
extends Service
implements NameService,
PropertySupplierAware,
Type {
    private static final Logger logger = LoggerFactory.getLogger(ThinNameService.class);
    private NameServiceConfig nameServiceConfig;
    private PointTracer tracer;
    private ClientTransport clientTransport;
    private PropertySupplier propertySupplier;
    private Broker broker;
    protected EventBus<NameServerEvent> eventBus = new EventBus("joyqueue-thin-nameservice-eventBus");
    private Cache<TopicName, Optional<TopicConfig>> topicCache;

    public ThinNameService() {
    }

    public ThinNameService(NameServiceConfig nameServiceConfig) {
        this.nameServiceConfig = nameServiceConfig;
    }

    public void setSupplier(PropertySupplier supplier) {
        this.propertySupplier = supplier;
        if (this.nameServiceConfig == null) {
            this.nameServiceConfig = new NameServiceConfig(this.propertySupplier);
        }
        if (this.topicCache == null) {
            this.topicCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.nameServiceConfig.getThinCacheExpireTime(), TimeUnit.MILLISECONDS).build();
        }
        this.tracer = (PointTracer)NsrPlugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
        this.clientTransport = new ClientTransport(this.nameServiceConfig, this);
        try {
            this.eventBus.start();
            this.clientTransport.start();
        }
        catch (Exception e) {
            throw new NsrException(e);
        }
    }

    @Override
    public TopicConfig subscribe(Subscription subscription, ClientType clientType) {
        List<TopicConfig> topicConfigs = this.subscribe(Lists.newArrayList((Object[])new Subscription[]{subscription}), clientType);
        if (CollectionUtils.isEmpty(topicConfigs)) {
            return null;
        }
        return topicConfigs.get(0);
    }

    @Override
    public List<TopicConfig> subscribe(List<Subscription> subscriptions, ClientType clientType) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 100), (Object)new Subscribe().subscriptions(subscriptions).clientType(clientType));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("subscribe error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("subscribe error request {},response {}", request, response));
        }
        return ((SubscribeAck)response.getPayload()).getTopicConfigs();
    }

    @Override
    public void unSubscribe(Subscription subscription) {
        this.unSubscribe(Lists.newArrayList((Object[])new Subscription[]{subscription}));
    }

    @Override
    public void unSubscribe(List<Subscription> subscriptions) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 101), (Object)new UnSubscribe().subscriptions(subscriptions));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("unSubscribe error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("unSubscribe error request {},response {}", request, response));
        }
    }

    @Override
    public boolean hasSubscribe(String app, Subscription.Type subscribe) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 7), (Object)new HasSubscribe().app(app).subscribe(subscribe));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("hasSubscribe error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("hasSubscribe error request {},response {}", request, response));
        }
        return ((HasSubscribeAck)((Object)response.getPayload())).isHave();
    }

    @Override
    public void leaderReport(final TopicName topic, final int partitionGroup, int leaderBrokerId, Set<Integer> isrId, int termId) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 6), (Object)new LeaderReport().topic(topic).partitionGroup(partitionGroup).leaderBrokerId(leaderBrokerId).isrId(isrId).termId(termId));
        this.sendAsync(request, new CommandCallback(){

            public void onSuccess(Command request, Command response) {
                logger.info("Report leader of topic {} partition group {} to nameserver success", (Object)topic, (Object)partitionGroup);
            }

            public void onException(Command request, Throwable cause) {
                logger.info("Report leader of topic {} partition group {} to nameserver fail", new Object[]{topic, partitionGroup, cause});
            }
        });
    }

    @Override
    public Broker getBroker(int brokerId) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 8), (Object)new GetBroker().brokerId(brokerId));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getBroker error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getBroker error request {},response {}", request, response));
        }
        return ((GetBrokerAck)((Object)response.getPayload())).getBroker();
    }

    @Override
    public List<Broker> getAllBrokers() {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 9), (Object)new GetAllBrokers());
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getAllBrokers error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getAllBrokers error request {},response {}", request, response));
        }
        return ((GetAllBrokersAck)((Object)response.getPayload())).getBrokers();
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 27), (Object)new AddTopic().topic(topic).partitiionGroups(partitionGroups));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("leaderReport error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("leaderReport error request {},response {}", request, response));
        }
    }

    @Override
    public TopicConfig getTopicConfig(final TopicName topic) {
        if (this.nameServiceConfig.getThinCacheEnable()) {
            try {
                Optional optional = (Optional)this.topicCache.get((Object)topic, (Callable)new Callable<Optional<TopicConfig>>(){

                    @Override
                    public Optional<TopicConfig> call() throws Exception {
                        return Optional.ofNullable(ThinNameService.this.doGetTopicConfig(topic));
                    }
                });
                if (optional.isPresent()) {
                    return (TopicConfig)optional.get();
                }
                return null;
            }
            catch (ExecutionException e) {
                logger.error("getTopicConfig exception, topic: {}", (Object)topic, (Object)e);
                return null;
            }
        }
        return this.doGetTopicConfig(topic);
    }

    protected TopicConfig doGetTopicConfig(TopicName topic) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 10), (Object)new GetTopicConfig().topic(topic));
        Command response = this.send(request, this.nameServiceConfig.getThinTransportTopicTimeout());
        if (!response.isSuccess()) {
            logger.error("getTopicConfig error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopicConfig error request {},response {}", request, response));
        }
        TopicConfig topicConfig = ((GetTopicConfigAck)((Object)response.getPayload())).getTopicConfig();
        return topicConfig;
    }

    @Override
    public Set<String> getAllTopicCodes() {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 11), (Object)new GetAllTopics());
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getAllTopicCodes error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getAllTopicCodes error request {},response {}", request, response));
        }
        return ((GetAllTopicsAck)((Object)response.getPayload())).getTopicNames();
    }

    @Override
    public Set<String> getTopics(String app, Subscription.Type subscription) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 41), (Object)new GetTopics().app(app).subscribeType((int)subscription.getValue()));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getTopics error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopics error request {},response {}", request, response));
        }
        return ((GetTopicsAck)response.getPayload()).getTopics();
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByBroker(Integer brokerId) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 13), (Object)new GetTopicConfigByBroker().brokerId(brokerId));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getTopicConfigByBroker error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopicConfigByBroker error request {},response {}", request, response));
        }
        return ((GetTopicConfigByBrokerAck)((Object)response.getPayload())).getTopicConfigs();
    }

    @Override
    public Broker register(Integer brokerId, String brokerIp, Integer port) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 14), (Object)new Register().brokerId(brokerId).brokerIp(brokerIp).port(port));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("register error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopicConfigByBroker error request {},response {}", request, response));
        }
        this.broker = ((RegisterAck)((Object)response.getPayload())).getBroker();
        return this.broker;
    }

    @Override
    public Producer getProducerByTopicAndApp(TopicName topic, String app) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 15), (Object)new GetProducerByTopicAndApp().topic(topic).app(app));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getProducerByTopicAndApp error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getProducerByTopicAndApp error request {},response {}", request, response));
        }
        return ((GetProducerByTopicAndAppAck)((Object)response.getPayload())).getProducer();
    }

    @Override
    public Consumer getConsumerByTopicAndApp(TopicName topic, String app) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 16), (Object)new GetConsumerByTopicAndApp().topic(topic).app(app));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getConsumerByTopicAndApp error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getConsumerByTopicAndApp error request {},response {}", request, response));
        }
        return ((GetConsumerByTopicAndAppAck)((Object)response.getPayload())).getConsumer();
    }

    @Override
    public Map<TopicName, TopicConfig> getTopicConfigByApp(String app, Subscription.Type subscribe) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 17), (Object)new GetTopicConfigByApp().subscribe(subscribe).app(app));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getTopicConfigByApp error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopicConfigByApp error request {},response {}", request, response));
        }
        return ((GetTopicConfigByAppAck)((Object)response.getPayload())).getTopicConfigs();
    }

    @Override
    public DataCenter getDataCenter(String ip) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 18), (Object)new GetDataCenter().ip(ip));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getTopicConfigByApp error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getTopicConfigByApp error request {},response {}", request, response));
        }
        return ((GetDataCenterAck)((Object)response.getPayload())).getDataCenter();
    }

    @Override
    public String getConfig(String group, String key) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 19), (Object)new GetConfig().group(group).key(key));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getConfig error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getConfig error request {},response {}", request, response));
        }
        return ((GetConfigAck)((Object)response.getPayload())).getValue();
    }

    @Override
    public List<Config> getAllConfigs() {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 20), (Object)new GetAllConfigs());
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getAllConfigs error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getAllConfigs error request {},response {}", request, response));
        }
        return ((GetAllConfigsAck)((Object)response.getPayload())).getConfigs();
    }

    @Override
    public List<Broker> getBrokerByRetryType(String retryType) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 21), (Object)new GetBrokerByRetryType().retryType(retryType));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getBrokerByRetryType error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getBrokerByRetryType error request {},response {}", request, response));
        }
        return ((GetBrokerByRetryTypeAck)((Object)response.getPayload())).getBrokers();
    }

    @Override
    public List<Consumer> getConsumerByTopic(TopicName topic) {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 22), (Object)new GetConsumerByTopic().topic(topic));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getConsumerByTopic error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getConsumerByTopic error request {},response {}", request, response));
        }
        List<Consumer> topicConsumes = ((GetConsumerByTopicAck)((Object)response.getPayload())).getConsumers();
        if (null != topicConsumes) {
            consumers.addAll(topicConsumes);
        }
        return consumers;
    }

    @Override
    public List<Producer> getProducerByTopic(TopicName topic) {
        ArrayList<Producer> producers = new ArrayList<Producer>();
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 23), (Object)new GetProducerByTopic().topic(topic));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getProducerByTopic error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getProducerByTopic error request {},response {}", request, response));
        }
        List<Producer> topicProducers = ((GetProducerByTopicAck)((Object)response.getPayload())).getProducers();
        if (null != topicProducers) {
            producers.addAll(topicProducers);
        }
        return producers;
    }

    @Override
    public List<Replica> getReplicaByBroker(Integer brokerId) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 24), (Object)new GetReplicaByBroker().brokerId(brokerId));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getReplicaByBroker error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getReplicaByBroker error request {},response {}", request, response));
        }
        return ((GetReplicaByBrokerAck)((Object)response.getPayload())).getReplicas();
    }

    @Override
    public AppToken getAppToken(String app, String token) {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 25), (Object)new GetAppToken().app(app).token(token));
        Command response = this.send(request);
        if (!response.isSuccess()) {
            logger.error("getAppToken error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getAppToken error request {},response {}", request, response));
        }
        return ((GetAppTokenAck)((Object)response.getPayload())).getAppToken();
    }

    @Override
    public AllMetadata getAllMetadata() {
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 52), (Object)new GetAllMetadataRequest());
        Command response = this.send(request, this.nameServiceConfig.getAllMetadataTransportTimeout());
        if (!response.isSuccess()) {
            logger.error("getAllMetadata error request {},response {}", (Object)request, (Object)response);
            throw new RuntimeException(String.format("getAppToken error request {},response {}", request, response));
        }
        return ((GetAllMetadataResponse)((Object)response.getPayload())).getMetadata();
    }

    @Override
    public void addListener(EventListener<NameServerEvent> listener) {
        this.eventBus.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<NameServerEvent> listener) {
        this.eventBus.removeListener(listener);
    }

    @Override
    public void addEvent(NameServerEvent event) {
        this.eventBus.add((Object)event);
    }

    protected void doStop() {
        super.doStop();
        Close.close((LifeCycle)this.clientTransport);
        Close.close(this.eventBus);
        logger.info("name service stopped.");
    }

    protected Command send(Command request) throws TransportException {
        return this.send(request, this.nameServiceConfig.getThinTransportTimeout());
    }

    protected Command send(Command request, int timeout) throws TransportException {
        if (this.tracer == null) {
            return this.doSend(request, timeout);
        }
        TraceStat traceBegin = this.tracer.begin("ThinNameService.send." + request.getPayload().getClass().getSimpleName());
        try {
            Command result = this.doSend(request, timeout);
            this.tracer.end(traceBegin);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(traceBegin);
            throw e;
        }
    }

    protected Command doSend(Command request, int timeout) throws TransportException {
        try {
            return this.clientTransport.getOrCreateTransport().sync(request, (long)timeout);
        }
        catch (TransportException exception) {
            logger.error("send command to nameServer error request {}", (Object)request);
            throw exception;
        }
    }

    private void sendAsync(Command request, CommandCallback callback) throws TransportException {
        this.sendAsync(request, this.nameServiceConfig.getThinTransportTimeout(), callback);
    }

    private void sendAsync(Command request, int timeout, CommandCallback callback) throws TransportException {
        TraceStat traceBegin = this.tracer.begin("ThinNameService.asyncSend." + request.getPayload().getClass().getSimpleName());
        try {
            this.clientTransport.getOrCreateTransport().async(request, (long)timeout, callback);
            this.tracer.end(traceBegin);
        }
        catch (TransportException exception) {
            logger.error("send command to nameServer error request {}", (Object)request);
            this.tracer.error(traceBegin);
            throw exception;
        }
    }

    private Command registerToNsr() throws TransportException {
        if (null == this.broker) {
            return null;
        }
        Command request = new Command((Header)new JoyQueueHeader(Direction.REQUEST, 0), (Object)new NsrConnection().brokerId(this.broker.getId()));
        return this.send(request);
    }

    public Object type() {
        return "thin";
    }

    private class ClientTransport
    implements LifeCycle {
        private AtomicBoolean started = new AtomicBoolean(false);
        private TransportClient transportClient;
        protected final AtomicReference<Transport> transports = new AtomicReference();

        ClientTransport(NameServiceConfig config, NameService nameService) {
            this.transportClient = new NsrTransportClientFactory(nameService, ThinNameService.this.propertySupplier).create(config.getClientConfig());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Transport getOrCreateTransport() throws TransportException {
            Transport transport = this.transports.get();
            if (transport == null) {
                ClientTransport clientTransport = this;
                synchronized (clientTransport) {
                    transport = this.transports.get();
                    if (transport == null) {
                        transport = this.transportClient.createTransport(ThinNameService.this.nameServiceConfig.getNameserverAddress());
                        this.transports.set(transport);
                        ThinNameService.this.registerToNsr();
                    }
                    logger.info("create transport connect to nameServer [{}]", (Object)ThinNameService.this.nameServiceConfig.getNameserverAddress());
                }
            }
            return transport;
        }

        public void start() throws Exception {
            if (this.started.compareAndSet(false, true)) {
                this.transportClient.start();
            }
        }

        public void stop() {
            this.started.set(false);
            this.transportClient.stop();
        }

        public boolean isStarted() {
            return this.started.get();
        }
    }
}

