/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network;

import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NsrExceptionHandler
implements ExceptionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(NsrExceptionHandler.class);

    public void handle(Transport transport, Command command, Throwable throwable) {
        if (TransportException.isClosed((Throwable)throwable)) {
            logger.warn("channel close, address: {}, message: {}", (Object)transport.remoteAddress(), (Object)throwable.getMessage());
        } else {
            logger.error("nameserver exception, transport: {}, command: {}", new Object[]{transport, command, throwable});
        }
        transport.stop();
    }
}

