/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network;

import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.support.DefaultTransportClientFactory;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.network.NsrCodecFactory;
import org.joyqueue.nsr.network.NsrCommandHandler;
import org.joyqueue.nsr.network.NsrCommandHandlerFactory;
import org.joyqueue.nsr.network.NsrExceptionHandler;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NsrTransportClientFactory
extends DefaultTransportClientFactory {
    private static NsrCommandHandlerFactory nsrCommandHandlerFactory = new NsrClientCommandHandlerFactory();

    public NsrTransportClientFactory() {
        this((CommandHandlerFactory)nsrCommandHandlerFactory);
    }

    public NsrTransportClientFactory(NameService nameService, PropertySupplier propertySupplier) {
        this((CommandHandlerFactory)nsrCommandHandlerFactory);
        nsrCommandHandlerFactory.register(nameService, propertySupplier);
    }

    public NsrTransportClientFactory(CommandHandlerFactory commandHandlerFactory) {
        this(commandHandlerFactory, new NsrExceptionHandler());
    }

    public NsrTransportClientFactory(CommandHandlerFactory commandHandlerFactory, ExceptionHandler exceptionHandler) {
        this(NsrCodecFactory.getInstance(), commandHandlerFactory, exceptionHandler);
    }

    public NsrTransportClientFactory(Codec codec) {
        super(codec);
    }

    public NsrTransportClientFactory(Codec codec, CommandHandlerFactory commandHandlerFactory) {
        super(codec, commandHandlerFactory);
    }

    public NsrTransportClientFactory(Codec codec, CommandHandlerFactory commandHandlerFactory, ExceptionHandler exceptionHandler) {
        super(codec, commandHandlerFactory, exceptionHandler);
    }

    static class NsrClientCommandHandlerFactory
    extends NsrCommandHandlerFactory {
        protected static final Logger logger = LoggerFactory.getLogger(NsrCommandHandlerFactory.class);

        NsrClientCommandHandlerFactory() {
        }

        @Override
        public String getType() {
            return "THIN";
        }

        @Override
        public void doWithHandler(NsrCommandHandler nsrCommandHandler) {
        }
    }
}

