/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network;

import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.support.DefaultTransportServerFactory;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.network.NsrCodecFactory;
import org.joyqueue.nsr.network.NsrCommandHandler;
import org.joyqueue.nsr.network.NsrCommandHandlerFactory;
import org.joyqueue.nsr.network.NsrExceptionHandler;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NsrTransportServerFactory
extends DefaultTransportServerFactory {
    private static NsrCommandHandlerFactory nsrCommandHandlerFactory = new NsrServerCommandHandlerFactory();
    protected static EventBus<TransportEvent> eventBus = new EventBus();

    public NsrTransportServerFactory(NameService nameService, PropertySupplier propertySupplier) {
        this(NsrCodecFactory.getInstance(), (CommandHandlerFactory)nsrCommandHandlerFactory, new NsrExceptionHandler(), eventBus);
        nsrCommandHandlerFactory.register(nameService, propertySupplier);
    }

    public NsrTransportServerFactory(Codec codec, CommandHandlerFactory commandHandlerFactory, ExceptionHandler exceptionHandler, EventBus<TransportEvent> eventBus) {
        super(codec, commandHandlerFactory, exceptionHandler, eventBus);
    }

    static class NsrServerCommandHandlerFactory
    extends NsrCommandHandlerFactory {
        protected static final Logger logger = LoggerFactory.getLogger(NsrCommandHandlerFactory.class);

        NsrServerCommandHandlerFactory() {
        }

        @Override
        public String getType() {
            return "SERVER";
        }

        @Override
        public void doWithHandler(NsrCommandHandler nsrCommandHandler) {
            if (nsrCommandHandler instanceof EventListener) {
                eventBus.addListener((EventListener)nsrCommandHandler);
            }
        }
    }
}

