/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Topic;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.AddTopic;

public class AddTopicCodec
implements NsrPayloadCodec<AddTopic>,
Type {
    public AddTopic decode(Header header, ByteBuf buffer) throws Exception {
        AddTopic addTopic = new AddTopic();
        addTopic.topic(Serializer.readTopic((ByteBuf)buffer));
        int size = buffer.readInt();
        ArrayList<PartitionGroup> partitionGroups = new ArrayList<PartitionGroup>(size);
        for (int i = 0; i < size; ++i) {
            partitionGroups.add(Serializer.readPartitionGroup((ByteBuf)buffer, (int)header.getVersion()));
        }
        addTopic.partitiionGroups(partitionGroups);
        return addTopic;
    }

    public void encode(AddTopic payload, ByteBuf buffer) throws Exception {
        Serializer.write((Topic)payload.getTopic(), (ByteBuf)buffer);
        List<PartitionGroup> partitionGroupList = payload.getPartitionGroups();
        buffer.writeInt(partitionGroupList.size());
        for (PartitionGroup group : partitionGroupList) {
            Serializer.write((PartitionGroup)group, (ByteBuf)buffer, (int)payload.getHeader().getVersion());
        }
    }

    public int type() {
        return 27;
    }
}

